/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.Arrays;
import water.DKV;
import water.Job;
import water.Key;
import water.fvec.CreateInteractions;
import water.fvec.Frame;
import water.util.Log;
import water.util.PrettyPrint;

public class Interaction
extends Job<Frame> {
    public Key<Frame> _source_frame;
    public String[] _factor_columns;
    public boolean _pairwise = false;
    public int _max_factors = 100;
    public int _min_occurrence = 1;
    public transient int[] _factors = new int[0];

    public Interaction(Key<Frame> dest, String desc) {
        super(dest, desc == null ? "CreateFrame" : desc);
    }

    public Interaction() {
        super(Key.make(), "CreateFrame");
    }

    public Frame execImpl() {
        Frame source_frame = (Frame)DKV.getGet(this._source_frame);
        assert (source_frame != null);
        if (this._factor_columns == null || this._factor_columns.length == 0) {
            throw new IllegalArgumentException("factor_columns must be specified.");
        }
        if (this._pairwise && this._factor_columns.length < 3) {
            Log.info("Ignoring the pairwise option, requires 3 or more factors.");
        }
        this._factors = new int[this._factor_columns.length];
        int count = 0;
        for (String v : this._factor_columns) {
            int idx = source_frame.find(v);
            if (idx >= 0) {
                if (!source_frame.vecs()[idx].isCategorical()) {
                    throw new IllegalArgumentException("Column " + v + " is not categorical.");
                }
            } else {
                throw new IllegalArgumentException("Column " + v + " not found.");
            }
            this._factors[count++] = idx;
        }
        CreateInteractions in = new CreateInteractions(this, this._key);
        Frame frame = (Frame)this.start(in, in.work(), true).get();
        return frame;
    }

    public String toString() {
        Frame res = (Frame)this.get();
        if (res == null) {
            return "Output frame not found";
        }
        if (!this._pairwise) {
            return "Created interaction feature " + res.names()[0] + " (order: " + this._factors.length + ") with " + res.lastVec().domain().length + " factor levels" + " in" + PrettyPrint.msecs(this._end_time - this._start_time, true);
        }
        return "Created " + res.numCols() + " pair-wise interaction features " + Arrays.deepToString(res.names()) + " (order: 2) in" + PrettyPrint.msecs(this._end_time - this._start_time, true);
    }
}

