/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.ConfusionMatrix;
import hex.Distribution;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ScoreKeeper;
import hex.genmodel.GenModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.BinomialModelPrediction;
import hex.genmodel.easy.prediction.ClusteringModelPrediction;
import hex.genmodel.easy.prediction.MultinomialModelPrediction;
import hex.genmodel.easy.prediction.RegressionModelPrediction;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.joda.time.DateTime;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.Lockable;
import water.MRTask;
import water.MemoryManager;
import water.Weaver;
import water.api.StreamWriter;
import water.codegen.CodeGenerator;
import water.codegen.CodeGeneratorPipeline;
import water.exceptions.JCodeSB;
import water.fvec.C0DChunk;
import water.fvec.CategoricalWrappedVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.JCodeGen;
import water.util.LineLimitOutputStreamWrapper;
import water.util.Log;
import water.util.MathUtils;
import water.util.SBPrintStream;
import water.util.TwoDimTable;

public abstract class Model<M extends Model<M, P, O>, P extends Parameters, O extends Output>
extends Lockable<M> {
    public P _parms;
    public String[] _warnings = new String[0];
    public O _output;

    public final double defaultThreshold() {
        if (((Output)this._output).nclasses() != 2 || ((Output)this._output)._training_metrics == null) {
            return 0.5;
        }
        if (((Output)this._output)._validation_metrics != null && ((ModelMetricsBinomial)((Output)this._output)._validation_metrics)._auc != null) {
            return ((ModelMetricsBinomial)((Output)this._output)._validation_metrics)._auc.defaultThreshold();
        }
        if (((Output)this._output)._training_metrics != null && ((ModelMetricsBinomial)((Output)this._output)._training_metrics)._auc != null) {
            return ((ModelMetricsBinomial)((Output)this._output)._training_metrics)._auc.defaultThreshold();
        }
        return 0.5;
    }

    public final boolean isSupervised() {
        return ((Output)this._output).isSupervised();
    }

    public void addWarning(String s) {
        this._warnings = Arrays.copyOf(this._warnings, this._warnings.length + 1);
        this._warnings[this._warnings.length - 1] = s;
    }

    public ModelMetrics addMetrics(ModelMetrics mm) {
        return ((Output)this._output).addModelMetrics(mm);
    }

    public abstract ModelMetrics.MetricBuilder makeMetricBuilder(String[] var1);

    public Model(Key selfKey, P parms, O output) {
        super(selfKey);
        this._parms = parms;
        assert (parms != null);
        this._output = output;
    }

    public double deviance(double w, double y, double f) {
        return new Distribution(Distribution.Family.gaussian).deviance(w, y, f);
    }

    public String[] adaptTestForTrain(Frame test, boolean expensive, boolean computeMetrics) {
        return Model.adaptTestForTrain(((Output)this._output)._names, ((Output)this._output).weightsName(), ((Output)this._output).offsetName(), ((Output)this._output).foldName(), ((Output)this._output).responseName(), ((Output)this._output)._domains, test, ((Parameters)this._parms).missingColumnsType(), expensive, computeMetrics);
    }

    public static String[] adaptTestForTrain(String[] names, String weights, String offset, String fold, String response, String[][] domains, Frame test, double missing, boolean expensive, boolean computeMetrics) throws IllegalArgumentException {
        if (test == null) {
            return new String[0];
        }
        String[][] tdomains = test.domains();
        if (names == test._names && domains == tdomains) {
            return new String[0];
        }
        if (Arrays.equals(names, test._names) && Arrays.deepEquals((Object[])domains, (Object[])tdomains)) {
            return new String[0];
        }
        ArrayList<String> msgs = new ArrayList<String>();
        Vec[] vvecs = new Vec[names.length];
        int good = 0;
        int convNaN = 0;
        for (int i = 0; i < names.length; ++i) {
            boolean isFold;
            Vec vec = test.vec(names[i]);
            boolean isResponse = response != null && names[i].equals(response);
            boolean isWeights = weights != null && names[i].equals(weights);
            boolean isOffset = offset != null && names[i].equals(offset);
            boolean bl = isFold = fold != null && names[i].equals(fold);
            if (vec == null && isResponse && computeMetrics) {
                throw new IllegalArgumentException("Test/Validation dataset is missing response vector '" + response + "'");
            }
            if (vec == null && isOffset) {
                throw new IllegalArgumentException("Test/Validation dataset is missing offset vector '" + offset + "'");
            }
            if (vec == null && isWeights && computeMetrics && expensive) {
                vec = test.anyVec().makeCon(1.0);
                msgs.add(H2O.technote(1, "Test/Validation dataset is missing the weights column '" + names[i] + "' (needed because a response was found and metrics are to be computed): substituting in a column of 1s"));
            }
            if (vec == null) {
                String str = null;
                if (expensive) {
                    if (isFold) {
                        str = "Test/Validation dataset is missing fold column '" + names[i] + "': substituting in a column of 0s";
                        vec = test.anyVec().makeCon(0.0);
                    } else {
                        str = "Test/Validation dataset is missing training column '" + names[i] + "': substituting in a column of NAs";
                        vec = test.anyVec().makeCon(missing);
                        ++convNaN;
                    }
                    vec.setDomain(domains[i]);
                }
                msgs.add(str);
            }
            if (vec != null) {
                if (domains[i] != null) {
                    if (vec.domain() != domains[i] && !Arrays.equals(vec.domain(), domains[i])) {
                        CategoricalWrappedVec evec;
                        try {
                            evec = vec.adaptTo(domains[i]);
                        }
                        catch (NumberFormatException nfe) {
                            throw new IllegalArgumentException("Test/Validation dataset has a non-categorical column '" + names[i] + "' which is categorical in the training data");
                        }
                        String[] ds = evec.domain();
                        assert (ds != null && ds.length >= domains[i].length);
                        if (isResponse && vec.domain() != null && ds.length == domains[i].length + vec.domain().length) {
                            throw new IllegalArgumentException("Test/Validation dataset has a categorical response column '" + names[i] + "' with no levels in common with the model");
                        }
                        if (ds.length > domains[i].length) {
                            msgs.add("Test/Validation dataset column '" + names[i] + "' has levels not trained on: " + Arrays.toString(Arrays.copyOfRange(ds, domains[i].length, ds.length)));
                        }
                        if (expensive) {
                            vec = evec;
                            ++good;
                        } else {
                            evec.remove();
                            vec = null;
                        }
                    } else {
                        ++good;
                    }
                } else {
                    if (vec.isCategorical()) {
                        throw new IllegalArgumentException("Test/Validation dataset has categorical column '" + names[i] + "' which is real-valued in the training data");
                    }
                    ++good;
                }
            }
            vvecs[i] = vec;
        }
        if (good == convNaN) {
            throw new IllegalArgumentException("Test/Validation dataset has no columns in common with the training set");
        }
        if (good == names.length || response != null && test.find(response) == -1 && good == names.length - 1) {
            test.restructure(names, vvecs, good);
        }
        return msgs.toArray(new String[msgs.size()]);
    }

    public Frame score(Frame fr) throws IllegalArgumentException {
        return this.score(fr, null);
    }

    public Frame score(Frame fr, String destination_key) throws IllegalArgumentException {
        Frame adaptFr = new Frame(fr);
        boolean computeMetrics = !this.isSupervised() || adaptFr.find(((Output)this._output).responseName()) != -1;
        this.adaptTestForTrain(adaptFr, true, computeMetrics);
        Frame output = this.predictScoreImpl(fr, adaptFr, destination_key);
        Vec predicted = output.vecs()[0];
        Object[] mdomain = predicted.domain();
        if (((Output)this._output).isClassifier() && computeMetrics) {
            Object[] sdomain;
            Vec actual;
            ModelMetrics mm = ModelMetrics.getFromDKV(this, fr);
            ConfusionMatrix cm = mm.cm();
            if (cm != null && cm._domain != null && cm._cm.length < ((Parameters)this._parms)._max_confusion_matrix_size) {
                Log.info(cm.table().toString(1));
            }
            if (mm.hr() != null) {
                Log.info(ModelMetricsMultinomial.getHitRatioTable(mm.hr()));
            }
            if ((actual = fr.vec(((Output)this._output).responseName())) != null && (sdomain = actual.domain()) != null && mdomain != sdomain && !Arrays.equals(mdomain, sdomain)) {
                output.replace(0, new CategoricalWrappedVec(actual.group().addVec(), actual._rowLayout, (String[])sdomain, predicted._key));
            }
        }
        Model.cleanup_adapt(adaptFr, fr);
        return output;
    }

    protected static void cleanup_adapt(Frame adaptFr, Frame fr) {
        Key[] keys = adaptFr.keys();
        for (int i = 0; i < keys.length; ++i) {
            if (fr.find(keys[i]) == -1) continue;
            keys[i] = null;
        }
        adaptFr.delete();
    }

    protected Frame predictScoreImpl(Frame fr, Frame adaptFrm, String destination_key) {
        boolean computeMetrics = !this.isSupervised() || adaptFrm.find(((Output)this._output).responseName()) != -1;
        int nc = ((Output)this._output).nclasses();
        int ncols = nc == 1 ? 1 : nc + 1;
        String[] names = new String[ncols];
        String[][] domains = new String[ncols][];
        names[0] = "predict";
        for (int i = 1; i < names.length; ++i) {
            names[i] = ((Output)this._output).classNames()[i - 1];
            try {
                Integer.valueOf(names[i]);
                names[i] = "p" + names[i];
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        domains[0] = nc == 1 ? null : (!computeMetrics ? ((Output)this._output)._domains[((Output)this._output)._domains.length - 1] : adaptFrm.lastVec().domain());
        BigScore bs = (BigScore)new BigScore(domains[0], ncols, adaptFrm.means(), ((Output)this._output).hasWeights() && adaptFrm.find(((Output)this._output).weightsName()) >= 0, computeMetrics, true).doAll(ncols, (byte)3, adaptFrm);
        if (computeMetrics) {
            bs._mb.makeModelMetrics(this, fr);
        }
        return bs.outputFrame(null == destination_key ? Key.make() : Key.make(destination_key), names, domains);
    }

    protected ModelMetrics.MetricBuilder scoreMetrics(Frame adaptFrm) {
        boolean computeMetrics = !this.isSupervised() || adaptFrm.find(((Output)this._output).responseName()) != -1;
        int nc = ((Output)this._output).nclasses();
        int ncols = nc == 1 ? 1 : nc + 1;
        String[] names = new String[ncols];
        String[][] domains = new String[ncols][];
        names[0] = "predict";
        for (int i = 1; i < names.length; ++i) {
            names[i] = ((Output)this._output).classNames()[i - 1];
            try {
                Integer.valueOf(names[i]);
                names[i] = "p" + names[i];
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        domains[0] = nc == 1 ? null : (!computeMetrics ? ((Output)this._output)._domains[((Output)this._output)._domains.length - 1] : adaptFrm.lastVec().domain());
        BigScore bs = (BigScore)new BigScore(domains[0], ncols, adaptFrm.means(), ((Output)this._output).hasWeights() && adaptFrm.find(((Output)this._output).weightsName()) >= 0, computeMetrics, false).doAll(adaptFrm);
        return bs._mb;
    }

    public double[] score0(Chunk[] chks, int row_in_chunk, double[] tmp, double[] preds) {
        return this.score0(chks, 1.0, 0.0, row_in_chunk, tmp, preds);
    }

    public double[] score0(Chunk[] chks, double weight, double offset, int row_in_chunk, double[] tmp, double[] preds) {
        assert (((Output)this._output).nfeatures() == tmp.length);
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = chks[i].atd(row_in_chunk);
        }
        double[] scored = this.score0(tmp, preds, weight, offset);
        if (this.isSupervised() && ((Output)this._output).isClassifier()) {
            if (((Parameters)this._parms)._balance_classes) {
                GenModel.correctProbabilities((double[])scored, (double[])((Output)this._output)._priorClassDist, (double[])((Output)this._output)._modelClassDist);
            }
            scored[0] = GenModel.getPrediction((double[])scored, (double[])((Output)this._output)._priorClassDist, (double[])tmp, (double)this.defaultThreshold());
        }
        return scored;
    }

    protected abstract double[] score0(double[] var1, double[] var2);

    protected double[] score0(double[] data, double[] preds, double weight, double offset) {
        assert (weight == 1.0 && offset == 0.0) : "Override this method for non-trivial weight/offset!";
        return this.score0(data, preds);
    }

    public double score(double[] data) {
        return ArrayUtils.maxIndex(this.score0(data, new double[((Output)this._output).nclasses()]));
    }

    @Override
    protected Futures remove_impl(Futures fs) {
        if (((Output)this._output)._model_metrics != null) {
            for (Key k : ((Output)this._output)._model_metrics) {
                k.remove(fs);
            }
        }
        return fs;
    }

    @Override
    protected long checksum_impl() {
        return ((Parameters)this._parms).checksum_impl() * ((Output)this._output).checksum_impl();
    }

    public final String toJava(boolean preview, boolean verboseCode) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(Short.MAX_VALUE);
        this.toJava(os, preview, verboseCode);
        return os.toString();
    }

    public final SBPrintStream toJava(OutputStream os, boolean preview, boolean verboseCode) {
        if (preview) {
            os = new LineLimitOutputStreamWrapper(os, 1000);
        }
        return this.toJava(new SBPrintStream(os), preview, verboseCode);
    }

    protected SBPrintStream toJava(SBPrintStream sb, boolean isGeneratingPreview, boolean verboseCode) {
        CodeGeneratorPipeline fileCtx = new CodeGeneratorPipeline();
        String modelName = JCodeGen.toJavaId(this._key.toString());
        sb.p("/*").nl();
        sb.p("  Licensed under the Apache License, Version 2.0").nl();
        sb.p("    http://www.apache.org/licenses/LICENSE-2.0.html").nl();
        sb.nl();
        sb.p("  AUTOGENERATED BY H2O at ").p(new DateTime().toString()).nl();
        sb.p("  ").p(H2O.ABV.projectVersion()).nl();
        sb.p("  ").nl();
        sb.p("  Standalone prediction code with sample test data for ").p(this.getClass().getSimpleName()).p(" named ").p(modelName).nl();
        sb.nl();
        sb.p("  How to download, compile and execute:").nl();
        sb.p("      mkdir tmpdir").nl();
        sb.p("      cd tmpdir").nl();
        sb.p("      curl http:/").p(H2O.SELF.toString()).p("/3/h2o-genmodel.jar > h2o-genmodel.jar").nl();
        sb.p("      curl http:/").p(H2O.SELF.toString()).p("/3/Models.java/").pobj(this._key).p(" > ").p(modelName).p(".java").nl();
        sb.p("      javac -cp h2o-genmodel.jar -J-Xmx2g -J-XX:MaxPermSize=128m ").p(modelName).p(".java").nl();
        sb.nl();
        sb.p("     (Note:  Try java argument -XX:+PrintCompilation to show runtime JIT compiler behavior.)").nl();
        if (((Parameters)this._parms)._offset_column != null) {
            sb.nl();
            sb.nl();
            sb.nl();
            sb.p("  NOTE:  Java model export does not support offset_column.").nl();
            sb.nl();
            Log.warn("Java model export does not support offset_column.");
        }
        if (isGeneratingPreview && this.toJavaCheckTooBig()) {
            sb.nl();
            sb.nl();
            sb.nl();
            sb.p("  NOTE:  Java model is too large to preview, please download as shown above.").nl();
            sb.nl();
            return sb;
        }
        sb.p("*/").nl();
        sb.p("import java.util.Map;").nl();
        sb.p("import hex.genmodel.GenModel;").nl();
        sb.p("import hex.genmodel.annotations.ModelPojo;").nl();
        sb.nl();
        String algo = this.getClass().getSimpleName().toLowerCase().replace("model", "");
        sb.p("@ModelPojo(name=\"").p(modelName).p("\", algorithm=\"").p(algo).p("\")").nl();
        sb.p("public class ").p(modelName).p(" extends GenModel {").nl().ii(1);
        sb.ip("public hex.ModelCategory getModelCategory() { return hex.ModelCategory." + ((Output)this._output).getModelCategory() + "; }").nl();
        this.toJavaInit(sb, fileCtx).nl();
        this.toJavaNAMES(sb, fileCtx);
        this.toJavaNCLASSES(sb);
        this.toJavaDOMAINS(sb, fileCtx);
        this.toJavaPROB(sb);
        this.toJavaSuper(modelName, sb);
        sb.p("  public String getUUID() { return Long.toString(" + this.checksum() + "L); }").nl();
        this.toJavaPredict(sb, fileCtx, verboseCode);
        sb.p("}").nl().di(1);
        fileCtx.generate(sb);
        sb.nl();
        return sb;
    }

    protected SBPrintStream toJavaSuper(String modelName, SBPrintStream sb) {
        return sb.nl().ip("public " + modelName + "() { super(NAMES,DOMAINS); }").nl();
    }

    private SBPrintStream toJavaNAMES(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        String modelName = JCodeGen.toJavaId(this._key.toString());
        final String namesHolderClassName = "NamesHolder_" + modelName;
        sb.i().p("// ").p("Names of columns used by model.").nl();
        sb.i().p("public static final String[] NAMES = " + namesHolderClassName + ".VALUES;").nl();
        fileCtx.add(new CodeGenerator(){

            @Override
            public void generate(JCodeSB out) {
                out.i().p("// The class representing training column names").nl();
                JCodeGen.toClassWithArray(out, null, namesHolderClassName, Arrays.copyOf(((Output)Model.this._output)._names, ((Output)Model.this._output).nfeatures()));
            }
        });
        return sb;
    }

    protected SBPrintStream toJavaNCLASSES(SBPrintStream sb) {
        return ((Output)this._output).isClassifier() ? JCodeGen.toStaticVar(sb, "NCLASSES", ((Output)this._output).nclasses(), "Number of output classes included in training data response column.") : sb;
    }

    private SBPrintStream toJavaDOMAINS(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        String modelName = JCodeGen.toJavaId(this._key.toString());
        sb.nl();
        sb.ip("// Column domains. The last array contains domain of response column.").nl();
        sb.ip("public static final String[][] DOMAINS = new String[][] {").nl();
        for (int i = 0; i < ((Output)this._output)._domains.length; ++i) {
            final int idx = i;
            final String[] dom = ((Output)this._output)._domains[i];
            final String colInfoClazz = modelName + "_ColInfo_" + i;
            sb.i(1).p("/* ").p(((Output)this._output)._names[i]).p(" */ ");
            if (dom != null) {
                sb.p(colInfoClazz).p(".VALUES");
            } else {
                sb.p("null");
            }
            if (i != ((Output)this._output)._domains.length - 1) {
                sb.p(',');
            }
            sb.nl();
            if (dom == null) continue;
            fileCtx.add(new CodeGenerator(){

                @Override
                public void generate(JCodeSB out) {
                    out.ip("// The class representing column ").p(((Output)Model.this._output)._names[idx]).nl();
                    JCodeGen.toClassWithArray(out, null, colInfoClazz, dom);
                }
            });
        }
        return sb.ip("};").nl();
    }

    protected SBPrintStream toJavaPROB(SBPrintStream sb) {
        if (this.isSupervised()) {
            JCodeGen.toStaticVar((JCodeSB)sb, "PRIOR_CLASS_DISTRIB", ((Output)this._output)._priorClassDist, "Prior class distribution");
            JCodeGen.toStaticVar((JCodeSB)sb, "MODEL_CLASS_DISTRIB", ((Output)this._output)._modelClassDist, "Class distribution used for model building");
        }
        return sb;
    }

    protected boolean toJavaCheckTooBig() {
        Log.warn("toJavaCheckTooBig must be overridden for this model type to render it in the browser");
        return true;
    }

    protected SBPrintStream toJavaInit(SBPrintStream sb, CodeGeneratorPipeline fileContext) {
        return sb;
    }

    protected void toJavaPredictBody(SBPrintStream body, CodeGeneratorPipeline classCtx, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        throw new IllegalArgumentException("This model type does not support conversion to Java");
    }

    private SBPrintStream toJavaPredict(SBPrintStream ccsb, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        ccsb.nl();
        ccsb.ip("// Pass in data in a double[], pre-aligned to the Model's requirements.").nl();
        ccsb.ip("// Jam predictions into the preds[] array; preds[0] is reserved for the").nl();
        ccsb.ip("// main prediction (class for classifiers or value for regression),").nl();
        ccsb.ip("// and remaining columns hold a probability distribution for classifiers.").nl();
        ccsb.ip("public final double[] score0( double[] data, double[] preds ) {").nl();
        CodeGeneratorPipeline classCtx = new CodeGeneratorPipeline();
        this.toJavaPredictBody(ccsb.ii(1), classCtx, fileCtx, verboseCode);
        ccsb.ip("return preds;").nl();
        ccsb.di(1).ip("}").nl();
        classCtx.generate(ccsb.ii(1));
        ccsb.di(1);
        return ccsb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testJavaScoring(Frame data, Frame model_predictions, double rel_epsilon) {
        assert (data.numRows() == model_predictions.numRows());
        Frame fr = new Frame(data);
        boolean computeMetrics = data.find(((Output)this._output).responseName()) != -1;
        try {
            GenModel genmodel;
            Object[] warns = this.adaptTestForTrain(fr, true, computeMetrics);
            if (warns.length > 0) {
                System.err.println(Arrays.toString(warns));
            }
            int[] omap = null;
            if (((Output)this._output).isClassifier()) {
                Vec actual = fr.vec(((Output)this._output).responseName());
                Object[] sdomain = actual == null ? null : actual.domain();
                Object[] mdomain = model_predictions.vec(0).domain();
                if (sdomain != null && mdomain != sdomain && !Arrays.equals(mdomain, sdomain)) {
                    omap = CategoricalWrappedVec.computeMap((String[])mdomain, (String[])sdomain);
                }
            }
            String modelName = JCodeGen.toJavaId(this._key.toString());
            boolean preview = false;
            String java_text = this.toJava(preview, true);
            try {
                Class clz = JCodeGen.compile(modelName, java_text);
                genmodel = (GenModel)clz.newInstance();
            }
            catch (Exception e) {
                throw H2O.fail("Internal POJO compilation failed", e);
            }
            Vec[] dvecs = fr.vecs();
            Vec[] pvecs = model_predictions.vecs();
            double[] features = MemoryManager.malloc8d(genmodel._names.length);
            double[] predictions = MemoryManager.malloc8d(genmodel.nclasses() + 1);
            int totalMiss = 0;
            int miss = 0;
            int row = 0;
            while ((long)row < fr.numRows()) {
                int col;
                for (col = 0; col < features.length; ++col) {
                    features[col] = dvecs[col].at(row);
                }
                genmodel.score0(features, predictions);
                for (col = 0; col < pvecs.length; ++col) {
                    double d = pvecs[col].at(row);
                    if (col == 0 && omap != null) {
                        d = omap[(int)d];
                    }
                    if (MathUtils.compare(predictions[col], d, 1.0E-15, rel_epsilon) || miss++ >= 10) continue;
                    System.err.println("Predictions mismatch, row " + row + ", col " + model_predictions._names[col] + ", internal prediction=" + d + ", POJO prediction=" + predictions[col]);
                }
                totalMiss = miss;
                ++row;
            }
            row = 0;
            while ((long)row < fr.numRows()) {
                RowData rowData = new RowData();
                for (int col = 0; col < features.length; ++col) {
                    double val = dvecs[col].at(row);
                    rowData.put((Object)genmodel._names[col], genmodel._domains[col] == null ? Double.valueOf(val) : ((int)val < genmodel._domains[col].length ? genmodel._domains[col][(int)val] : "UnknownLevel"));
                }
                EasyPredictModelWrapper epmw = new EasyPredictModelWrapper(genmodel);
                ClusteringModelPrediction p = null;
                if (genmodel.getModelCategory() != ModelCategory.AutoEncoder) {
                    try {
                        p = epmw.predictClustering(rowData);
                    }
                    catch (PredictException e) {
                        // empty catch block
                    }
                    try {
                        if (p == null) {
                            p = epmw.predictRegression(rowData);
                        }
                    }
                    catch (PredictException e) {
                        // empty catch block
                    }
                    try {
                        if (p == null) {
                            p = epmw.predictBinomial(rowData);
                        }
                    }
                    catch (PredictException e) {
                        // empty catch block
                    }
                    try {
                        if (p == null) {
                            p = epmw.predictMultinomial(rowData);
                        }
                    }
                    catch (PredictException e) {
                        // empty catch block
                    }
                    if (p != null) {
                        int oldmiss = miss;
                        for (int col = 0; col < pvecs.length; ++col) {
                            double d = pvecs[col].at(row);
                            if (col == 0 && omap != null) {
                                d = omap[(int)d];
                            }
                            if (genmodel.getModelCategory() == ModelCategory.Clustering && !MathUtils.compare(p.cluster, d, 1.0E-15, rel_epsilon)) {
                                ++miss;
                            }
                            if (genmodel.getModelCategory() == ModelCategory.Regression && !MathUtils.compare(((RegressionModelPrediction)p).value, d, 1.0E-15, rel_epsilon)) {
                                ++miss;
                            }
                            if (genmodel.getModelCategory() == ModelCategory.Binomial) {
                                if (col == 0) {
                                    if (!MathUtils.compare(((BinomialModelPrediction)p).labelIndex, d, 1.0E-15, rel_epsilon)) {
                                        ++miss;
                                    }
                                } else if (!MathUtils.compare(((BinomialModelPrediction)p).classProbabilities[col - 1], d, 1.0E-15, rel_epsilon)) {
                                    ++miss;
                                }
                            }
                            if (genmodel.getModelCategory() == ModelCategory.Multinomial) {
                                if (col == 0) {
                                    if (!MathUtils.compare(((MultinomialModelPrediction)p).labelIndex, d, 1.0E-15, rel_epsilon)) {
                                        ++miss;
                                    }
                                } else if (!MathUtils.compare(((MultinomialModelPrediction)p).classProbabilities[col - 1], d, 1.0E-15, rel_epsilon)) {
                                    ++miss;
                                }
                            }
                            if (miss > oldmiss) {
                                System.err.println("EasyPredict Predictions mismatch, row " + row + ", col " + model_predictions._names[col] + ", internal prediction=" + d + ", POJO prediction=" + predictions[col]);
                            }
                            totalMiss = miss;
                        }
                    }
                }
                ++row;
            }
            if (totalMiss != 0) {
                System.err.println("Number of mismatches: " + totalMiss);
            }
            boolean bl = totalMiss == 0;
            return bl;
        }
        finally {
            Model.cleanup_adapt(fr, data);
        }
    }

    @Override
    public List<Key> getPublishedKeys() {
        List<Key> p = Arrays.asList(((Output)this._output)._model_metrics);
        p.addAll(super.getPublishedKeys());
        return p;
    }

    @Override
    public void delete() {
        super.delete();
    }

    public void deleteCrossValidationModels() {
        if (((Output)this._output)._cross_validation_models != null) {
            for (Key k : ((Output)this._output)._cross_validation_models) {
                Model m = (Model)DKV.getGet(k);
                if (m == null) continue;
                m.delete();
            }
        }
    }

    public String toString() {
        return ((Output)this._output).toString();
    }

    public class JavaModelStreamWriter
    extends StreamWriter {
        private final boolean preview;

        public JavaModelStreamWriter(boolean preview) {
            this.preview = preview;
        }

        @Override
        public void writeTo(OutputStream os) {
            Model.this.toJava(os, this.preview, true);
        }
    }

    private class BigScore
    extends MRTask<BigScore> {
        final String[] _domain;
        final int _npredcols;
        ModelMetrics.MetricBuilder _mb;
        final double[] _mean;
        final boolean _computeMetrics;
        final boolean _hasWeights;
        final boolean _makePreds;

        BigScore(String[] domain, int ncols, double[] mean, boolean testHasWeights, boolean computeMetrics, boolean makePreds) {
            this._domain = domain;
            this._npredcols = ncols;
            this._mean = mean;
            this._computeMetrics = computeMetrics;
            this._makePreds = makePreds;
            if (((Output)Model.this._output)._hasWeights && this._computeMetrics && !testHasWeights) {
                throw new IllegalArgumentException("Missing weights when computing validation metrics.");
            }
            this._hasWeights = testHasWeights;
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] cpreds) {
            if (this.isCancelled()) {
                return;
            }
            Chunk weightsChunk = this._hasWeights && this._computeMetrics ? chks[((Output)Model.this._output).weightsIdx()] : new C0DChunk(1.0, chks[0]._len);
            Chunk offsetChunk = ((Output)Model.this._output).hasOffset() ? chks[((Output)Model.this._output).offsetIdx()] : new C0DChunk(0.0, chks[0]._len);
            Chunk responseChunk = null;
            double[] tmp = new double[((Output)Model.this._output).nfeatures()];
            float[] actual = null;
            this._mb = Model.this.makeMetricBuilder(this._domain);
            if (this._computeMetrics) {
                if (Model.this.isSupervised()) {
                    actual = new float[1];
                    responseChunk = chks[((Output)Model.this._output).responseIdx()];
                } else {
                    actual = new float[chks.length];
                }
            }
            double[] preds = this._mb._work;
            int len = chks[0]._len;
            for (int row = 0; row < len; ++row) {
                double weight = weightsChunk.atd(row);
                if (weight == 0.0) {
                    if (!this._makePreds) continue;
                    for (int c = 0; c < this._npredcols; ++c) {
                        cpreds[c].addNum(0.0);
                    }
                    continue;
                }
                double offset = offsetChunk.atd(row);
                double[] p = Model.this.score0(chks, weight, offset, row, tmp, preds);
                if (this._computeMetrics) {
                    if (Model.this.isSupervised()) {
                        actual[0] = (float)responseChunk.atd(row);
                    } else {
                        for (int i = 0; i < actual.length; ++i) {
                            actual[i] = (float)chks[i].atd(row);
                        }
                    }
                    this._mb.perRow(preds, actual, weight, offset, Model.this);
                }
                if (!this._makePreds) continue;
                for (int c = 0; c < this._npredcols; ++c) {
                    cpreds[c].addNum(p[c]);
                }
            }
        }

        @Override
        public void reduce(BigScore bs) {
            if (this._mb != null) {
                this._mb.reduce(bs._mb);
            }
        }

        @Override
        protected void postGlobal() {
            if (this._mb != null) {
                this._mb.postGlobal();
            }
        }
    }

    public static abstract class Output
    extends Iced {
        public String[] _names;
        public Key[] _cross_validation_models;
        public Key[] _cross_validation_predictions;
        public String[][] _domains;
        Key[] _model_metrics = new Key[0];
        public Job.JobState _status;
        public long _start_time;
        public long _end_time;
        public long _run_time;
        public ModelMetrics _training_metrics;
        public ModelMetrics _validation_metrics;
        public ModelMetrics _cross_validation_metrics;
        public TwoDimTable _model_summary;
        public TwoDimTable _scoring_history;
        protected boolean _isSupervised;
        protected final boolean _hasOffset;
        protected final boolean _hasWeights;
        protected final boolean _hasFold;
        public double[] _distribution;
        public double[] _modelClassDist;
        public double[] _priorClassDist;

        public Output() {
            this(false, false, false);
        }

        public Output(boolean hasWeights, boolean hasOffset, boolean hasFold) {
            this._hasWeights = hasWeights;
            this._hasOffset = hasOffset;
            this._hasFold = hasFold;
        }

        public Output(ModelBuilder b) {
            if (b == null) {
                this._hasOffset = false;
                this._hasWeights = false;
                this._hasFold = false;
                return;
            }
            this._isSupervised = b.isSupervised();
            if (b.error_count() > 0) {
                throw new IllegalArgumentException(b.validationErrors());
            }
            this._names = b._train.names();
            this._domains = b._train.domains();
            this._hasOffset = b.hasOffsetCol();
            this._hasWeights = b.hasWeightCol();
            this._hasFold = b.hasFoldCol();
            this._distribution = b._distribution;
            this._priorClassDist = b._priorClassDist;
        }

        public int nfeatures() {
            return this._names.length - (this._hasOffset ? 1 : 0) - (this._hasWeights ? 1 : 0) - (this._hasFold ? 1 : 0) - (this.isSupervised() ? 1 : 0);
        }

        public boolean isSupervised() {
            return this._isSupervised;
        }

        public boolean hasOffset() {
            return this._hasOffset;
        }

        public boolean hasWeights() {
            return this._hasWeights;
        }

        public boolean hasFold() {
            return this._hasFold;
        }

        public String responseName() {
            return this.isSupervised() ? this._names[this.responseIdx()] : null;
        }

        public String weightsName() {
            return this._hasWeights ? this._names[this.weightsIdx()] : null;
        }

        public String offsetName() {
            return this._hasOffset ? this._names[this.offsetIdx()] : null;
        }

        public String foldName() {
            return this._hasFold ? this._names[this.foldIdx()] : null;
        }

        public int weightsIdx() {
            if (!this._hasWeights) {
                return -1;
            }
            return this._names.length - (this.isSupervised() ? 1 : 0) - (this.hasOffset() ? 1 : 0) - 1 - (this.hasFold() ? 1 : 0);
        }

        public int offsetIdx() {
            if (!this._hasOffset) {
                return -1;
            }
            return this._names.length - (this.isSupervised() ? 1 : 0) - (this.hasFold() ? 1 : 0) - 1;
        }

        public int foldIdx() {
            if (!this._hasFold) {
                return -1;
            }
            return this._names.length - (this.isSupervised() ? 1 : 0) - 1;
        }

        public int responseIdx() {
            if (!this.isSupervised()) {
                return -1;
            }
            return this._names.length - 1;
        }

        public String[] classNames() {
            assert (this.isSupervised());
            return this._domains[this._domains.length - 1];
        }

        public boolean isClassifier() {
            return this.isSupervised() && this.nclasses() > 1;
        }

        public int nclasses() {
            assert (this.isSupervised());
            String[] cns = this.classNames();
            return cns == null ? 1 : cns.length;
        }

        public ModelCategory getModelCategory() {
            if (this.isSupervised()) {
                return this.isClassifier() ? (this.nclasses() > 2 ? ModelCategory.Multinomial : ModelCategory.Binomial) : ModelCategory.Regression;
            }
            return ModelCategory.Unknown;
        }

        public synchronized ModelMetrics addModelMetrics(ModelMetrics mm) {
            DKV.put(mm);
            for (Key key : this._model_metrics) {
                if (key != mm._key) continue;
                return mm;
            }
            this._model_metrics = Arrays.copyOf(this._model_metrics, this._model_metrics.length + 1);
            this._model_metrics[this._model_metrics.length - 1] = mm._key;
            return mm;
        }

        public synchronized void clearModelMetrics() {
            this._model_metrics = new Key[0];
        }

        long checksum_impl() {
            return (null == this._names ? 13 : Arrays.hashCode(this._names)) * (null == this._domains ? 17 : Arrays.deepHashCode((Object[])this._domains)) * this.getModelCategory().ordinal();
        }

        public void printTwoDimTables(StringBuilder sb, Object o) {
            for (Field f : Weaver.getWovenFields(o.getClass())) {
                Class<TwoDimTable> c = f.getType();
                if (!c.isAssignableFrom(TwoDimTable.class)) continue;
                try {
                    TwoDimTable t = (TwoDimTable)f.get(this);
                    f.setAccessible(true);
                    if (t == null) continue;
                    sb.append(t.toString(1, false));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this._training_metrics != null) {
                sb.append(this._training_metrics.toString());
            }
            if (this._validation_metrics != null) {
                sb.append(this._validation_metrics.toString());
            }
            if (this._cross_validation_metrics != null) {
                sb.append(this._cross_validation_metrics.toString());
            }
            this.printTwoDimTables(sb, this);
            return sb.toString();
        }
    }

    public static abstract class Parameters
    extends Iced {
        public static final int MAX_SUPPORTED_LEVELS = 1000;
        public Key<Model> _model_id;
        public Key<Frame> _train;
        public Key<Frame> _valid;
        public int _nfolds;
        public boolean _keep_cross_validation_predictions;
        public FoldAssignmentScheme _fold_assignment = FoldAssignmentScheme.AUTO;
        public Distribution.Family _distribution = Distribution.Family.AUTO;
        public double _tweedie_power = 1.5;
        public String[] _ignored_columns;
        public boolean _ignore_const_cols;
        public String _weights_column;
        public String _offset_column;
        public String _fold_column;
        public boolean _score_each_iteration;
        public int _stopping_rounds = 0;
        public ScoreKeeper.StoppingMetric _stopping_metric = ScoreKeeper.StoppingMetric.AUTO;
        public double _stopping_tolerance = this.defaultStoppingTolerance();
        public String _response_column;
        public boolean _balance_classes = false;
        public float _max_after_balance_size = 5.0f;
        public float[] _class_sampling_factors;
        public int _max_hit_ratio_k = 10;
        public int _max_confusion_matrix_size = 20;
        public Key<? extends Model> _checkpoint;

        protected double defaultStoppingTolerance() {
            return 0.001;
        }

        public Parameters() {
            this._ignore_const_cols = this.defaultDropConsCols();
        }

        public final Frame train() {
            return this._train == null ? null : this._train.get();
        }

        public final Frame valid() {
            return this._valid == null ? null : this._valid.get();
        }

        public void read_lock_frames(Job job) {
            Frame tr = this.train();
            if (tr != null) {
                tr.read_lock(job._key);
            }
            if (this._valid != null && !this._train.equals(this._valid)) {
                this.valid().read_lock(job._key);
            }
        }

        public void read_unlock_frames(Job job) {
            Frame tr = this.train();
            if (tr != null) {
                tr.unlock(job._key, false);
            }
            if (this._valid != null && !this._train.equals(this._valid)) {
                this.valid().unlock(job._key, false);
            }
        }

        protected boolean defaultDropNA20Cols() {
            return false;
        }

        protected boolean defaultDropConsCols() {
            return true;
        }

        public double missingColumnsType() {
            return Double.NaN;
        }

        public boolean hasCheckpoint() {
            return this._checkpoint != null;
        }

        public long checksum() {
            return this.checksum_impl();
        }

        protected long checksum_impl() {
            long xs = 24589L;
            int count = 0;
            Field[] fields = Weaver.getWovenFields(this.getClass());
            Arrays.sort(fields, new Comparator<Field>(){

                @Override
                public int compare(Field field1, Field field2) {
                    return field1.getName().compareTo(field2.getName());
                }
            });
            for (Field f : fields) {
                long P = MathUtils.PRIMES[count % MathUtils.PRIMES.length];
                Class<?> c = f.getType();
                if (c.isArray()) {
                    try {
                        f.setAccessible(true);
                        if (f.get(this) != null) {
                            Object[] arr;
                            if (c.getComponentType() == Integer.TYPE) {
                                arr = (int[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode(arr);
                            }
                            if (c.getComponentType() == Float.TYPE) {
                                arr = (float[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode((float[])arr);
                            }
                            if (c.getComponentType() == Double.TYPE) {
                                arr = (double[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode((double[])arr);
                            }
                            if (c.getComponentType() == Long.TYPE) {
                                arr = (long[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode((long[])arr);
                            }
                            arr = (Object[])f.get(this);
                            xs = xs * P + (long)Arrays.deepHashCode(arr);
                        }
                        xs *= P;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ClassCastException t) {
                        throw H2O.fail();
                    }
                } else {
                    try {
                        f.setAccessible(true);
                        Object value = f.get(this);
                        xs = value != null ? xs * P + (long)value.hashCode() : xs * P + P;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++count;
            }
            return xs ^= (this.train() == null ? 43L : this.train().checksum()) * (this.valid() == null ? 17L : this.valid().checksum());
        }

        public static enum FoldAssignmentScheme {
            AUTO,
            Random,
            Modulo,
            Stratified;

        }
    }

    public static interface DeepFeatures {
        public Frame scoreAutoEncoder(Frame var1, Key var2, boolean var3);

        public Frame scoreDeepFeatures(Frame var1, int var2);
    }
}

