/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.ModelMetricsSupervised;
import java.util.Arrays;
import water.H2O;
import water.Iced;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MathUtils;

public class ScoreKeeper
extends Iced {
    public double _r2 = Double.NaN;
    public double _mean_residual_deviance = Double.NaN;
    public double _mse = Double.NaN;
    public double _logloss = Double.NaN;
    public double _AUC = Double.NaN;
    public double _classError = Double.NaN;
    public float[] _hitratio;

    public ScoreKeeper() {
    }

    public ScoreKeeper(double mse) {
        this._mse = mse;
    }

    public ScoreKeeper(ModelMetrics mm) {
        this.fillFrom(mm);
    }

    public boolean isEmpty() {
        return Double.isNaN(this._mse) && Double.isNaN(this._logloss);
    }

    public void fillFrom(ModelMetrics m) {
        if (m == null) {
            return;
        }
        this._mse = m._MSE;
        if (m instanceof ModelMetricsSupervised) {
            this._r2 = ((ModelMetricsSupervised)m).r2();
        }
        if (m instanceof ModelMetricsRegression) {
            this._mean_residual_deviance = ((ModelMetricsRegression)m)._mean_residual_deviance;
        }
        if (m instanceof ModelMetricsBinomial) {
            this._logloss = ((ModelMetricsBinomial)m)._logloss;
            if (((ModelMetricsBinomial)m)._auc != null) {
                this._AUC = ((ModelMetricsBinomial)m)._auc._auc;
                this._classError = ((ModelMetricsBinomial)m)._auc.defaultErr();
            }
        } else if (m instanceof ModelMetricsMultinomial) {
            this._logloss = ((ModelMetricsMultinomial)m)._logloss;
            this._classError = ((ModelMetricsMultinomial)m)._cm.err();
            this._hitratio = ((ModelMetricsMultinomial)m)._hit_ratios;
        }
    }

    public boolean equals(Object that) {
        if (!(that instanceof ScoreKeeper)) {
            return false;
        }
        ScoreKeeper o = (ScoreKeeper)that;
        if (this._hitratio == null && ((ScoreKeeper)that)._hitratio != null) {
            return false;
        }
        if (this._hitratio != null && ((ScoreKeeper)that)._hitratio == null) {
            return false;
        }
        if (this._hitratio != null && ((ScoreKeeper)that)._hitratio != null) {
            if (this._hitratio.length != ((ScoreKeeper)that)._hitratio.length) {
                return false;
            }
            for (int i = 0; i < this._hitratio.length; ++i) {
                if (MathUtils.compare(this._hitratio[i], ((ScoreKeeper)that)._hitratio[i], 1.0E-6, 1.0E-6)) continue;
                return false;
            }
        }
        return MathUtils.compare(this._r2, o._r2, 1.0E-6, 1.0E-6) && MathUtils.compare(this._mean_residual_deviance, o._mean_residual_deviance, 1.0E-6, 1.0E-6) && MathUtils.compare(this._mse, o._mse, 1.0E-6, 1.0E-6) && MathUtils.compare(this._logloss, o._logloss, 1.0E-6, 1.0E-6) && MathUtils.compare(this._classError, o._classError, 1.0E-6, 1.0E-6);
    }

    public static boolean earlyStopping(ScoreKeeper[] sk, int k, boolean classification, StoppingMetric criterion, double rel_improvement) {
        if (k == 0) {
            return false;
        }
        int len = sk.length - 1;
        if (len < 2 * k) {
            return false;
        }
        if (criterion == StoppingMetric.AUTO) {
            criterion = classification ? StoppingMetric.logloss : StoppingMetric.deviance;
        }
        boolean moreIsBetter = criterion == StoppingMetric.AUC || criterion == StoppingMetric.r2;
        double[] movingAvg = new double[k + 1];
        double lastBeforeK = moreIsBetter ? -1.7976931348623157E308 : Double.MAX_VALUE;
        double bestInLastK = moreIsBetter ? -1.7976931348623157E308 : Double.MAX_VALUE;
        for (int i = 0; i < movingAvg.length; ++i) {
            movingAvg[i] = 0.0;
            int startIdx = sk.length - 2 * k + i;
            for (int j = 0; j < k; ++j) {
                double val;
                ScoreKeeper skj = sk[startIdx + j];
                switch (criterion) {
                    case AUC: {
                        val = skj._AUC;
                        break;
                    }
                    case MSE: {
                        val = skj._mse;
                        break;
                    }
                    case deviance: {
                        val = skj._mean_residual_deviance;
                        break;
                    }
                    case logloss: {
                        val = skj._logloss;
                        break;
                    }
                    case r2: {
                        val = skj._r2;
                        break;
                    }
                    case misclassification: {
                        val = skj._classError;
                        break;
                    }
                    default: {
                        throw H2O.unimpl("Undefined stopping criterion.");
                    }
                }
                int n = i;
                movingAvg[n] = movingAvg[n] + val;
            }
            int n = i;
            movingAvg[n] = movingAvg[n] / (double)k;
            if (Double.isNaN(movingAvg[i])) {
                return false;
            }
            if (i == 0) {
                lastBeforeK = movingAvg[i];
                continue;
            }
            bestInLastK = moreIsBetter ? Math.max(movingAvg[i], bestInLastK) : Math.min(movingAvg[i], bestInLastK);
        }
        if (Math.signum(ArrayUtils.maxValue(movingAvg)) != Math.signum(ArrayUtils.minValue(movingAvg))) {
            return false;
        }
        if (Math.signum(bestInLastK) != Math.signum(lastBeforeK)) {
            return false;
        }
        assert (lastBeforeK != Double.MAX_VALUE);
        assert (bestInLastK != Double.MAX_VALUE);
        Log.info("Moving averages (length " + k + ") of last " + (k + 1) + " " + criterion.toString() + " metrics: " + Arrays.toString(movingAvg));
        double ratio = bestInLastK / lastBeforeK;
        if (Double.isNaN(ratio)) {
            return false;
        }
        boolean improved = moreIsBetter ? ratio > 1.0 + rel_improvement : ratio < 1.0 - rel_improvement;
        Log.info("Checking model convergence with " + criterion.toString() + " metric: " + lastBeforeK + " --> " + bestInLastK + (improved ? " (still improving)." : " (converged)."));
        return !improved;
    }

    public static enum StoppingMetric {
        AUTO,
        deviance,
        logloss,
        MSE,
        AUC,
        r2,
        misclassification;

    }
}

