/*
 * Decompiled with CFR 0.152.
 */
package hex.grid;

import hex.Model;
import hex.ModelParametersBuilderFactory;
import java.util.Map;
import java.util.NoSuchElementException;
import water.Iced;

public interface HyperSpaceWalker<MP extends Model.Parameters> {
    public HyperSpaceIterator<MP> iterator();

    public String[] getHyperParamNames();

    public int getHyperSpaceSize();

    public MP getParams();

    public ModelParametersBuilderFactory<MP> getParametersBuilderFactory();

    public static abstract class RandomWalker<MP extends Model.Parameters>
    implements HyperSpaceWalker<MP> {
    }

    public static class CartesianWalker<MP extends Model.Parameters>
    implements HyperSpaceWalker<MP> {
        final transient ModelParametersBuilderFactory<MP> _paramsBuilderFactory;
        final MP _params;
        private final Map<String, Object[]> _hyperParams;
        private final String[] _hyperParamNames;
        private final int _hyperSpaceSize;

        public CartesianWalker(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory) {
            this._params = params;
            this._hyperParams = hyperParams;
            this._paramsBuilderFactory = paramsBuilderFactory;
            this._hyperParamNames = hyperParams.keySet().toArray(new String[0]);
            this._hyperSpaceSize = this.computeSizeOfHyperSpace();
        }

        @Override
        public HyperSpaceIterator<MP> iterator() {
            return new HyperSpaceIterator<MP>(){
                private int[] _hidx = null;

                @Override
                public MP nextModelParameters(Model previousModel) {
                    int[] nArray = this._hidx = this._hidx != null ? CartesianWalker.this.nextModel(this._hidx) : new int[CartesianWalker.this._hyperParamNames.length];
                    if (this._hidx != null) {
                        Object[] hypers = CartesianWalker.this.hypers(this._hidx, new Object[CartesianWalker.this._hyperParamNames.length]);
                        Model.Parameters commonModelParams = (Model.Parameters)((Iced)CartesianWalker.this._params).clone();
                        Model.Parameters params = CartesianWalker.this.getModelParams(commonModelParams, hypers);
                        return params;
                    }
                    throw new NoSuchElementException("No more elements to explore in hyper-space!");
                }

                @Override
                public boolean hasNext(Model previousModel) {
                    if (this._hidx == null) {
                        return true;
                    }
                    int[] hidx = this._hidx;
                    for (int i = 0; i < hidx.length; ++i) {
                        if (hidx[i] + 1 >= ((Object[])CartesianWalker.this._hyperParams.get(CartesianWalker.this._hyperParamNames[i])).length) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public Object[] getCurrentRawParameters() {
                    Object[] hyperValues = new Object[CartesianWalker.this._hyperParamNames.length];
                    return CartesianWalker.this.hypers(this._hidx, hyperValues);
                }
            };
        }

        @Override
        public String[] getHyperParamNames() {
            return this._hyperParamNames;
        }

        @Override
        public int getHyperSpaceSize() {
            return this._hyperSpaceSize;
        }

        @Override
        public MP getParams() {
            return this._params;
        }

        @Override
        public ModelParametersBuilderFactory<MP> getParametersBuilderFactory() {
            return this._paramsBuilderFactory;
        }

        private int[] nextModel(int[] hidx) {
            int i;
            for (i = 0; i < hidx.length && hidx[i] + 1 >= this._hyperParams.get(this._hyperParamNames[i]).length; ++i) {
            }
            if (i == hidx.length) {
                return null;
            }
            for (int j = 0; j < i; ++j) {
                hidx[j] = 0;
            }
            int n = i;
            hidx[n] = hidx[n] + 1;
            return hidx;
        }

        private MP getModelParams(MP params, Object[] hyperParams) {
            ModelParametersBuilderFactory.ModelParametersBuilder<MP> paramsBuilder = this._paramsBuilderFactory.get(params);
            for (int i = 0; i < this._hyperParamNames.length; ++i) {
                String paramName = this._hyperParamNames[i];
                Object paramValue = hyperParams[i];
                paramsBuilder.set(paramName, paramValue);
            }
            return paramsBuilder.build();
        }

        protected int computeSizeOfHyperSpace() {
            int work = 1;
            for (Map.Entry<String, Object[]> p : this._hyperParams.entrySet()) {
                if (p.getValue() == null) continue;
                work *= p.getValue().length;
            }
            return work;
        }

        private Object[] hypers(int[] hidx, Object[] hypers) {
            for (int i = 0; i < hidx.length; ++i) {
                hypers[i] = this._hyperParams.get(this._hyperParamNames[i])[hidx[i]];
            }
            return hypers;
        }
    }

    public static interface HyperSpaceIterator<MP extends Model.Parameters> {
        public MP nextModelParameters(Model var1);

        public boolean hasNext(Model var1);

        public Object[] getCurrentRawParameters();
    }
}

