/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.grid.Grid;
import java.util.ArrayList;
import water.DKV;
import water.Key;
import water.api.API;
import water.api.KeyV3;
import water.api.ModelParametersSchema;
import water.api.Schema;

public class GridSchemaV99
extends Schema<Grid, GridSchemaV99> {
    @API(help="Grid id")
    public KeyV3.GridKeyV3 grid_id;
    @API(help="Model IDs build by a grid search")
    public KeyV3.ModelKeyV3[] model_ids;
    @API(help="Used hyper parameters.", direction=API.Direction.OUTPUT)
    public String[] hyper_names;
    @API(help="List of failed parameters", direction=API.Direction.OUTPUT)
    public ModelParametersSchema[] failed_params;
    @API(help="List of detailed failure messages", direction=API.Direction.OUTPUT)
    public String[] failure_details;
    @API(help="List of detailed failure stack traces", direction=API.Direction.OUTPUT)
    public String[] failure_stack_traces;
    @API(help="List of raw parameters causing model building failure", direction=API.Direction.OUTPUT)
    public String[][] failed_raw_params;

    @Override
    public Grid createImpl() {
        return Grid.GRID_PROTO;
    }

    @Override
    public GridSchemaV99 fillFromImpl(Grid grid) {
        Key<Model>[] gridModelKeys = grid.getModelKeys();
        ArrayList<Key<Model>> modelKeys = new ArrayList<Key<Model>>(gridModelKeys.length);
        for (Key<Model> k : gridModelKeys) {
            if (k == null || DKV.get(k) == null) continue;
            modelKeys.add(k);
        }
        KeyV3.ModelKeyV3[] modelIds = new KeyV3.ModelKeyV3[modelKeys.size()];
        for (int i = 0; i < modelIds.length; ++i) {
            modelIds[i] = new KeyV3.ModelKeyV3((Key<? extends Model>)((Key)modelKeys.get(i)));
        }
        this.grid_id = new KeyV3.GridKeyV3((Key<Grid>)grid._key);
        this.model_ids = modelIds;
        this.hyper_names = grid.getHyperNames();
        this.failed_params = this.toModelParametersSchema(grid.getFailedParameters());
        this.failure_details = grid.getFailureDetails();
        this.failure_stack_traces = grid.getFailureStackTraces();
        this.failed_raw_params = grid.getFailedRawParameters();
        return this;
    }

    private ModelParametersSchema[] toModelParametersSchema(Model.Parameters[] modelParameters) {
        if (modelParameters == null) {
            return null;
        }
        ModelParametersSchema[] result = new ModelParametersSchema[modelParameters.length];
        for (int i = 0; i < modelParameters.length; ++i) {
            result[i] = modelParameters[i] != null ? (ModelParametersSchema)Schema.schema(Schema.getLatestVersion(), modelParameters[i]).fillFromImpl(modelParameters[i]) : null;
        }
        return result;
    }
}

