/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import java.lang.reflect.Constructor;
import java.util.Properties;
import water.AutoBuffer;
import water.H2O;
import water.Job;
import water.Key;
import water.api.API;
import water.api.JobV3;
import water.api.ModelParametersSchema;
import water.api.RequestSchema;
import water.api.Schema;
import water.api.SpecifiesHttpResponseCode;
import water.api.ValidationMessageBase;
import water.api.ValidationMessageV3;
import water.exceptions.H2OIllegalArgumentException;
import water.util.IcedSortedHashMap;
import water.util.ReflectionUtils;

public class ModelBuilderSchema<B extends ModelBuilder, S extends ModelBuilderSchema<B, S, P>, P extends ModelParametersSchema>
extends RequestSchema<B, S>
implements SpecifiesHttpResponseCode {
    @API(help="Model builder parameters.")
    public P parameters = this.createParametersSchema();
    @API(help="The algo name for this ModelBuilder.", direction=API.Direction.OUTPUT)
    public String algo;
    @API(help="The pretty algo name for this ModelBuilder (e.g., Generalized Linear Model, rather than GLM).", direction=API.Direction.OUTPUT)
    public String algo_full_name;
    @API(help="Model categories this ModelBuilder can build.", values={"Unknown", "Binomial", "Multinomial", "Regression", "Clustering", "AutoEncoder", "DimReduction"}, direction=API.Direction.OUTPUT)
    public ModelCategory[] can_build;
    @API(help="Should the builder always be visible, be marked as beta, or only visible if the user starts up with the experimental flag?", values={"Experimental", "Beta", "AlwaysVisible"}, direction=API.Direction.OUTPUT)
    public ModelBuilder.BuilderVisibility visibility;
    @API(help="Job Key", direction=API.Direction.OUTPUT)
    public JobV3 job;
    @API(help="Parameter validation messages", direction=API.Direction.OUTPUT)
    public ValidationMessageBase[] messages;
    @API(help="Count of parameter validation errors", direction=API.Direction.OUTPUT)
    public int error_count;
    @API(help="HTTP status to return for this build.", json=false)
    public int __http_status;

    public void setHttpStatus(int status) {
        this.__http_status = status;
    }

    @Override
    public int httpStatus() {
        return this.__http_status;
    }

    public final P createParametersSchema() {
        ModelParametersSchema impl = null;
        if (ModelBuilderSchema.class == this.getClass()) {
            return (P)new ModelParametersSchema();
        }
        try {
            Class parameters_class = ReflectionUtils.findActualClassParameter(this.getClass(), 2);
            impl = (ModelParametersSchema)parameters_class.newInstance();
        }
        catch (Exception e) {
            throw H2O.fail("Caught exception trying to instantiate a builder instance for ModelBuilderSchema: " + this + ": " + e, e);
        }
        return (P)impl;
    }

    @Override
    public S fillFromParms(Properties parms) {
        ((Schema)this.parameters).fillFromParms(parms);
        return (S)this;
    }

    @Override
    public final B createImpl() {
        ModelBuilder impl = null;
        try {
            Class builder_class = ReflectionUtils.findActualClassParameter(this.getClass(), 0);
            Class parameters_class = ((Schema)this.parameters).getImplClass();
            Model.Parameters _parameters = null;
            if (null != this.parameters) {
                _parameters = (Model.Parameters)((Schema)this.parameters).createImpl();
                if (null != ((ModelParametersSchema)this.parameters).model_id) {
                    _parameters._model_id = Key.make(((ModelParametersSchema)this.parameters).model_id.name);
                }
            }
            Constructor builder_constructor = builder_class.getConstructor(parameters_class);
            impl = (ModelBuilder)builder_constructor.newInstance(_parameters);
            impl.clearInitState();
            ((Model.Parameters)impl._parms)._model_id = null;
        }
        catch (Exception e) {
            throw H2O.fail("Caught exception trying to instantiate a builder instance for ModelBuilderSchema: " + this + ": " + e, e);
        }
        return (B)impl;
    }

    @Override
    public B fillImpl(B impl) {
        super.fillImpl(impl);
        ((ModelParametersSchema)this.parameters).fillImpl(((ModelBuilder)impl)._parms);
        ((ModelBuilder)impl).init(false);
        return impl;
    }

    @Override
    public S fillFromImpl(B builder) {
        try {
            this.algo = ((ModelBuilder)builder).getAlgo();
            this.algo_full_name = ModelBuilder.getAlgoFullName(this.algo);
        }
        catch (H2OIllegalArgumentException e) {
            this.algo_full_name = this.algo = builder.getClass().getSimpleName();
        }
        this.can_build = ((ModelBuilder)builder).can_build();
        this.visibility = ((ModelBuilder)builder).builderVisibility();
        this.job = (JobV3)Schema.schema(this.getSchemaVersion(), Job.class).fillFromImpl(builder);
        this.messages = new ValidationMessageBase[((ModelBuilder)builder)._messages.length];
        int i = 0;
        for (Job.ValidationMessage vm : ((ModelBuilder)builder)._messages) {
            this.messages[i++] = new ValidationMessageV3().fillFromImpl(vm);
        }
        ValidationMessageBase.mapValidationMessageFieldNames(this.messages, new String[]{"_train", "_valid"}, new String[]{"training_frame", "validation_frame"});
        this.error_count = ((ModelBuilder)builder).error_count();
        this.parameters = this.createParametersSchema();
        ((ModelParametersSchema)this.parameters).fillFromImpl(((ModelBuilder)builder)._parms);
        return (S)this;
    }

    @Override
    public AutoBuffer writeJSON_impl(AutoBuffer ab) {
        ab.put1(44);
        ab.putJSON("job", this.job);
        ab.put1(44);
        ab.putJSONStr("algo", this.algo);
        ab.put1(44);
        ab.putJSONStr("algo_full_name", this.algo_full_name);
        ab.put1(44);
        ab.putJSONAEnum("can_build", (Enum[])this.can_build);
        ab.put1(44);
        ab.putJSONEnum("visibility", this.visibility);
        ab.put1(44);
        ab.putJSONA("messages", this.messages);
        ab.put1(44);
        ab.putJSON4("error_count", this.error_count);
        ab.put1(44);
        ModelParametersSchema.writeParametersJSON(ab, this.parameters, ((ModelParametersSchema)((Object)this.createParametersSchema())).fillFromImpl((Model.Parameters)((Model.Parameters)((Schema)this.parameters).createImpl())));
        return ab;
    }

    public static class IcedHashMapStringModelBuilderSchema
    extends IcedSortedHashMap<String, ModelBuilderSchema> {
    }
}

