/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import water.Freezable;
import water.H2O;
import water.Key;
import water.MemoryManager;
import water.Value;
import water.fvec.Chunk;

class Cleaner
extends Thread {
    private static volatile long _dirty;
    static volatile long HEAP_USED_AT_LAST_GC;
    static volatile long TIME_AT_LAST_GC;
    static final Cleaner THE_CLEANER;
    volatile boolean _did_sweep;
    static volatile long DESIRED;
    private final Histo _myHisto;
    private static volatile Histo H;

    static long dirty() {
        return _dirty;
    }

    static void dirty_store() {
        Cleaner.dirty_store(System.currentTimeMillis());
    }

    static void dirty_store(long x) {
        if (x < _dirty) {
            _dirty = x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void kick_store_cleaner() {
        Cleaner cleaner = THE_CLEANER;
        synchronized (cleaner) {
            THE_CLEANER.notifyAll();
        }
    }

    private static void block_store_cleaner() {
        try {
            THE_CLEANER.wait(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void block_for_test() throws InterruptedException {
        Cleaner.THE_CLEANER._did_sweep = false;
        while (!Cleaner.THE_CLEANER._did_sweep) {
            THE_CLEANER.wait();
        }
    }

    Cleaner() {
        super("MemCleaner");
        this.setDaemon(true);
        this.setPriority(8);
        _dirty = Long.MAX_VALUE;
        this._myHisto = new Histo();
        this._myHisto.compute(0L);
        H = this._myHisto;
        this._myHisto.histo(true);
        MemoryManager.set_goals("init", false);
    }

    static boolean lazyPersist() {
        return H2O.SELF._heartbeat.get_free_disk() > MemoryManager.MEM_MAX;
    }

    static boolean isDiskFull() {
        return true;
    }

    @Override
    public synchronized void run() {
    }

    boolean lazy_clean(Key key) {
        return key.isChunkKey();
    }

    static {
        TIME_AT_LAST_GC = System.currentTimeMillis();
        THE_CLEANER = new Cleaner();
    }

    static class Histo {
        final long[] _hs = new long[128];
        long _oldest;
        long _eldest;
        long _hStep;
        long _cached;
        long _total;
        long _when;
        Value _vold;
        boolean _clean;

        Histo() {
        }

        synchronized Histo histo(boolean force) {
            Histo h = H;
            if (!force && System.currentTimeMillis() < h._when + 1000L) {
                return h;
            }
            if (h._clean && _dirty == Long.MAX_VALUE) {
                return h;
            }
            this.compute(h._oldest);
            return H = this;
        }

        void compute(long eldest) {
            Arrays.fill(this._hs, 0L);
            this._when = System.currentTimeMillis();
            this._eldest = eldest;
            this._hStep = Math.max(1L, (this._when - eldest) / (long)this._hs.length);
            boolean clean = _dirty == Long.MAX_VALUE;
            Object[] kvs = H2O.STORE.raw_array();
            long cached = 0L;
            long total = 0L;
            long oldest = Long.MAX_VALUE;
            Value vold = null;
            for (int i = 2; i < kvs.length; i += 2) {
                int idx;
                Object ok = kvs[i];
                Object ov = kvs[i + 1];
                if (!(ok instanceof Key) || !(ov instanceof Value)) continue;
                Value val = (Value)ov;
                if (val.isNull()) {
                    Value.STORE_get(val._key);
                    continue;
                }
                total += (long)val._max;
                int len = 0;
                byte[] m = val.rawMem();
                Freezable p = val.rawPOJO();
                if (m != null) {
                    len += val._max;
                }
                if (p != null) {
                    len += val._max;
                }
                if (p instanceof Chunk) {
                    len -= val._max;
                }
                if (len == 0) continue;
                cached += (long)len;
                if (val._lastAccessedTime < oldest) {
                    vold = val;
                    oldest = val._lastAccessedTime;
                }
                if ((idx = (int)((val._lastAccessedTime - eldest) / this._hStep)) < 0) {
                    idx = 0;
                } else if (idx >= this._hs.length) {
                    idx = this._hs.length - 1;
                }
                int n = idx;
                this._hs[n] = this._hs[n] + (long)len;
            }
            this._cached = cached;
            this._total = total;
            this._oldest = oldest;
            this._vold = vold;
            this._clean = clean && _dirty == Long.MAX_VALUE;
        }

        long clean_to(long desired) {
            long age = this._eldest;
            if (this._cached < desired) {
                return age;
            }
            long s = 0L;
            for (long t : this._hs) {
                age += this._hStep;
                if (this._cached - (s += t) < desired) break;
            }
            return age;
        }

        public String toString() {
            long x = this._eldest;
            long now = System.currentTimeMillis();
            return "H(" + (this._cached >> 20) + "M, " + x + "ms < +" + (this._oldest - x) + "ms <...{" + this._hStep + "ms}...< +" + this._hStep * 128L + "ms < +" + (now - x) + ")";
        }
    }
}

