/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import water.AutoBuffer;
import water.DTask;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Key;
import water.MemoryManager;
import water.Paxos;
import water.RPC;
import water.TaskPutKey;
import water.UDP;
import water.init.NetworkInit;
import water.nbhm.NonBlockingHashMap;
import water.nbhm.NonBlockingHashMapLong;
import water.util.Log;
import water.util.UnsafeUtils;

public class H2ONode
extends Iced<H2ONode>
implements Comparable {
    short _unique_idx;
    boolean _announcedLostContact;
    public long _last_heard_from;
    public volatile HeartBeat _heartbeat;
    public int _tcp_readers;
    public final H2Okey _key;
    private static final NonBlockingHashMap<H2Okey, H2ONode> INTERN = new NonBlockingHashMap();
    private static final AtomicInteger UNIQUE = new AtomicInteger(1);
    static H2ONode[] IDX = new H2ONode[1];
    private SocketChannel[] _socks = new SocketChannel[2];
    private int _socksAvail = this._socks.length;
    static final AtomicInteger TCPS = new AtomicInteger(0);
    private SocketChannel _rawChannel;
    private final PriorityBlockingQueue<H2OSmallMessage> _msgQ = new PriorityBlockingQueue();
    private UDP_TCP_SendThread _sendThread = null;
    private final NonBlockingHashMapLong<RPC> _tasks = new NonBlockingHashMapLong();
    private final NonBlockingHashMapLong<TaskPutKey> _tasksPutKey = new NonBlockingHashMapLong();
    private final AtomicInteger _created_task_ids = new AtomicInteger(1);
    private final NonBlockingHashMapLong<RPC.RPCCall> _work = new NonBlockingHashMapLong();
    private final AtomicInteger _removed_task_ids = new AtomicInteger(0);
    private final RPC.RPCCall _removed_task = new RPC.RPCCall(null, this, 0);

    public String getIpPortString() {
        return this._key.getIpPortString();
    }

    public final int ip4() {
        return this._key._ipv4;
    }

    private H2ONode(H2Okey key, short unique_idx) {
        this._key = key;
        this._unique_idx = unique_idx;
        this._last_heard_from = System.currentTimeMillis();
        this._heartbeat = new HeartBeat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static H2ONode intern(H2Okey key) {
        H2ONode h2o = INTERN.get(key);
        if (h2o != null) {
            return h2o;
        }
        int idx = UNIQUE.getAndIncrement();
        assert (idx < Short.MAX_VALUE);
        h2o = new H2ONode(key, (short)idx);
        H2ONode old = INTERN.putIfAbsent(key, h2o);
        if (old != null) {
            return old;
        }
        Class<H2O> clazz = H2O.class;
        synchronized (H2O.class) {
            while (idx >= IDX.length) {
                IDX = Arrays.copyOf(IDX, IDX.length << 1);
            }
            H2ONode.IDX[idx] = h2o;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return h2o;
        }
    }

    public static H2ONode intern(InetAddress ip, int port) {
        return H2ONode.intern(new H2Okey(ip, port));
    }

    public static H2ONode intern(byte[] bs, int off) {
        byte[] b = new byte[4];
        UnsafeUtils.set4(b, 0, UnsafeUtils.get4(bs, off));
        int port = UnsafeUtils.get2(bs, off + 4) & 0xFFFF;
        try {
            return H2ONode.intern(InetAddress.getByAddress(b), port);
        }
        catch (UnknownHostException e) {
            throw Log.throwErr(e);
        }
    }

    static H2ONode intern(int ip, int port) {
        byte[] b = new byte[]{(byte)(ip >> 0), (byte)(ip >> 8), (byte)(ip >> 16), (byte)(ip >> 24)};
        try {
            return H2ONode.intern(InetAddress.getByAddress(b), port);
        }
        catch (UnknownHostException e) {
            throw Log.throwErr(e);
        }
    }

    public static H2ONode self(InetAddress local) {
        assert (H2O.H2O_PORT != 0);
        try {
            ArrayList<NetworkInterface> matchingIfs = new ArrayList<NetworkInterface>();
            Enumeration<NetworkInterface> netIfs = NetworkInterface.getNetworkInterfaces();
            block10: while (netIfs.hasMoreElements()) {
                NetworkInterface netIf = netIfs.nextElement();
                Enumeration<InetAddress> addrs = netIf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!addr.equals(local)) continue;
                    matchingIfs.add(netIf);
                    continue block10;
                }
            }
            switch (matchingIfs.size()) {
                case 0: {
                    H2O.CLOUD_MULTICAST_IF = null;
                    break;
                }
                case 1: {
                    H2O.CLOUD_MULTICAST_IF = (NetworkInterface)matchingIfs.get(0);
                    break;
                }
                default: {
                    String msg = "Found multiple network interfaces for ip address " + local;
                    for (NetworkInterface ni : matchingIfs) {
                        msg = msg + "\n\t" + ni;
                    }
                    msg = msg + "\nUsing " + matchingIfs.get(0) + " for UDP broadcast";
                    Log.warn(msg);
                    H2O.CLOUD_MULTICAST_IF = (NetworkInterface)matchingIfs.get(0);
                    break;
                }
            }
        }
        catch (SocketException e) {
            throw Log.throwErr(e);
        }
        try {
            if (H2O.CLOUD_MULTICAST_IF != null && !H2O.CLOUD_MULTICAST_IF.supportsMulticast()) {
                Log.info("Selected H2O.CLOUD_MULTICAST_IF: " + H2O.CLOUD_MULTICAST_IF + " doesn't support multicast");
            }
            if (H2O.CLOUD_MULTICAST_IF != null && !H2O.CLOUD_MULTICAST_IF.isUp()) {
                throw new RuntimeException("Selected H2O.CLOUD_MULTICAST_IF: " + H2O.CLOUD_MULTICAST_IF + " is not up and running");
            }
        }
        catch (SocketException e) {
            throw Log.throwErr(e);
        }
        try {
            assert (NetworkInit.CLOUD_DGRAM == null);
            NetworkInit.CLOUD_DGRAM = DatagramChannel.open();
        }
        catch (Exception e) {
            throw Log.throwErr(e);
        }
        return H2ONode.intern(new H2Okey(local, H2O.H2O_PORT));
    }

    public String toString() {
        return this._key.toString();
    }

    public int hashCode() {
        return this._key.hashCode();
    }

    public boolean equals(Object o) {
        return this._key.equals(((H2ONode)o)._key);
    }

    public int compareTo(Object o) {
        return this._key.compareTo(((H2ONode)o)._key);
    }

    public int index() {
        return H2O.CLOUD.nidx(this);
    }

    public long get_max_mem() {
        return this == H2O.SELF ? Runtime.getRuntime().maxMemory() : this._heartbeat.get_max_mem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(H2OSmallMessage msg) {
        this._msgQ.put(msg);
        if (this._sendThread == null) {
            H2ONode h2ONode = this;
            synchronized (h2ONode) {
                if (this._sendThread == null) {
                    this._sendThread = new UDP_TCP_SendThread();
                    this._sendThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SocketChannel getTCPSocket() throws IOException {
        H2ONode h2ONode = this;
        synchronized (h2ONode) {
            SocketChannel sock;
            while (this._socksAvail == 0) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException ignored) {}
            }
            if ((sock = this._socks[--this._socksAvail]) != null) {
                if (sock.isOpen()) {
                    return sock;
                }
                assert (TCPS.get() > 0);
                TCPS.decrementAndGet();
            }
        }
        SocketChannel sock2 = SocketChannel.open();
        sock2.socket().setReuseAddress(true);
        sock2.socket().setSendBufferSize(AutoBuffer.BBP_BIG.size());
        boolean res = sock2.connect(this._key);
        assert (res && !sock2.isConnectionPending() && sock2.isBlocking() && sock2.isConnected() && sock2.isOpen());
        ByteBuffer bb = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
        bb.put((byte)2);
        bb.putChar((char)H2O.H2O_PORT);
        bb.put((byte)-17);
        bb.flip();
        while (bb.hasRemaining()) {
            sock2.write(bb);
        }
        TCPS.incrementAndGet();
        return sock2;
    }

    synchronized void freeTCPSocket(SocketChannel sock) {
        assert (0 <= this._socksAvail && this._socksAvail < this._socks.length);
        if (sock != null && !sock.isOpen()) {
            sock = null;
        }
        this._socks[this._socksAvail++] = sock;
        assert (TCPS.get() > 0);
        if (sock == null) {
            TCPS.decrementAndGet();
        }
        this.notify();
    }

    void taskPut(int tnum, RPC rpc) {
        this._tasks.put(tnum, rpc);
        if (rpc._dt instanceof TaskPutKey) {
            this._tasksPutKey.put(tnum, (TaskPutKey)rpc._dt);
        }
    }

    RPC taskGet(int tnum) {
        return this._tasks.get(tnum);
    }

    void taskRemove(int tnum) {
        this._tasks.remove(tnum);
        this._tasksPutKey.remove(tnum);
    }

    Collection<RPC> tasks() {
        return this._tasks.values();
    }

    int taskSize() {
        return this._tasks.size();
    }

    TaskPutKey pendingPutKey(Key k) {
        for (TaskPutKey tpk : this._tasksPutKey.values()) {
            if (!k.equals(tpk._key)) continue;
            return tpk;
        }
        return null;
    }

    int nextTaskNum() {
        return this._created_task_ids.getAndIncrement();
    }

    RPC.RPCCall has_task(int tnum) {
        if (tnum <= this._removed_task_ids.get()) {
            return this._removed_task;
        }
        return this._work.get(tnum);
    }

    RPC.RPCCall record_task(RPC.RPCCall rpc) {
        RPC.RPCCall x = this._work.putIfAbsent(rpc._tsknum, rpc);
        if (x != null) {
            return x;
        }
        if (rpc._tsknum > this._removed_task_ids.get()) {
            return null;
        }
        this._work.remove(rpc._tsknum);
        return this._removed_task;
    }

    void record_task_answer(RPC.RPCCall rpcall) {
        rpcall._started = System.currentTimeMillis();
        rpcall._retry = 10000L;
    }

    void remove_task_tracking(int task) {
        int t;
        RPC.RPCCall rpc2;
        RPC.RPCCall rpc = this._work.get(task);
        if (rpc == null) {
            return;
        }
        DTask dt = rpc._dt;
        if (dt != null && rpc.CAS_DT(dt, null)) {
            assert (rpc._computed) : "Still not done #" + task + " " + dt.getClass() + " from " + rpc._client;
            dt.onAckAck();
        }
        while ((rpc2 = this._work.get((t = this._removed_task_ids.get()) + 1)) != null && rpc2._dt == null && this._removed_task_ids.compareAndSet(t, t + 1)) {
            this._work.remove(t + 1);
        }
    }

    void rebooted() {
        this._work.clear();
        this._removed_task_ids.set(0);
    }

    @Override
    public final AutoBuffer write_impl(AutoBuffer ab) {
        return this._key.write(ab);
    }

    @Override
    public final H2ONode read_impl(AutoBuffer ab) {
        return H2ONode.intern(H2Okey.read(ab));
    }

    @Override
    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        return ab.putJSONStr("node", this._key.toString());
    }

    @Override
    public final H2ONode readJSON_impl(AutoBuffer ab) {
        throw H2O.fail();
    }

    static class AckAckTimeOutThread
    extends Thread {
        AckAckTimeOutThread() {
            super("ACKTimeout");
        }

        @Override
        public void run() {
            Thread.currentThread().setPriority(9);
            while (true) {
                long currenTime = System.currentTimeMillis();
                for (H2ONode h2o : H2O.CLOUD._memary) {
                    if (h2o == H2O.SELF) continue;
                    for (RPC.RPCCall rpc : h2o._work.values()) {
                        if (rpc._started + rpc._retry >= currenTime) continue;
                        if (!H2O.CLOUD.contains(rpc._client) && !rpc._client._heartbeat._client || rpc._client._heartbeat._client && rpc._retry >= 1000L) {
                            rpc._client.remove_task_tracking(rpc._tsknum);
                            continue;
                        }
                        if (rpc._computed) {
                            DTask dt;
                            if (!rpc._computedAndReplied || (dt = rpc._dt) == null) continue;
                            if (++rpc._ackResendCnt % 5 == 0) {
                                Log.warn("Got " + rpc._ackResendCnt + " resends on ack for task # " + rpc._tsknum + ", class = " + dt.getClass().getSimpleName());
                            }
                            rpc.resend_ack();
                            continue;
                        }
                        if (rpc._nackResendCnt != 0) continue;
                        ++rpc._nackResendCnt;
                        rpc.send_nack();
                    }
                }
                long timeElapsed = System.currentTimeMillis() - currenTime;
                if (timeElapsed >= 1000L) continue;
                try {
                    Thread.sleep(1000L - timeElapsed);
                }
                catch (InterruptedException e) {
                }
            }
        }
    }

    private class UDP_TCP_SendThread
    extends Thread {
        private final ByteBuffer _bb;

        public UDP_TCP_SendThread() {
            super("UDP-TCP-SEND-" + H2ONode.this);
            this._bb = AutoBuffer.BBP_BIG.make();
        }

        void sendBuffer() {
            int sleep = 0;
            this._bb.flip();
            int sz = this._bb.limit();
            int retries = 0;
            while (true) {
                this._bb.position(0);
                this._bb.limit(sz);
                try {
                    if (H2ONode.this._rawChannel == null || !H2ONode.this._rawChannel.isOpen() || !H2ONode.this._rawChannel.isConnected()) {
                        SocketChannel sock = SocketChannel.open();
                        sock.socket().setReuseAddress(true);
                        sock.socket().setSendBufferSize(AutoBuffer.BBP_BIG.size());
                        InetSocketAddress isa = new InetSocketAddress(H2ONode.this._key.getAddress(), H2ONode.this._key.getPort());
                        boolean res = false;
                        try {
                            res = sock.connect(isa);
                        }
                        catch (IOException ioe) {
                            if (!Paxos._cloudLocked && retries++ < 300) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {}
                                continue;
                            }
                            throw ioe;
                        }
                        boolean blocking = true;
                        sock.configureBlocking(blocking);
                        assert (res && !sock.isConnectionPending() && blocking == sock.isBlocking() && sock.isConnected() && sock.isOpen());
                        H2ONode.this._rawChannel = sock;
                        H2ONode.this._rawChannel.socket().setTcpNoDelay(true);
                        ByteBuffer bb = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
                        bb.put((byte)1);
                        bb.putChar((char)H2O.H2O_PORT);
                        bb.put((byte)-17);
                        bb.flip();
                        while (bb.hasRemaining()) {
                            H2ONode.this._rawChannel.write(bb);
                        }
                    }
                    while (this._bb.hasRemaining()) {
                        H2ONode.this._rawChannel.write(this._bb);
                    }
                    this._bb.position(0);
                    this._bb.limit(this._bb.capacity());
                    return;
                }
                catch (IOException ioe) {
                    if (!H2O.getShutdownRequested()) {
                        Log.err(ioe);
                    }
                    if (H2ONode.this._rawChannel != null) {
                        try {
                            H2ONode.this._rawChannel.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    H2ONode.this._rawChannel = null;
                    if (!H2O.getShutdownRequested()) {
                        Log.warn("Got IO error when sending raw bytes, sleeping for " + sleep + " ms and retrying");
                    }
                    sleep = Math.min(5000, sleep + 1 << 1);
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e) {
                    }
                    continue;
                }
                break;
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        while (true) {
                            H2OSmallMessage m = (H2OSmallMessage)H2ONode.this._msgQ.take();
                            while (m != null) {
                                if (m._data.length > this._bb.capacity()) {
                                    H2O.fail("Small message larger than the buffer");
                                }
                                if (this._bb.remaining() < m._data.length) {
                                    this.sendBuffer();
                                }
                                this._bb.put(m._data);
                                m = (H2OSmallMessage)H2ONode.this._msgQ.poll();
                            }
                            this.sendBuffer();
                        }
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                Log.err(t);
                throw H2O.fail();
            }
        }
    }

    public static class H2OSmallMessage
    implements Comparable<H2OSmallMessage> {
        private int _priority;
        private final byte[] _data;

        public H2OSmallMessage(byte[] data, int priority) {
            this._data = data;
            this._priority = priority;
        }

        @Override
        public int compareTo(H2OSmallMessage o) {
            return o._priority - this._priority;
        }

        public void increasePriority() {
            ++this._priority;
        }

        public static H2OSmallMessage make(ByteBuffer bb, int priority) {
            int sz = bb.limit();
            assert (sz == (0xFFFF & sz));
            assert (sz <= AutoBuffer.BBP_SML.size());
            byte[] ary = MemoryManager.malloc1(sz + 2 + 1);
            ary[ary.length - 1] = -17;
            ary[0] = (byte)(sz & 0xFF);
            ary[1] = (byte)((sz & 0xFF00) >> 8);
            if (bb.hasArray()) {
                System.arraycopy(bb.array(), 0, ary, 2, sz);
            } else {
                for (int i = 0; i < sz; ++i) {
                    ary[i + 2] = bb.get(i);
                }
            }
            assert (0 < ary[2] && ary[2] < UDP.udp.UDPS.length);
            assert (UDP.udp.UDPS[ary[2]]._udp != null) : "missing udp " + ary[2];
            assert ((0xFF & ary[ary.length - 1]) == 239);
            assert ((0xFF & ary[0] | (0xFF & ary[1]) << 8) + 3 == ary.length);
            return new H2OSmallMessage(ary, priority);
        }
    }

    public static final class H2Okey
    extends InetSocketAddress
    implements Comparable {
        final int _ipv4;

        H2Okey(InetAddress inet, int port) {
            super(inet, port);
            byte[] b = inet.getAddress();
            this._ipv4 = ((b[0] & 0xFF) << 0) + ((b[1] & 0xFF) << 8) + ((b[2] & 0xFF) << 16) + ((b[3] & 0xFF) << 24);
        }

        public int htm_port() {
            return this.getPort() - 1;
        }

        public int udp_port() {
            return this.getPort();
        }

        @Override
        public String toString() {
            return this.getAddress() + ":" + this.htm_port();
        }

        public String getIpPortString() {
            return this.getAddress().getHostAddress() + ":" + this.htm_port();
        }

        AutoBuffer write(AutoBuffer ab) {
            return ab.put4(this._ipv4).put2((char)this.udp_port());
        }

        static H2Okey read(AutoBuffer ab) {
            try {
                InetAddress inet = InetAddress.getByAddress(ab.getA1(4));
                char port = ab.get2();
                return new H2Okey(inet, (int)port);
            }
            catch (UnknownHostException e) {
                throw Log.throwErr(e);
            }
        }

        public int compareTo(Object x) {
            if (x == null) {
                return -1;
            }
            if (x == this) {
                return 0;
            }
            H2Okey key = (H2Okey)x;
            long res = ((long)this._ipv4 & 0xFFFFFFFFL) - ((long)key._ipv4 & 0xFFFFFFFFL);
            if (res != 0L) {
                return res < 0L ? -1 : 1;
            }
            return this.udp_port() - key.udp_port();
        }
    }
}

