/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import water.Cleaner;
import water.H2O;
import water.H2ONode;
import water.HeartBeat;
import water.Paxos;
import water.TimeLine;
import water.UDPHeartbeat;
import water.init.Linpack;
import water.init.MemoryBandwidth;
import water.util.LinuxProcFileReader;
import water.util.Log;

public class HeartBeatThread
extends Thread {
    static final int SLEEP = 1000;
    public static final int TIMEOUT = 60000;
    static final int SUSPECT = 60500;
    private static final Cleaner.Histo myHisto = new Cleaner.Histo();
    private static int HB_VERSION;
    public static final int CLIENT_TIMEOUT = 1000;

    public HeartBeatThread() {
        super("Heartbeat");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        ObjectName os;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            os = new ObjectName("java.lang:type=OperatingSystem");
        }
        catch (MalformedObjectNameException e) {
            throw Log.throwErr(e);
        }
        Thread.currentThread().setPriority(10);
        int counter = 0;
        while (true) {
            long now;
            H2O cloud = H2O.CLOUD;
            HeartBeat hb = H2O.SELF._heartbeat;
            ++HB_VERSION;
            hb._hb_version = hb._hb_version;
            hb._jvm_boot_msec = TimeLine.JVM_BOOT_MSEC;
            Runtime run = Runtime.getRuntime();
            hb.set_free_mem(run.freeMemory());
            hb.set_max_mem(run.maxMemory());
            hb.set_tot_mem(run.totalMemory());
            hb._keys = H2O.STORE.size();
            hb.set_mvalsz(HeartBeatThread.myHisto.histo((boolean)false)._cached);
            hb.set_tvalsz(HeartBeatThread.myHisto._total);
            hb._num_cpus = (char)run.availableProcessors();
            if ((counter + Math.abs(H2O.SELF.hashCode())) % 300 == 0) {
                hb._gflops = Linpack.run(hb._cpus_allowed);
                hb._membw = MemoryBandwidth.run(hb._cpus_allowed);
            }
            Object load = null;
            try {
                load = mbs.getAttribute(os, "SystemLoadAverage");
                if ((Double)load == -1.0) {
                    load = mbs.getAttribute(os, "SystemCpuLoad");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            hb._system_load_average = load instanceof Double ? ((Double)load).floatValue() : 0.0f;
            int rpcs = 0;
            for (H2ONode h2o : cloud._memary) {
                rpcs += h2o.taskSize();
            }
            hb._rpcs = (char)rpcs;
            hb._fjthrds = new short[127];
            hb._fjqueue = new short[127];
            for (int i = 0; i < hb._fjthrds.length; ++i) {
                hb._fjthrds[i] = (short)H2O.getWrkThrPoolSize(i);
                hb._fjqueue[i] = (short)H2O.getWrkQueueSize(i);
            }
            hb._tcps_active = (char)H2ONode.TCPS.get();
            hb.set_free_disk(H2O.getPM().getIce().getUsableSpace());
            hb.set_max_disk(H2O.getPM().getIce().getTotalSpace());
            LinuxProcFileReader lpfr = new LinuxProcFileReader();
            lpfr.read();
            if (lpfr.valid()) {
                hb._system_idle_ticks = lpfr.getSystemIdleTicks();
                hb._system_total_ticks = lpfr.getSystemTotalTicks();
                hb._process_total_ticks = lpfr.getProcessTotalTicks();
                hb._process_num_open_fds = lpfr.getProcessNumOpenFds();
            } else {
                hb._system_idle_ticks = -1L;
                hb._system_total_ticks = -1L;
                hb._process_total_ticks = -1L;
                hb._process_num_open_fds = -1;
            }
            hb._cpus_allowed = lpfr.getProcessCpusAllowed();
            if (H2O.ARGS.nthreads < hb._cpus_allowed) {
                hb._cpus_allowed = H2O.ARGS.nthreads;
            }
            hb._nthreads = H2O.ARGS.nthreads;
            hb._pid = lpfr.getProcessID();
            UDPHeartbeat.build_and_multicast(cloud, hb);
            H2O.SELF._last_heard_from = now = System.currentTimeMillis();
            for (H2ONode h2o : cloud._memary) {
                long delta = now - h2o._last_heard_from;
                if (delta > 60500L) {
                    if (h2o._announcedLostContact) continue;
                    Paxos.print("hart: announce suspect node", cloud._memary, h2o.toString());
                    h2o._announcedLostContact = true;
                    continue;
                }
                if (!h2o._announcedLostContact) continue;
                Paxos.print("hart: regained contact with node", cloud._memary, h2o.toString());
                h2o._announcedLostContact = false;
            }
            ++counter;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
            }
        }
    }
}

