/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.Lockable;
import water.MRTask;
import water.TypeMap;
import water.Value;

public class KeySnapshot {
    private static final long _updateInterval = 1000L;
    private static volatile KeySnapshot _cache;
    public final KeyInfo[] _keyInfos;
    public final long timestamp;

    public static KeySnapshot cache() {
        return _cache;
    }

    public KeySnapshot filter(KVFilter kvf) {
        ArrayList<KeyInfo> res = new ArrayList<KeyInfo>();
        for (KeyInfo kinfo : this._keyInfos) {
            if (!kvf.filter(kinfo)) continue;
            res.add(kinfo);
        }
        return new KeySnapshot(res.toArray(new KeyInfo[res.size()]));
    }

    KeySnapshot(KeyInfo[] snapshot) {
        this._keyInfos = snapshot;
        this.timestamp = System.currentTimeMillis();
    }

    public Key[] keys() {
        Key[] res = new Key[this._keyInfos.length];
        for (int i = 0; i < this._keyInfos.length; ++i) {
            res[i] = this._keyInfos[i]._key;
        }
        return res;
    }

    public static Key[] globalKeysOfClass(final Class clz) {
        return KeySnapshot.globalSnapshot().filter(new KVFilter(){

            @Override
            public boolean filter(KeyInfo k) {
                return Value.isSubclassOf(k._type, clz);
            }
        }).keys();
    }

    public <T extends Iced> Map<String, T> fetchAll(Class<T> c) {
        return this.fetchAll(c, false, 0, Integer.MAX_VALUE);
    }

    public <T extends Iced> Map<String, T> fetchAll(Class<T> c, boolean exact) {
        return this.fetchAll(c, exact, 0, Integer.MAX_VALUE);
    }

    public <T extends Iced> Map<String, T> fetchAll(Class<T> c, boolean exact, int offset, int limit) {
        TreeMap res = new TreeMap();
        int typeId = TypeMap.onIce(c.getName());
        for (KeyInfo kinfo : this._keyInfos) {
            if (kinfo._type != typeId && (exact || !Value.isSubclassOf(kinfo._type, c))) continue;
            if (offset > 0) {
                --offset;
                continue;
            }
            Value v = DKV.get(kinfo._key);
            if (v == null) continue;
            Object t = v.get();
            res.put(kinfo._key.toString(), t);
            if (res.size() == limit) break;
        }
        return res;
    }

    public static KeySnapshot localSnapshot() {
        return KeySnapshot.localSnapshot(false);
    }

    public static KeySnapshot localSnapshot(boolean homeOnly) {
        Object[] kvs = H2O.STORE.raw_array();
        ArrayList<KeyInfo> res = new ArrayList<KeyInfo>();
        for (int i = 2; i < kvs.length; i += 2) {
            Value val;
            Key key;
            Object ok = kvs[i];
            Object ov = kvs[i + 1];
            if (!(ok instanceof Key) || !(key = (Key)ok).user_allowed() || homeOnly && !key.home()) continue;
            Value value = val = ov instanceof Value ? Value.STORE_get(key) : H2O.get(key);
            if (val == null) continue;
            res.add(new KeyInfo(key, val));
        }
        Object[] arr = res.toArray(new KeyInfo[res.size()]);
        Arrays.sort(arr);
        return new KeySnapshot((KeyInfo[])arr);
    }

    public static KeySnapshot globalSnapshot() {
        return KeySnapshot.globalSnapshot(-1L);
    }

    public static KeySnapshot globalSnapshot(long timeTolerance) {
        KeySnapshot res = _cache;
        long t = System.currentTimeMillis();
        if (res == null || t - res.timestamp > timeTolerance) {
            res = new KeySnapshot(((GlobalUKeySetTask)new GlobalUKeySetTask().doAllNodes())._res);
        } else if (t - res.timestamp > 1000L) {
            H2O.submitTask(new H2O.H2OCountedCompleter(){

                @Override
                public void compute2() {
                    new GlobalUKeySetTask().doAllNodes();
                }
            });
        }
        return res;
    }

    private static class GlobalUKeySetTask
    extends MRTask<GlobalUKeySetTask> {
        KeyInfo[] _res;

        private GlobalUKeySetTask() {
        }

        @Override
        public byte priority() {
            return 122;
        }

        @Override
        public void setupLocal() {
            this._res = KeySnapshot.localSnapshot((boolean)true)._keyInfos;
        }

        @Override
        public void reduce(GlobalUKeySetTask gbt) {
            if (this._res == null) {
                this._res = gbt._res;
            } else if (gbt._res != null) {
                KeyInfo[] res = new KeyInfo[this._res.length + gbt._res.length];
                int j = 0;
                int k = 0;
                for (int i = 0; i < res.length; ++i) {
                    res[i] = j < gbt._res.length && (k == this._res.length || gbt._res[j].compareTo(this._res[k]) < 0) ? gbt._res[j++] : this._res[k++];
                }
                this._res = res;
            }
        }

        @Override
        public void postGlobal() {
            _cache = new KeySnapshot(this._res);
        }
    }

    public static final class KeyInfo
    extends Iced
    implements Comparable<KeyInfo> {
        public final Key _key;
        public final int _type;
        public final int _sz;
        public final byte _backEnd;

        public KeyInfo(Key k, Value v) {
            this._key = k;
            this._type = v.type();
            this._sz = v._max;
            this._backEnd = v.backend();
        }

        @Override
        public int compareTo(KeyInfo ki) {
            return this._key.compareTo(ki._key);
        }

        public boolean isFrame() {
            return this._type == TypeMap.FRAME;
        }

        public boolean isLockable() {
            return TypeMap.theFreezable(this._type) instanceof Lockable;
        }
    }

    public static abstract class KVFilter {
        public abstract boolean filter(KeyInfo var1);
    }
}

