/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Collections;
import java.util.List;
import water.DKV;
import water.Futures;
import water.Iced;
import water.Key;
import water.Value;
import water.serial.AutoBufferSerializer;

public abstract class Keyed<T extends Keyed>
extends Iced<T> {
    public Key<T> _key;
    private long _checksum;
    public static final List<Key> EMPTY_KEY_LIST = Collections.emptyList();

    public Keyed() {
        this._key = null;
    }

    public Keyed(Key<T> key) {
        this._key = key;
    }

    public final void remove() {
        this.remove(new Futures()).blockForPending();
    }

    public final Futures remove(Futures fs) {
        if (this._key != null) {
            DKV.remove(this._key, fs);
        }
        return this.remove_impl(fs);
    }

    protected Futures remove_impl(Futures fs) {
        return fs;
    }

    public static void remove(Key k) {
        Value val = DKV.get(k);
        if (val == null) {
            return;
        }
        ((Keyed)val.get()).remove();
    }

    public static void remove(Key k, Futures fs) {
        Value val = DKV.get(k);
        if (val == null) {
            return;
        }
        ((Keyed)val.get()).remove(fs);
    }

    protected abstract long checksum_impl();

    public final long checksum() {
        if (this._checksum != 0L) {
            return this._checksum;
        }
        long x = this.checksum_impl();
        if (x == 0L) {
            x = 1L;
        }
        this._checksum = x;
        return this._checksum;
    }

    public AutoBufferSerializer<Keyed> getBinarySerializer() {
        return new BinarySerializer<Keyed>();
    }

    public List<Key> getPublishedKeys() {
        return EMPTY_KEY_LIST;
    }

    protected static class BinarySerializer<X extends Keyed>
    extends AutoBufferSerializer<X> {
        protected BinarySerializer() {
        }
    }
}

