/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import jsr166y.CountedCompleter;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;
import water.DException;
import water.DKV;
import water.DTask;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Key;
import water.RPC;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.PrettyPrint;

public abstract class MRTask<T extends MRTask<T>>
extends DTask<T>
implements ForkJoinPool.ManagedBlocker {
    public Frame _fr;
    public Key[] _keys;
    private byte[] _output_types;
    private int _vid;
    protected AppendableVec[] _appendables;
    protected transient RPC<T> _nleft;
    protected transient RPC<T> _nrite;
    protected transient boolean _topLocal;
    transient boolean _topGlobal = false;
    protected transient T _left;
    protected transient T _rite;
    private transient T _res;
    protected short _nlo;
    protected short _nhi;
    protected transient int _lo;
    protected transient int _hi;
    protected transient Futures _fs;
    protected boolean _run_local;
    MRProfile _profile;
    private boolean _doProfile = false;
    private byte _priority;

    public MRTask() {
    }

    protected MRTask(H2O.H2OCountedCompleter cmp) {
        super(cmp);
    }

    public AppendableVec[] appendables() {
        return this._appendables;
    }

    public String profString() {
        return this._doProfile ? this._profile.toString() : "Profiling turned off";
    }

    public void setProfile(boolean b) {
        this._doProfile = b;
    }

    @Override
    public byte priority() {
        return this._priority;
    }

    public Frame outputFrame() {
        return this.outputFrame(null, null, null);
    }

    public Frame outputFrame(String[] names, String[][] domains) {
        return this.outputFrame(null, names, domains);
    }

    public Frame outputFrame(Key key, String[] names, String[][] domains) {
        Futures fs = new Futures();
        Frame res = this.closeFrame(key, names, domains, fs);
        if (key != null) {
            DKV.put(res, fs);
        }
        fs.blockForPending();
        return res;
    }

    private Frame closeFrame(Key key, String[] names, String[][] domains, Futures fs) {
        if (this._output_types == null) {
            return null;
        }
        int noutputs = this._output_types.length;
        Vec[] vecs = new Vec[noutputs];
        if (this._appendables == null) {
            for (int i = 0; i < noutputs; ++i) {
                vecs[i] = this._fr.anyVec().makeZero();
            }
        } else {
            int rowLayout = this._appendables[0].compute_rowLayout();
            for (int i = 0; i < noutputs; ++i) {
                this._appendables[i].setDomain(domains == null ? null : domains[i]);
                vecs[i] = this._appendables[i].close(rowLayout, fs);
            }
        }
        return new Frame(key, names, vecs);
    }

    public void map(Chunk c) {
    }

    public void map(Chunk c, NewChunk nc) {
    }

    public void map(Chunk c0, Chunk c1) {
    }

    public void map(Chunk c0, Chunk c1, NewChunk nc) {
    }

    public void map(Chunk c0, Chunk c1, NewChunk nc1, NewChunk nc2) {
    }

    public void map(Chunk c0, Chunk c1, Chunk c2) {
    }

    public void map(Chunk c0, Chunk c1, Chunk c2, NewChunk nc) {
    }

    public void map(Chunk c0, Chunk c1, Chunk c2, NewChunk nc1, NewChunk nc2) {
    }

    public void map(Chunk[] cs) {
    }

    public void map(Chunk[] cs, NewChunk nc) {
    }

    public void map(Chunk[] cs, NewChunk nc1, NewChunk nc2) {
    }

    public void map(Chunk[] cs, NewChunk[] ncs) {
    }

    public void map(Key key) {
    }

    public void reduce(T mrt) {
    }

    protected void setupLocal() {
    }

    protected void closeLocal() {
    }

    private int addShift(int x) {
        int sz = H2O.CLOUD.size();
        return (x += this._nlo) < sz ? x : x - sz;
    }

    private int subShift(int x) {
        int sz = H2O.CLOUD.size();
        return (x -= this._nlo) < 0 ? x + sz : x;
    }

    private short selfidx() {
        int idx = H2O.SELF.index();
        if (idx >= 0) {
            return (short)idx;
        }
        assert (H2O.SELF._heartbeat._client);
        return 0;
    }

    protected T self() {
        return (T)this;
    }

    public final T doAll(Vec ... vecs) {
        return this.doAll((byte[])null, vecs);
    }

    public final T doAll(byte[] types, Vec ... vecs) {
        return this.doAll(types, new Frame(vecs), false);
    }

    public final T doAll(byte type, Vec ... vecs) {
        return this.doAll(new byte[]{type}, new Frame(vecs), false);
    }

    public final T doAll(Vec vec, boolean run_local) {
        return this.doAll(null, vec, run_local);
    }

    public final T doAll(byte[] types, Vec vec, boolean run_local) {
        return this.doAll(types, new Frame(vec), run_local);
    }

    public final T doAll(Frame fr, boolean run_local) {
        return this.doAll(null, fr, run_local);
    }

    public final T doAll(Frame fr) {
        return this.doAll(null, fr, false);
    }

    public final T doAll(byte[] types, Frame fr) {
        return this.doAll(types, fr, false);
    }

    public final T doAll(byte type, Frame fr) {
        return this.doAll(new byte[]{type}, fr, false);
    }

    public final T doAll(byte[] types, Frame fr, boolean run_local) {
        this.dfork(types, fr, run_local);
        return this.getResult();
    }

    public final T doAll(int nouts, byte type, Frame fr) {
        byte[] types = new byte[nouts];
        Arrays.fill(types, type);
        return this.doAll(types, fr, false);
    }

    public T doAll(Key ... keys) {
        this._priority = this.nextThrPriority();
        this._topGlobal = true;
        this._keys = keys;
        this._nlo = this.selfidx();
        this._nhi = (short)H2O.CLOUD.size();
        this.setupLocal0();
        H2O.submitTask(this);
        return this.getResult();
    }

    public void asyncExec(Key ... keys) {
        this._topGlobal = true;
        this._keys = keys;
        this._nlo = this.selfidx();
        this._nhi = (short)H2O.CLOUD.size();
        this.setupLocal0();
        H2O.submitTask(this);
    }

    public T doAllNodes() {
        return this.doAll((Key[])null);
    }

    public void asyncExecOnAllNodes() {
        this.asyncExec((Key[])null);
    }

    public T dfork(Frame fr) {
        return this.dfork(null, fr, false);
    }

    public final T dfork(Vec ... vecs) {
        return this.dfork((byte[])null, vecs);
    }

    public final T dfork(byte[] types, Vec ... vecs) {
        return this.dfork(types, new Frame(vecs), false);
    }

    public final T dfork(byte[] types, Frame fr, boolean run_local) {
        this._priority = this.nextThrPriority();
        this.asyncExec(types, fr, run_local);
        return this.self();
    }

    public final T asyncExec(Vec ... vecs) {
        this.asyncExec(null, new Frame(vecs), false);
        return this.self();
    }

    public final T asyncExec(Frame fr) {
        this.asyncExec(null, fr, false);
        return this.self();
    }

    public final void asyncExec(byte[] types, Frame fr, boolean run_local) {
        this._topGlobal = true;
        this._output_types = types;
        if (types != null && types.length > 0) {
            this._vid = fr.anyVec().group().reserveKeys(types.length);
        }
        this._fr = fr;
        this._nlo = this.selfidx();
        this._nhi = (short)H2O.CLOUD.size();
        this._run_local = run_local;
        this.setupLocal0();
        H2O.submitTask(this);
    }

    public final T getResult() {
        try {
            ForkJoinPool.managedBlock(this);
        }
        catch (InterruptedException ignore) {
        }
        catch (Throwable re) {
            this.setException(re);
        }
        DException.DistributedException de = this.getDException();
        if (de != null) {
            throw new RuntimeException(de);
        }
        assert (this._topGlobal) : "lost top global flag";
        return this.self();
    }

    @Override
    public boolean isReleasable() {
        return this.isDone();
    }

    @Override
    public boolean block() throws InterruptedException {
        while (!this.isDone()) {
            this.join();
        }
        return true;
    }

    @Override
    public final void dinvoke(H2ONode sender) {
        this.setupLocal0();
        H2O.submitTask(this);
    }

    private void setupLocal0() {
        if (this._doProfile) {
            this._profile = new MRProfile(this);
            this._profile._localstart = System.currentTimeMillis();
        }
        this._fs = new Futures();
        this._topLocal = true;
        short selfidx = this.selfidx();
        int nlo = this.subShift(selfidx);
        assert (nlo < this._nhi);
        int nmid = nlo + this._nhi >>> 1;
        if (H2O.ARGS.client) {
            if (this._doProfile) {
                this._profile._rpcLstart = System.currentTimeMillis();
            }
            RPC<T> rPC = this._nleft = this._run_local ? null : this.remote_compute(nlo, nmid);
            if (this._doProfile) {
                this._profile._rpcRstart = System.currentTimeMillis();
            }
            RPC<T> rPC2 = this._nrite = this._run_local ? null : this.remote_compute(nmid, this._nhi);
            if (this._doProfile) {
                this._profile._rpcRdone = System.currentTimeMillis();
            }
            this.setupLocal();
            if (this._doProfile) {
                this._profile._localdone = System.currentTimeMillis();
            }
            return;
        }
        if (!this._run_local && nlo + 1 < this._nhi) {
            if (this._doProfile) {
                this._profile._rpcLstart = System.currentTimeMillis();
            }
            this._nleft = this.remote_compute(nlo + 1, nmid);
            if (this._doProfile) {
                this._profile._rpcRstart = System.currentTimeMillis();
            }
            this._nrite = this.remote_compute(nmid, this._nhi);
            if (this._doProfile) {
                this._profile._rpcRdone = System.currentTimeMillis();
            }
        }
        if (this._fr != null) {
            this._lo = 0;
            this._hi = this._fr.numCols() == 0 ? 0 : this._fr.anyVec().nChunks();
            this._fr.vecs();
        } else if (this._keys != null) {
            this._lo = 0;
            this._hi = this._keys.length;
        }
        this.setupLocal();
        if (this._doProfile) {
            this._profile._localdone = System.currentTimeMillis();
        }
    }

    private RPC<T> remote_compute(int nlo, int nhi) {
        if (nlo < nhi) {
            int node = this.addShift(nlo);
            assert (node != H2O.SELF.index());
            T mrt = this.copyAndInit();
            ((MRTask)mrt)._nhi = (short)nhi;
            this.addToPendingCount(1);
            return new RPC<T>(H2O.CLOUD._memary[node], mrt).addCompleter(this).call();
        }
        return null;
    }

    @Override
    public final void compute2() {
        block32: {
            block31: {
                assert (this._left == null && this._rite == null && this._res == null);
                if (this._doProfile) {
                    this._profile._mapstart = System.currentTimeMillis();
                }
                if (this._hi - this._lo >= 2) {
                    int mid = this._lo + this._hi >>> 1;
                    this._left = this.copyAndInit();
                    this._rite = this.copyAndInit();
                    ((MRTask)this._left)._hi = mid;
                    ((MRTask)this._rite)._lo = mid;
                    this.addToPendingCount(1);
                    ((ForkJoinTask)this._left).fork();
                    ((MRTask)this._rite).compute2();
                    if (this._doProfile) {
                        this._profile._mapdone = System.currentTimeMillis();
                    }
                    return;
                }
                if (this._fr != null) break block31;
                if (this._keys != null && (this._hi <= this._lo || !this._keys[this._lo].home())) break block32;
                if (this._doProfile) {
                    this._profile._userstart = System.currentTimeMillis();
                }
                if (this._keys != null) {
                    this.map(this._keys[this._lo]);
                }
                this._res = this.self();
                if (!this._doProfile) break block32;
                this._profile._closestart = System.currentTimeMillis();
                break block32;
            }
            if (this._hi > this._lo) {
                Vec v0 = this._fr.anyVec();
                if (this._run_local || v0.chunkKey(this._lo).home()) {
                    Vec[] vecs = this._fr.vecs();
                    Chunk[] bvs = new Chunk[vecs.length];
                    NewChunk[] appendableChunks = null;
                    for (int i = 0; i < vecs.length; ++i) {
                        if (vecs[i] == null) continue;
                        assert (this._run_local || vecs[i].chunkKey(this._lo).home()) : "Chunk=" + this._lo + " v0=" + v0 + ", k=" + v0.chunkKey(this._lo) + "   v[" + i + "]=" + vecs[i] + ", k=" + vecs[i].chunkKey(this._lo);
                        bvs[i] = vecs[i].chunkForChunkIdx(this._lo);
                    }
                    if (this._output_types != null) {
                        Vec.VectorGroup vg = vecs[0].group();
                        this._appendables = new AppendableVec[this._output_types.length];
                        appendableChunks = new NewChunk[this._output_types.length];
                        for (int i = 0; i < this._appendables.length; ++i) {
                            this._appendables[i] = new AppendableVec(vg.vecKey(this._vid + i), this._output_types[i]);
                            appendableChunks[i] = this._appendables[i].chunkForChunkIdx(this._lo);
                        }
                    }
                    if (this._doProfile) {
                        this._profile._userstart = System.currentTimeMillis();
                    }
                    if (this._fr.vecs().length == 1) {
                        this.map(bvs[0]);
                    }
                    if (this._fr.vecs().length == 2) {
                        this.map(bvs[0], bvs[1]);
                    }
                    if (this._fr.vecs().length == 3) {
                        this.map(bvs[0], bvs[1], bvs[2]);
                    }
                    this.map(bvs);
                    if (this._output_types != null && this._output_types.length == 1) {
                        if (appendableChunks == null) {
                            throw H2O.fail();
                        }
                        if (this._fr.vecs().length == 1) {
                            this.map(bvs[0], appendableChunks[0]);
                        }
                        if (this._fr.vecs().length == 2) {
                            this.map(bvs[0], bvs[1], appendableChunks[0]);
                        }
                        if (this._fr.vecs().length == 3) {
                            this.map(bvs[0], bvs[1], bvs[2], appendableChunks[0]);
                        }
                        this.map(bvs, appendableChunks[0]);
                    }
                    if (this._output_types != null && this._output_types.length == 2) {
                        if (appendableChunks == null) {
                            throw H2O.fail();
                        }
                        if (this._fr.vecs().length == 1) {
                            this.map(bvs[0], (Chunk)appendableChunks[0], appendableChunks[1]);
                        }
                        if (this._fr.vecs().length == 2) {
                            this.map(bvs[0], bvs[1], appendableChunks[0], appendableChunks[1]);
                        }
                        if (this._fr.vecs().length == 3) {
                            this.map(bvs[0], bvs[1], bvs[2], appendableChunks[0], appendableChunks[1]);
                        }
                        this.map(bvs, appendableChunks[0], appendableChunks[1]);
                    }
                    this.map(bvs, appendableChunks);
                    this._res = this.self();
                    if (this._doProfile) {
                        this._profile._closestart = System.currentTimeMillis();
                    }
                    for (Chunk chunk : bvs) {
                        chunk.close(this._lo, this._fs);
                    }
                    if (this._output_types != null) {
                        for (Chunk chunk : appendableChunks) {
                            chunk.close(this._lo, this._fs);
                        }
                    }
                }
            }
        }
        if (this._doProfile) {
            this._profile._mapdone = System.currentTimeMillis();
        }
        this.tryComplete();
    }

    @Override
    public final void onCompletion(CountedCompleter caller) {
        if (this._doProfile) {
            this._profile._onCstart = System.currentTimeMillis();
        }
        this.reduce2((MRTask<T>)this._left);
        this._left = null;
        this.reduce2((MRTask<T>)this._rite);
        this._rite = null;
        if (this._doProfile) {
            this._profile._reducedone = System.currentTimeMillis();
        }
        if (this._topLocal) {
            this.postLocal();
        }
        if (this._doProfile) {
            this._profile._onCdone = System.currentTimeMillis();
        }
    }

    private void reduce2(MRTask<T> mrt) {
        if (mrt == null) {
            return;
        }
        if (this._doProfile) {
            this._profile.gather(mrt._profile, 0);
        }
        if (this._res == null) {
            this._res = mrt._res;
        } else if (mrt._res != null) {
            ((MRTask)this._res).reduce4(mrt._res);
        }
        assert (this._fs == mrt._fs);
    }

    protected void postGlobal() {
    }

    protected void postLocal() {
        this.reduce3(this._nleft);
        this.reduce3(this._nrite);
        if (this._doProfile) {
            this._profile._remoteBlkDone = System.currentTimeMillis();
        }
        this._fs.blockForPending();
        if (this._doProfile) {
            this._profile._localBlkDone = System.currentTimeMillis();
        }
        int nlo = this.subShift(this.selfidx());
        short nhi = this._nhi;
        if (this._res == null) {
            this._nhi = (short)-1;
        } else if (this._res != this) {
            ((MRTask)this._res)._profile = this._profile;
            this.copyOver(this._res);
        }
        this.closeLocal();
        if (this._topGlobal) {
            if (this._fr != null) {
                this._fr.postWrite(this._fs).blockForPending();
            }
            this.postGlobal();
        }
    }

    private void reduce3(RPC<T> rpc) {
        if (rpc == null) {
            return;
        }
        MRTask mrt = (MRTask)rpc.get();
        if (this._doProfile) {
            this._profile.gather(mrt._profile, rpc.size_rez());
        }
        if ((long)mrt._nhi != -1L) {
            if (this._res == null) {
                this._res = mrt;
            } else {
                this._res.reduce4((MRTask)mrt);
            }
        }
    }

    void reduce4(T mrt) {
        if (this._output_types != null) {
            for (int i = 0; i < this._appendables.length; ++i) {
                this._appendables[i].reduce(((MRTask)mrt)._appendables[i]);
            }
        }
        if (this._ex == null) {
            this._ex = ((MRTask)mrt)._ex;
        }
        this.reduce(mrt);
    }

    void self_cancel2() {
        if (!this.isDone()) {
            this.cancel(true);
            this.self_cancel1();
        }
    }

    private void self_cancel1() {
        T r;
        T l = this._left;
        if (l != null) {
            this._left = null;
            ((MRTask)l).self_cancel2();
        }
        if ((r = this._rite) != null) {
            this._rite = null;
            ((MRTask)r).self_cancel2();
        }
    }

    @Override
    public final boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
        if (!this.hasException()) {
            this.setException(ex);
        }
        this.self_cancel1();
        if (this._nleft != null) {
            try {
                this._nleft.get();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        this._nleft = null;
        if (this._nrite != null) {
            try {
                this._nrite.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this._nrite = null;
        return super.onExceptionalCompletion(ex, caller);
    }

    private T copyAndInit() {
        MRTask x = (MRTask)this.clone();
        x._topGlobal = false;
        x.setCompleter(this);
        x._topLocal = false;
        x._nrite = null;
        x._nleft = null;
        x._rite = null;
        x._left = null;
        x._fs = this._fs;
        x._profile = this._doProfile ? new MRProfile(this) : null;
        x.setPendingCount(0);
        return (T)x;
    }

    private static class MRProfile
    extends Iced {
        String _clz;
        long _localstart;
        long _rpcLstart;
        long _rpcRstart;
        long _rpcRdone;
        long _localdone;
        long _mapstart;
        long _userstart;
        long _closestart;
        long _mapdone;
        long _onCstart;
        long _reducedone;
        long _remoteBlkDone;
        long _localBlkDone;
        long _onCdone;
        long _time1st;
        long _done1st;
        int _size_rez0;
        int _size_rez1;
        MRProfile _last;

        public MRProfile(MRTask mrt) {
            this._clz = mrt.getClass().toString();
            this._localdone = System.currentTimeMillis();
        }

        long sumTime() {
            return this._onCdone - (this._localstart == 0L ? this._mapstart : this._localstart);
        }

        void gather(MRProfile p, int size_rez) {
            p._clz = null;
            if (this._last == null) {
                this._last = p;
                this._time1st = p.sumTime();
                this._done1st = p._onCdone;
            } else {
                MRProfile first = this._last._onCdone <= p._onCdone ? this._last : p;
                MRProfile mRProfile = this._last = this._last._onCdone > p._onCdone ? this._last : p;
                if (first._onCdone > this._done1st) {
                    this._time1st = first.sumTime();
                    this._done1st = first._onCdone;
                }
            }
            if (size_rez != 0) {
                if (this._size_rez0 == 0) {
                    this._size_rez0 = size_rez;
                } else {
                    this._size_rez1 = size_rez;
                }
            }
            assert (this._userstart != 0L || this._last != null);
            assert (this._last._onCdone >= this._done1st);
        }

        public String toString() {
            return this.print(new StringBuilder(), 0).toString();
        }

        private StringBuilder print(StringBuilder sb, int d) {
            int i;
            if (d == 0) {
                sb.append(this._clz).append("\n");
            }
            for (i = 0; i < d; ++i) {
                sb.append("  ");
            }
            if (this._localstart != 0L) {
                sb.append("Node local ").append(this._localdone - this._localstart).append("ms, ");
            }
            if (this._last != null) {
                sb.append("Slow wait ").append(this._mapstart - this._localdone).append("ms + work ").append(this._last.sumTime()).append("ms, ");
                sb.append("Fast work ").append(this._time1st).append("ms + wait ").append(this._onCstart - this._done1st).append("ms\n");
                this._last.print(sb, d + 1);
                for (i = 0; i < d; ++i) {
                    sb.append("  ");
                }
                sb.append("join-i/o ").append(this._onCstart - this._last._onCdone).append("ms, ");
            }
            if (this._userstart != 0L) {
                sb.append("Map ").append(this._mapdone - this._mapstart).append("ms (prep ").append(this._userstart - this._mapstart);
                sb.append("ms, user ").append(this._closestart - this._userstart);
                sb.append("ms, closeChk ").append(this._mapdone - this._closestart).append("ms), ");
            }
            sb.append("Red ").append(this._onCdone - this._onCstart).append("ms (locRed ");
            sb.append(this._reducedone - this._onCstart).append("ms");
            if (this._remoteBlkDone != 0L) {
                sb.append(", remBlk ").append(this._remoteBlkDone - this._reducedone).append("ms, locBlk ");
                sb.append(this._localBlkDone - this._remoteBlkDone).append("ms, close ");
                sb.append(this._onCdone - this._localBlkDone).append("ms, size ");
                sb.append(PrettyPrint.bytes(this._size_rez0)).append("+").append(PrettyPrint.bytes(this._size_rez1));
            }
            sb.append(")\n");
            return sb;
        }
    }
}

