/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.DTask;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Key;
import water.Paxos;
import water.RPC;
import water.Value;

public class TaskPutKey
extends DTask<TaskPutKey> {
    Key _key;
    Value _val;
    boolean _dontCache;
    transient Value _xval;
    transient Key _xkey;

    static void put(H2ONode h2o, Key key, Value val, Futures fs, boolean dontCache) {
        fs.add(RPC.call(h2o, new TaskPutKey(key, val, dontCache)));
    }

    protected TaskPutKey(Key key, Value val) {
        this(key, val, false);
    }

    protected TaskPutKey(Key key, Value val, boolean removeCache) {
        this._xkey = this._key = key;
        this._xval = this._val = val;
        this._dontCache = removeCache;
    }

    @Override
    public void dinvoke(H2ONode sender) {
        assert (this._key.home() || this._val == null);
        Paxos.lockCloud(this._key);
        if (this._val != null) {
            this._val.initReplicaHome(sender, this._key);
        } else if (this._key.home()) {
            this._val = Value.makeNull(this._key);
        }
        Value old = H2O.raw_get(this._key);
        while (H2O.putIfMatch(this._key, this._val, old) != old) {
            old = H2O.raw_get(this._key);
        }
        if (this._key.home()) {
            if (old != null) {
                old.lockAndInvalidate(sender, this._val, new Futures()).blockForPending();
            } else {
                this._val.lowerActiveGetCount(null);
            }
        }
        this._key = null;
        this._val = null;
        this.tryComplete();
    }

    @Override
    public void compute2() {
        throw H2O.fail();
    }

    @Override
    public void onAck() {
        if (this._dontCache && !this._xval.isPersisted()) {
            H2O.putIfMatch(this._xkey, null, this._xval);
        }
        if (this._xval != null) {
            this._xval.completeRemotePut();
        }
    }

    @Override
    public byte priority() {
        return 121;
    }
}

