/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import water.H2O;
import water.MRTask;
import water.api.FindV3;
import water.api.FrameV3;
import water.api.Handler;
import water.exceptions.H2OCategoricalLevelNotFoundArgumentException;
import water.exceptions.H2OColumnNotFoundArgumentException;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.IcedHashMap;

class FindHandler
extends Handler {
    FindHandler() {
    }

    public FindV3 find(int version, FindV3 find) {
        Frame frame = (Frame)find.key.createAndFillImpl();
        if (find.column != null) {
            Vec vec = frame.vec(find.column);
            if (vec == null) {
                throw new H2OColumnNotFoundArgumentException("column", frame, find.column);
            }
            find.key = new FrameV3(new Frame(new String[]{find.column}, new Vec[]{vec}));
        }
        Vec[] vecs = frame.vecs();
        double[] ds = new double[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            if (vecs[i].isCategorical()) {
                int idx = ArrayUtils.find(vecs[i].domain(), find.match);
                if (idx == -1 && vecs.length == 1) {
                    throw new H2OCategoricalLevelNotFoundArgumentException("match", find.match, frame._key.toString(), frame.name(i));
                }
                ds[i] = idx;
                continue;
            }
            if (vecs[i].isUUID()) {
                throw H2O.unimpl();
            }
            if (vecs[i].isString()) {
                throw H2O.unimpl();
            }
            if (vecs[i].isTime()) {
                throw H2O.unimpl();
            }
            try {
                ds[i] = find.match == null ? Double.NaN : Double.parseDouble(find.match);
                continue;
            }
            catch (NumberFormatException e) {
                if (vecs.length == 1) {
                    IcedHashMap.IcedHashMapStringObject values = new IcedHashMap.IcedHashMapStringObject();
                    String msg = "Frame: " + frame._key.toString() + " as only one column, it is numeric, and the find pattern is not numeric: " + find.match;
                    values.put("frame_name", frame._key.toString());
                    values.put("column_name", frame.name(i));
                    values.put("pattern", find.match);
                    throw new H2OIllegalArgumentException(msg, msg, values);
                }
                ds[i] = Double.longBitsToDouble(-889275714L);
            }
        }
        Find f = (Find)new Find(find.row, ds).doAll(frame);
        find.prev = f._prev;
        find.next = f._next == Long.MAX_VALUE ? -1L : f._next;
        return find;
    }

    private static class Find
    extends MRTask<Find> {
        final long _row;
        final double[] _ds;
        long _prev;
        long _next;

        Find(long row, double[] ds) {
            this._row = row;
            this._ds = ds;
            this._prev = -1L;
            this._next = Long.MAX_VALUE;
        }

        @Override
        public void map(Chunk[] cs) {
            for (int col = 0; col < cs.length; ++col) {
                Chunk C = cs[col];
                for (int row = 0; row < C._len; ++row) {
                    if (C.atd(row) != this._ds[col] && (!C.isNA(row) || !Double.isNaN(this._ds[col]))) continue;
                    long r = C.start() + (long)row;
                    if (r < this._row) {
                        if (r <= this._prev) continue;
                        this._prev = r;
                        continue;
                    }
                    if (r <= this._row || r >= this._next) continue;
                    this._next = r;
                }
            }
        }

        @Override
        public void reduce(Find f) {
            if (this._prev < f._prev) {
                this._prev = f._prev;
            }
            if (this._next > f._next) {
                this._next = f._next;
            }
        }
    }
}

