/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jsr166y.CountedCompleter;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.KeySnapshot;
import water.Value;
import water.api.FrameBase;
import water.api.FrameV3;
import water.api.FramesBase;
import water.api.FramesV3;
import water.api.Handler;
import water.api.JobV3;
import water.api.ModelSchema;
import water.api.ModelsHandler;
import water.api.Schema;
import water.exceptions.H2OColumnNotFoundArgumentException;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2OKeyWrongTypeArgumentException;
import water.exceptions.H2OKeysNotFoundArgumentException;
import water.exceptions.H2OParseException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.persist.PersistManager;
import water.util.KeyedVoid;
import water.util.Log;

class FramesHandler<I extends Frames, S extends FramesBase<I, S>>
extends Handler {
    FramesHandler() {
    }

    public FramesV3 list(int version, FramesV3 s) {
        Frames f = (Frames)s.createAndFillImpl();
        f.frames = Frames.fetchAll();
        s.fillFromImplWithSynopsis(f);
        return s;
    }

    public FramesV3 columns(int version, FramesV3 s) {
        return this.fetch(version, s);
    }

    public static Frame getFromDKV(String param_name, String key_str) {
        return FramesHandler.getFromDKV(param_name, Key.make(key_str));
    }

    public static Frame getFromDKV(String param_name, Key key) {
        if (null == key) {
            throw new H2OIllegalArgumentException(param_name, "Frames.getFromDKV()", key);
        }
        Value v = DKV.get(key);
        if (null == v) {
            throw new H2OKeyNotFoundArgumentException(param_name, key.toString());
        }
        Object ice = v.get();
        if (ice instanceof Vec) {
            return new Frame((Vec)ice);
        }
        if (!(ice instanceof Frame)) {
            throw new H2OKeyWrongTypeArgumentException(param_name, key.toString(), Frame.class, ice.getClass());
        }
        return (Frame)ice;
    }

    public FramesV3 column(int version, FramesV3 s) {
        Frame frame = FramesHandler.getFromDKV("key", s.frame_id.key());
        Vec vec = frame.vec(s.column);
        if (null == vec) {
            throw new H2OColumnNotFoundArgumentException("column", s.frame_id.toString(), s.column);
        }
        Vec[] vecs = new Vec[]{vec};
        String[] names = new String[]{s.column};
        Frame new_frame = new Frame(names, vecs);
        s.frames = new FrameV3[1];
        s.frames[0] = new FrameV3().fillFromImpl(new_frame);
        ((FrameV3)s.frames[0]).clearBinsField();
        return s;
    }

    public FramesV3 columnDomain(int version, FramesV3 s) {
        Frame frame = FramesHandler.getFromDKV("key", s.frame_id.key());
        Vec vec = frame.vec(s.column);
        if (vec == null) {
            throw new H2OColumnNotFoundArgumentException("column", s.frame_id.toString(), s.column);
        }
        s.domain = new String[1][];
        s.domain[0] = vec.domain();
        return s;
    }

    public FramesV3 columnSummary(int version, FramesV3 s) {
        Frame frame = FramesHandler.getFromDKV("key", s.frame_id.key());
        Vec vec = frame.vec(s.column);
        if (null == vec) {
            throw new H2OColumnNotFoundArgumentException("column", s.frame_id.toString(), s.column);
        }
        vec.bins();
        s.frames = new FrameV3[1];
        s.frames[0] = new FrameV3().fillFromImpl(new Frame(new String[]{s.column}, new Vec[]{vec}), s.row_offset, s.row_count, s.column_offset, s.column_count);
        return s;
    }

    public StringBuffer columnSummaryDocs(int version, StringBuffer docs) {
        return null;
    }

    public FramesV3 fetch(int version, FramesV3 s) {
        FramesV3 frames = this.doFetch(version, s);
        for (FrameBase a_frame : frames.frames) {
            ((FrameV3)a_frame).clearBinsField();
        }
        return frames;
    }

    private FramesV3 doFetch(int version, FramesV3 s) {
        Frames f = (Frames)s.createAndFillImpl();
        Frame frame = FramesHandler.getFromDKV("key", s.frame_id.key());
        s.frames = new FrameV3[1];
        s.frames[0] = new FrameV3(frame, s.row_offset, s.row_count).fillFromImpl(frame, s.row_offset, s.row_count, s.column_offset, s.column_count);
        if (s.find_compatible_models) {
            Model[] compatible = Frames.findCompatibleModels(frame, ModelsHandler.Models.fetchAll());
            s.compatible_models = new ModelSchema[compatible.length];
            ((FrameV3)s.frames[0]).compatible_models = new String[compatible.length];
            int i = 0;
            for (Model m : compatible) {
                s.compatible_models[i] = (ModelSchema)Schema.schema(version, m).fillFromImpl(m);
                ((FrameV3)s.frames[0]).compatible_models[i] = m._key.toString();
                ++i;
            }
        }
        return s;
    }

    public FramesV3 export(int version, FramesV3 s) {
        Frame fr = FramesHandler.getFromDKV("key", s.frame_id.key());
        Log.info("ExportFiles processing (" + s.path + ")");
        s.job = (JobV3)Schema.schema(version, Job.class).fillFromImpl(ExportDatasetJob.export(fr, s.path, s.frame_id.key().toString(), s.force));
        return s;
    }

    public FramesV3 summary(int version, FramesV3 s) {
        Frame frame = FramesHandler.getFromDKV("key", s.frame_id.key());
        if (null != frame) {
            Futures fs = new Futures();
            for (Vec v : frame.vecs()) {
                v.startRollupStats(fs, true);
            }
            fs.blockForPending();
        }
        return this.doFetch(version, s);
    }

    public FramesV3 delete(int version, FramesV3 frames) {
        Frame frame = FramesHandler.getFromDKV("key", frames.frame_id.key());
        frame.delete();
        return frames;
    }

    public FramesV3 deleteAll(int version, FramesV3 frames) {
        Key[] keys = KeySnapshot.globalKeysOfClass(Frame.class);
        ArrayList<String> missing = new ArrayList<String>();
        Futures fs = new Futures();
        for (int i = 0; i < keys.length; ++i) {
            try {
                FramesHandler.getFromDKV("(none)", keys[i]).delete(null, fs);
                continue;
            }
            catch (IllegalArgumentException iae) {
                missing.add(keys[i].toString());
            }
        }
        fs.blockForPending();
        if (missing.size() != 0) {
            throw new H2OKeysNotFoundArgumentException("(none)", missing.toArray(new String[missing.size()]));
        }
        return frames;
    }

    private static class ExportDatasetJob
    extends Job<KeyedVoid> {
        private ExportDatasetJob(String path) {
            super(Key.make(path), "Export frame");
        }

        private static ExportDatasetJob export(Frame fr, String path, String frameName, boolean overwrite) {
            boolean fileExists = H2O.getPM().exists(path);
            if (overwrite && fileExists) {
                Log.warn("File " + path + " exists, but will be overwritten!");
            } else if (!overwrite && fileExists) {
                throw new H2OIllegalArgumentException(path, "exportFrame", "File " + path + " already exists!");
            }
            InputStream is = fr.toCSV(true, false);
            ExportDatasetJob job = new ExportDatasetJob(path);
            ExportTask t = new ExportTask(is, path, frameName, overwrite, job);
            job.start(t, fr.anyVec().nChunks(), true);
            return job;
        }

        private static class ExportTask
        extends H2O.H2OCountedCompleter<ExportTask> {
            final InputStream _csv;
            final String _path;
            final String _frameName;
            final boolean _overwrite;
            final Job _j;

            ExportTask(InputStream csv, String path, String frameName, boolean overwrite, Job j) {
                this._csv = csv;
                this._path = path;
                this._frameName = frameName;
                this._overwrite = overwrite;
                this._j = j;
            }

            private long copyStream(OutputStream os, int buffer_size) {
                long len = 0L;
                int curIdx = 0;
                try {
                    int count;
                    byte[] bytes = new byte[buffer_size];
                    while ((count = this._csv.read(bytes, 0, buffer_size)) > 0) {
                        len += (long)count;
                        os.write(bytes, 0, count);
                        int workDone = ((Frame.CSVStream)this._csv)._curChkIdx;
                        if (curIdx == workDone) continue;
                        this._j.update(workDone - curIdx);
                        curIdx = workDone;
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                return len;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void compute2() {
                block6: {
                    PersistManager pm = H2O.getPM();
                    OutputStream os = null;
                    long written = -1L;
                    try {
                        os = pm.create(this._path, this._overwrite);
                        written = this.copyStream(os, 0x400000);
                        if (os == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (os == null) throw throwable;
                        try {
                            os.flush();
                            os.close();
                            Log.info("Key '" + this._frameName + "' of " + written + " bytes was written to " + this._path + ".");
                            throw throwable;
                        }
                        catch (Exception e) {
                            Log.err(e);
                        }
                        throw throwable;
                    }
                    try {
                        os.flush();
                        os.close();
                        Log.info("Key '" + this._frameName + "' of " + written + " bytes was written to " + this._path + ".");
                    }
                    catch (Exception e) {
                        Log.err(e);
                    }
                }
                this.tryComplete();
            }

            @Override
            public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
                if (this._j != null) {
                    this._j.cancel();
                    if (ex instanceof H2OParseException) {
                        throw (H2OParseException)ex;
                    }
                    this._j.failed(ex);
                }
                return true;
            }

            @Override
            public void onCompletion(CountedCompleter caller) {
                this._j.done();
            }
        }
    }

    protected static final class Frames
    extends Iced {
        Key frame_id;
        long row_offset;
        int row_count;
        long column_offset;
        int column_count;
        Frame[] frames;
        String column;
        public boolean find_compatible_models = false;

        protected Frames() {
        }

        protected static Frame[] fetchAll() {
            Key[] frameKeys = KeySnapshot.globalKeysOfClass(Frame.class);
            ArrayList<Frame> frames = new ArrayList<Frame>(frameKeys.length);
            for (int i = 0; i < frameKeys.length; ++i) {
                Frame frame = FramesHandler.getFromDKV("(none)", frameKeys[i]);
                Vec[] vs = frame.vecs();
                boolean skip = false;
                for (int j = 0; j < vs.length; ++j) {
                    if (DKV.get(vs[j]._key) != null) continue;
                    Log.warn("Leaked frame: Frame " + frame._key + " points to one or more deleted vecs.");
                    skip = true;
                    break;
                }
                if (skip) continue;
                frames.add(frame);
            }
            return frames.toArray(new Frame[frames.size()]);
        }

        protected static Map<Model, Set<String>> fetchModelCols(Model[] all_models) {
            HashMap<Model, Set<String>> all_models_cols = new HashMap<Model, Set<String>>();
            for (Model m : all_models) {
                all_models_cols.put(m, new HashSet<String>(Arrays.asList(((Model.Output)m._output)._names)));
            }
            return all_models_cols;
        }

        private static Model[] findCompatibleModels(Frame frame, Model[] all_models) {
            Map<Model, Set<String>> all_models_cols = Frames.fetchModelCols(all_models);
            ArrayList<Model> compatible_models = new ArrayList<Model>();
            HashSet<String> frame_column_names = new HashSet<String>(Arrays.asList(frame._names));
            for (Map.Entry<Model, Set<String>> entry : all_models_cols.entrySet()) {
                Model model = entry.getKey();
                Set<String> model_cols = entry.getValue();
                if (!frame_column_names.containsAll(model_cols)) continue;
                try {
                    if (model.adaptTestForTrain(new Frame(frame), false, false).length != 0) continue;
                    compatible_models.add(model);
                }
                catch (IllegalArgumentException e) {}
            }
            return compatible_models.toArray(new Model[0]);
        }
    }
}

