/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Value;
import water.api.Route;
import water.api.Schema;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2OKeyWrongTypeArgumentException;
import water.util.Log;
import water.util.ReflectionUtils;
import water.util.annotations.IgnoreJRERequirement;

public class Handler
extends H2O.H2OCountedCompleter {
    private long _t_start;
    private long _t_stop;

    protected Handler() {
    }

    protected Handler(Handler completer) {
        super(completer);
    }

    public static Class<? extends Schema> getHandlerMethodInputSchema(Method method) {
        return ReflectionUtils.findMethodParameterClass(method, 1);
    }

    public static Class<? extends Schema> getHandlerMethodOutputSchema(Method method) {
        return ReflectionUtils.findMethodOutputClass(method);
    }

    final Schema handle(int version, Route route, Properties parms) throws Exception {
        Class<? extends Schema> handler_schema_class = Handler.getHandlerMethodInputSchema(route._handler_method);
        Schema schema = Schema.newInstance(handler_schema_class);
        if (null == schema) {
            throw H2O.fail("Failed to instantiate Schema of class: " + handler_schema_class + " for route: " + route);
        }
        Class iced_class = schema.getImplClass();
        if (iced_class != Iced.class) {
            Object defaults = schema.createImpl();
            schema.fillFromImpl(defaults);
        }
        if (null == (schema = schema.fillFromParms(parms))) {
            throw H2O.fail("fillFromParms returned a null schema for version: " + version + " in: " + this.getClass() + " with params: " + parms);
        }
        this._t_start = System.currentTimeMillis();
        Schema result = null;
        try {
            result = (Schema)route._handler_method.invoke((Object)this, version, schema);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
        this._t_stop = System.currentTimeMillis();
        return result;
    }

    @Override
    protected final void compute2() {
        throw H2O.fail();
    }

    @IgnoreJRERequirement
    protected StringBuffer markdown(Handler handler, int version, StringBuffer docs, String filename) {
        StringBuffer sb = new StringBuffer();
        Path path = Paths.get(filename, new String[0]);
        try {
            sb.append(Files.readAllBytes(path));
        }
        catch (IOException e) {
            Log.warn("Caught IOException trying to read doc file: ", path);
        }
        if (null != docs) {
            docs.append(sb);
        }
        return sb;
    }

    public static <T extends Keyed> T getFromDKV(String param_name, String key, Class<T> klazz) {
        return Handler.getFromDKV(param_name, Key.make(key), klazz);
    }

    public static <T extends Keyed> T getFromDKV(String param_name, Key key, Class<T> klazz) {
        if (null == key) {
            throw new H2OIllegalArgumentException(param_name, "Handler.getFromDKV()", key);
        }
        Value v = DKV.get(key);
        if (null == v) {
            throw new H2OKeyNotFoundArgumentException(param_name, key.toString());
        }
        Object ice = v.get();
        if (!klazz.isInstance(ice)) {
            throw new H2OKeyWrongTypeArgumentException(param_name, key.toString(), klazz, ice.getClass());
        }
        return (T)((Keyed)ice);
    }
}

