/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import water.H2O;
import water.Job;
import water.Key;
import water.api.API;
import water.api.KeyV3;
import water.api.Schema;
import water.api.ValidationMessageBase;
import water.api.ValidationMessageV3;
import water.util.Log;
import water.util.PojoUtils;
import water.util.ReflectionUtils;

public class JobV3<J extends Job, S extends JobV3<J, S>>
extends Schema<J, S> {
    @API(help="Job Key")
    public KeyV3.JobKeyV3 key;
    @API(help="Job description")
    public String description;
    @API(help="job status", direction=API.Direction.OUTPUT)
    public String status;
    @API(help="progress, from 0 to 1", direction=API.Direction.OUTPUT)
    public float progress;
    @API(help="current progress status description", direction=API.Direction.OUTPUT)
    public String progress_msg;
    @API(help="Start time", direction=API.Direction.OUTPUT)
    public long start_time;
    @API(help="Runtime in milliseconds", direction=API.Direction.OUTPUT)
    public long msec;
    @API(help="destination key", direction=API.Direction.INOUT)
    public KeyV3 dest;
    @API(help="exception", direction=API.Direction.OUTPUT)
    public String exception;
    @API(help="Info, warning and error messages; NOTE: can be appended to while the Job is running", direction=API.Direction.OUTPUT)
    public ValidationMessageBase[] messages;
    @API(help="Count of error messages", direction=API.Direction.OUTPUT)
    public int error_count;

    @Override
    public J createImpl() {
        try {
            Key k = this.key == null ? Key.make() : this.key.key();
            return (J)((Job)this.getImplClass().getConstructor(Key.class, String.class).newInstance(k, this.description));
        }
        catch (Exception e) {
            String msg = "Exception instantiating implementation object of class: " + this.getImplClass().toString() + " for schema class: " + this.getClass();
            Log.err(msg + ": " + e);
            throw H2O.fail(msg, e);
        }
    }

    @Override
    public S fillFromImpl(Job job) {
        Job.ValidationMessage vm;
        PojoUtils.copyProperties(this, job, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES);
        PojoUtils.copyProperties(this, job, PojoUtils.FieldNaming.CONSISTENT);
        this.key = new KeyV3.JobKeyV3((Key<Job>)job._key);
        this.description = job._description;
        this.progress = job.progress();
        this.progress_msg = job.progress_msg();
        this.status = job._state.toString();
        this.msec = (job.isStopped() ? job._end_time : System.currentTimeMillis()) - job._start_time;
        Key dest_key = job.dest();
        Class dest_class = ReflectionUtils.findActualClassParameter(job.getClass(), 0);
        this.dest = KeyV3.forKeyedClass(dest_class, dest_key);
        this.exception = job._exception;
        Job.ValidationMessage[] vms = job._messages;
        int num_messages = vms.length;
        this.messages = new ValidationMessageBase[num_messages];
        this.error_count = 0;
        for (int i = 0; i < num_messages && null != (vm = vms[i]); ++i) {
            this.messages[i] = new ValidationMessageV3().fillFromImpl(vm);
            if (vm.getMessageType() != Job.ValidationMessage.MessageType.ERROR) continue;
            ++this.error_count;
        }
        return (S)this;
    }

    public static String link(Key key) {
        return "/Jobs/" + key;
    }
}

