/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import hex.grid.Grid;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import water.DKV;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.Value;
import water.api.API;
import water.api.Schema;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Assembly;
import water.util.KeyedVoid;
import water.util.ReflectionUtils;

public class KeyV3<I extends Iced, S extends KeyV3<I, S, K>, K extends Keyed>
extends Schema<I, S> {
    @API(help="Name (string representation) for this Key.", direction=API.Direction.INOUT)
    public String name;
    @API(help="Name (string representation) for the type of Keyed this Key points to.", direction=API.Direction.INOUT)
    public String type;
    @API(help="URL for the resource that this Key points to, if one exists.", direction=API.Direction.INOUT)
    public String URL;

    public KeyV3() {
        this.get__meta().setSchema_type("Key<" + this.getKeyedClassType() + ">");
    }

    public KeyV3(Key key) {
        this();
        if (null != key) {
            Class<Keyed> clz = this.getKeyedClass();
            Value v = DKV.get(key);
            if (null != v) {
                if (Job.class.isAssignableFrom(clz) && !v.isJob()) {
                    throw new H2OIllegalArgumentException("For Key: " + key + " expected a value of type Job; found a: " + v.theFreezableClass(), "For Key: " + key + " expected a value of type Job; found a: " + v.theFreezableClass() + " (" + clz + ")");
                }
                if (Frame.class.isAssignableFrom(clz) && !v.isFrame() && !v.isVec()) {
                    throw new H2OIllegalArgumentException("For Key: " + key + " expected a value of type Frame; found a: " + v.theFreezableClass(), "For Key: " + key + " expected a value of type Frame; found a: " + v.theFreezableClass() + " (" + clz + ")");
                }
                if (Model.class.isAssignableFrom(clz) && !v.isModel()) {
                    throw new H2OIllegalArgumentException("For Key: " + key + " expected a value of type Model; found a: " + v.theFreezableClass(), "For Key: " + key + " expected a value of type Model; found a: " + v.theFreezableClass() + " (" + clz + ")");
                }
                if (Vec.class.isAssignableFrom(clz) && !v.isVec()) {
                    throw new H2OIllegalArgumentException("For Key: " + key + " expected a value of type Vec; found a: " + v.theFreezableClass(), "For Key: " + key + " expected a value of type Vec; found a: " + v.theFreezableClass() + " (" + clz + ")");
                }
            }
            this.fillFromImpl(key);
        }
    }

    public static KeyV3 make(Class<? extends KeyV3> clz, Key key) {
        KeyV3 result = null;
        try {
            Constructor<? extends KeyV3> c = clz.getConstructor(Key.class);
            result = c.newInstance(key);
        }
        catch (Exception e) {
            throw new H2OIllegalArgumentException("Caught exception trying to instantiate KeyV1 for class: " + clz.toString() + ": " + e + "; cause: " + e.getCause() + " " + Arrays.toString(e.getCause().getStackTrace()));
        }
        return result;
    }

    public static KeyV3 make(Key key) {
        return KeyV3.make(KeyV3.class, key);
    }

    public static KeyV3 forKeyedClass(Class<? extends Keyed> keyed_class, Key key) {
        if (Job.class.isAssignableFrom(keyed_class)) {
            return KeyV3.make(JobKeyV3.class, key);
        }
        if (Frame.class.isAssignableFrom(keyed_class)) {
            return KeyV3.make(FrameKeyV3.class, key);
        }
        if (Model.class.isAssignableFrom(keyed_class)) {
            return KeyV3.make(ModelKeyV3.class, key);
        }
        if (Vec.class.isAssignableFrom(keyed_class)) {
            return KeyV3.make(VecKeyV3.class, key);
        }
        if (Grid.class.isAssignableFrom(keyed_class)) {
            return KeyV3.make(GridKeyV3.class, key);
        }
        if (KeyedVoid.class.isAssignableFrom(keyed_class)) {
            return KeyV3.make(KeyedVoidV3.class, key);
        }
        return KeyV3.make(KeyV3.class, key);
    }

    @Override
    public S fillFromImpl(Iced i) {
        Class<Keyed> keyed_class;
        String vc;
        if (!(i instanceof Key)) {
            throw new H2OIllegalArgumentException("fillFromImpl", "key", i);
        }
        Key key = (Key)i;
        if (null == key) {
            return (S)this;
        }
        this.name = key.toString();
        this.type = "Key<" + this.getKeyedClassType() + ">";
        if ("Keyed".equals(this.type) && null != (vc = key.valueClassSimple())) {
            this.type = "Key<" + vc + ">";
        }
        this.URL = Job.class.isAssignableFrom(keyed_class = this.getKeyedClass()) ? "/" + Schema.getHighestSupportedVersion() + "/Jobs/" + key.toString() : (Frame.class.isAssignableFrom(keyed_class) ? "/" + Schema.getHighestSupportedVersion() + "/Frames/" + key.toString() : (Model.class.isAssignableFrom(keyed_class) ? "/" + Schema.getHighestSupportedVersion() + "/Models/" + key.toString() : (Vec.class.isAssignableFrom(keyed_class) ? null : null)));
        return (S)this;
    }

    public static Class<? extends Keyed> getKeyedClass(Class<? extends KeyV3> clz) {
        if (clz == KeyV3.class) {
            return Keyed.class;
        }
        return ReflectionUtils.findActualClassParameter(clz, 2);
    }

    public Class<? extends Keyed> getKeyedClass() {
        return KeyV3.getKeyedClass(this.getClass());
    }

    public static String getKeyedClassType(Class<? extends KeyV3> clz) {
        Class<Keyed> keyed_class = KeyV3.getKeyedClass(clz);
        return keyed_class.getSimpleName();
    }

    public String getKeyedClassType() {
        return KeyV3.getKeyedClassType(this.getClass());
    }

    public Key<K> key() {
        if (null == this.name) {
            return null;
        }
        return Key.make(this.name);
    }

    @Override
    public I createImpl() {
        return (I)Key.make(this.name);
    }

    public String toString() {
        return this.type + " " + this.name;
    }

    public static class AssemblyKeyV3
    extends KeyV3<Iced, AssemblyKeyV3, Assembly> {
        public AssemblyKeyV3() {
        }

        public AssemblyKeyV3(Key<Assembly> key) {
            super(key);
        }
    }

    public static class KeyedVoidV3
    extends KeyV3<Iced, KeyedVoidV3, KeyedVoid> {
        public KeyedVoidV3() {
        }

        public KeyedVoidV3(Key<KeyedVoid> key) {
            super(key);
        }
    }

    public static class GridKeyV3
    extends KeyV3<Iced, GridKeyV3, Grid> {
        public GridKeyV3() {
        }

        public GridKeyV3(Key<Grid> key) {
            super(key);
        }
    }

    public static class VecKeyV3
    extends KeyV3<Iced, VecKeyV3, Vec> {
        public VecKeyV3() {
        }

        public VecKeyV3(Key<Vec> key) {
            super(key);
        }
    }

    public static class ModelKeyV3
    extends KeyV3<Iced, ModelKeyV3, Model> {
        public ModelKeyV3() {
        }

        public ModelKeyV3(Key<? extends Model> key) {
            super(key);
        }
    }

    public static class FrameKeyV3
    extends KeyV3<Iced, FrameKeyV3, Frame> {
        public FrameKeyV3() {
        }

        public FrameKeyV3(Key<Frame> key) {
            super(key);
        }
    }

    public static class JobKeyV3
    extends KeyV3<Iced, JobKeyV3, Job> {
        public JobKeyV3() {
        }

        public JobKeyV3(Key<Job> key) {
            super(key);
        }
    }
}

