/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.ModelBuilder;
import hex.schemas.ModelBuilderSchema;
import water.Job;
import water.api.Handler;
import water.api.JobV3;
import water.api.ModelParametersSchema;
import water.api.Schema;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.util.HttpResponseStatus;
import water.util.PojoUtils;

public abstract class ModelBuilderHandler<B extends ModelBuilder, S extends ModelBuilderSchema<B, S, P>, P extends ModelParametersSchema>
extends Handler {
    public S do_train(int version, S builderSchema) {
        ModelBuilder builder = (ModelBuilder)((Schema)builderSchema).createAndFillImpl();
        if (builder.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(builder);
        }
        Job j = builder.trainModel();
        ((ModelBuilderSchema)builderSchema).job = (JobV3)Schema.schema(version, Job.class).fillFromImpl(j);
        PojoUtils.copyProperties(((ModelBuilderSchema)builderSchema).parameters, builder._parms, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES, null, new String[]{"error_count", "messages"});
        ((ModelBuilderSchema)builderSchema).setHttpStatus(HttpResponseStatus.OK.getCode());
        return builderSchema;
    }

    public S do_validate_parameters(int version, S builderSchema) {
        ModelBuilder builder = (ModelBuilder)((Schema)builderSchema).createAndFillImpl();
        Object builder_schema = builder.schema().fillFromImpl(builder);
        ((ModelBuilderSchema)builder_schema).setHttpStatus(HttpResponseStatus.OK.getCode());
        return builder_schema;
    }
}

