/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.ModelBuilder;
import hex.schemas.ModelBuilderSchema;
import water.Job;
import water.api.API;
import water.api.JobV3;
import water.api.ModelParametersSchema;
import water.api.Schema;
import water.api.ValidationMessageBase;
import water.api.ValidationMessageV3;

public class ModelBuilderJobV3<J extends ModelBuilder, S extends ModelBuilderJobV3<J, S>>
extends JobV3<J, S> {
    @API(help="Model builder parameters.", direction=API.Direction.OUTPUT)
    public ModelParametersSchema parameters;

    @Override
    public S fillFromImpl(ModelBuilder builder) {
        super.fillFromImpl(builder);
        this.messages = new ValidationMessageBase[builder._messages.length];
        int i = 0;
        for (Job.ValidationMessage vm : builder._messages) {
            this.messages[i++] = new ValidationMessageV3().fillFromImpl(vm);
        }
        ValidationMessageBase.mapValidationMessageFieldNames(this.messages, new String[]{"_train", "_valid"}, new String[]{"training_frame", "validation_frame"});
        this.error_count = builder.error_count();
        ModelBuilderSchema s = (ModelBuilderSchema)Schema.schema(this.getSchemaVersion(), builder).fillFromImpl(builder);
        this.parameters = s.parameters;
        return (S)this;
    }
}

