/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.ModelBuilder;
import hex.schemas.ModelBuilderSchema;
import java.util.Map;
import water.H2O;
import water.Iced;
import water.api.API;
import water.api.Handler;
import water.api.ModelBuildersV3;
import water.api.Schema;
import water.exceptions.H2OIllegalArgumentException;

class ModelBuildersHandler
extends Handler {
    ModelBuildersHandler() {
    }

    public ModelBuildersVisibilityV3 setVisibility(int version, ModelBuildersVisibilityV3 m) {
        if (m.value.equals("Stable")) {
            H2O.ARGS.model_builders_visibility = ModelBuilder.BuilderVisibility.Stable;
        } else if (m.value.equals("Beta")) {
            H2O.ARGS.model_builders_visibility = ModelBuilder.BuilderVisibility.Beta;
        } else if (m.value.equals("Experimental")) {
            H2O.ARGS.model_builders_visibility = ModelBuilder.BuilderVisibility.Experimental;
        } else {
            throw new H2OIllegalArgumentException("value", "setVisibility", "Level must be one of (Stable, Beta, Experimental)");
        }
        return this.getVisibility(version, m);
    }

    public ModelBuildersVisibilityV3 getVisibility(int version, ModelBuildersVisibilityV3 m) {
        m.value = H2O.ARGS.model_builders_visibility.toString();
        return m;
    }

    public ModelBuildersV3 list(int version, ModelBuildersV3 m) {
        Map<String, Class<ModelBuilder>> builders = ModelBuilder.getModelBuilders();
        m.model_builders = new ModelBuilderSchema.IcedHashMapStringModelBuilderSchema();
        for (Map.Entry<String, Class<ModelBuilder>> entry : builders.entrySet()) {
            String algo = entry.getKey();
            ModelBuilder builder = ModelBuilder.createModelBuilder(algo);
            m.model_builders.put(algo, (ModelBuilderSchema)Schema.schema(version, builder).fillFromImpl(builder));
        }
        return m;
    }

    public ModelBuildersV3 fetch(int version, ModelBuildersV3 m) {
        m.model_builders = new ModelBuilderSchema.IcedHashMapStringModelBuilderSchema();
        ModelBuilder builder = ModelBuilder.createModelBuilder(m.algo);
        m.model_builders.put(m.algo, (ModelBuilderSchema)Schema.schema(version, builder).fillFromImpl(builder));
        return m;
    }

    public ModelIdV3 calcModelId(int version, ModelBuildersV3 m) {
        m.model_builders = new ModelBuilderSchema.IcedHashMapStringModelBuilderSchema();
        String model_id = H2O.calcNextUniqueModelId(m.algo);
        ModelIdV3 mm = new ModelIdV3();
        mm.model_id = model_id;
        return mm;
    }

    public static class ModelIdV3
    extends Schema<Iced, ModelIdV3> {
        @API(help="Model ID", direction=API.Direction.OUTPUT)
        String model_id;
    }

    public static class ModelBuildersVisibilityV3
    extends Schema<Iced, ModelBuildersVisibilityV3> {
        @API(help="Stable, Beta, Experimental", direction=API.Direction.INOUT)
        public String value;
    }
}

