/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import hex.ScoreKeeper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import water.AutoBuffer;
import water.DKV;
import water.Freezable;
import water.H2O;
import water.Key;
import water.Value;
import water.api.API;
import water.api.FrameV3;
import water.api.KeyV3;
import water.api.ModelParameterSchemaV3;
import water.api.Schema;
import water.fvec.Frame;
import water.util.PojoUtils;

public class ModelParametersSchema<P extends Model.Parameters, S extends ModelParametersSchema<P, S>>
extends Schema<P, S> {
    @API(help="Destination id for this model; auto-generated if not specified", required=false, direction=API.Direction.INOUT)
    public KeyV3.ModelKeyV3 model_id;
    @API(help="Training frame", direction=API.Direction.INOUT)
    public KeyV3.FrameKeyV3 training_frame;
    @API(help="Validation frame", direction=API.Direction.INOUT, gridable=true)
    public KeyV3.FrameKeyV3 validation_frame;
    @API(help="Number of folds for N-fold cross-validation", level=API.Level.critical, direction=API.Direction.INOUT)
    public int nfolds;
    @API(help="Keep cross-validation model predictions", level=API.Level.expert, direction=API.Direction.INOUT)
    public boolean keep_cross_validation_predictions;
    @API(help="Response column", is_member_of_frames={"training_frame", "validation_frame"}, is_mutually_exclusive_with={"ignored_columns"}, direction=API.Direction.INOUT, gridable=true)
    public FrameV3.ColSpecifierV3 response_column;
    @API(help="Column with observation weights", level=API.Level.secondary, is_member_of_frames={"training_frame", "validation_frame"}, is_mutually_exclusive_with={"ignored_columns", "response_column"}, direction=API.Direction.INOUT)
    public FrameV3.ColSpecifierV3 weights_column;
    @API(help="Offset column", level=API.Level.secondary, is_member_of_frames={"training_frame", "validation_frame"}, is_mutually_exclusive_with={"ignored_columns", "response_column", "weights_column"}, direction=API.Direction.INOUT)
    public FrameV3.ColSpecifierV3 offset_column;
    @API(help="Column with cross-validation fold index assignment per observation", level=API.Level.secondary, is_member_of_frames={"training_frame"}, is_mutually_exclusive_with={"ignored_columns", "response_column", "weights_column", "offset_column"}, direction=API.Direction.INOUT)
    public FrameV3.ColSpecifierV3 fold_column;
    @API(help="Cross-validation fold assignment scheme, if fold_column is not specified", values={"AUTO", "Random", "Modulo", "Stratified"}, level=API.Level.secondary, direction=API.Direction.INOUT)
    public Model.Parameters.FoldAssignmentScheme fold_assignment;
    @API(help="Ignored columns", is_member_of_frames={"training_frame", "validation_frame"}, direction=API.Direction.INOUT)
    public String[] ignored_columns;
    @API(help="Ignore constant columns", direction=API.Direction.INOUT)
    public boolean ignore_const_cols;
    @API(help="Whether to score during each iteration of model training", direction=API.Direction.INOUT, level=API.Level.secondary)
    public boolean score_each_iteration;
    @API(help="Model checkpoint to resume training with", level=API.Level.secondary, direction=API.Direction.INOUT)
    public KeyV3.ModelKeyV3 checkpoint;
    @API(help="Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable)", level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
    public int stopping_rounds;
    @API(help="Metric to use for early stopping (AUTO: logloss for classification, deviance for regression)", values={"AUTO", "deviance", "logloss", "MSE", "AUC", "r2", "misclassification"}, level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
    public ScoreKeeper.StoppingMetric stopping_metric;
    @API(help="Relative tolerance for metric-based stopping criterion Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much)", level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
    public double stopping_tolerance;

    public String[] fields() {
        Class<?> this_clz = this.getClass();
        try {
            return (String[])this_clz.getField("fields").get(this_clz);
        }
        catch (Exception e) {
            throw H2O.fail("Caught exception from accessing the schema field list for: " + this);
        }
    }

    protected static String[] append_field_arrays(String[] first, String[] second) {
        String[] appended = new String[first.length + second.length];
        System.arraycopy(first, 0, appended, 0, first.length);
        System.arraycopy(second, 0, appended, first.length, second.length);
        return appended;
    }

    @Override
    public S fillFromImpl(P impl) {
        Value v;
        PojoUtils.copyProperties(this, impl, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES);
        if (null != ((Model.Parameters)impl)._train && null != (v = DKV.get(((Model.Parameters)impl)._train))) {
            this.training_frame = new KeyV3.FrameKeyV3((Key<Frame>)((Frame)v.get())._key);
        }
        if (null != ((Model.Parameters)impl)._valid && null != (v = DKV.get(((Model.Parameters)impl)._valid))) {
            this.validation_frame = new KeyV3.FrameKeyV3((Key<Frame>)((Frame)v.get())._key);
        }
        return (S)this;
    }

    @Override
    public P fillImpl(P impl) {
        super.fillImpl(impl);
        ((Model.Parameters)impl)._train = null == this.training_frame ? null : Key.make(this.training_frame.name);
        ((Model.Parameters)impl)._valid = null == this.validation_frame ? null : Key.make(this.validation_frame.name);
        return impl;
    }

    private static void compute_transitive_closure_of_is_mutually_exclusive(ModelParameterSchemaV3[] metadata) {
        Collection<String> me;
        String name;
        ModelParameterSchemaV3 param;
        int i;
        HashMap field_exclusivity_groups = new HashMap();
        for (i = 0; i < metadata.length; ++i) {
            param = metadata[i];
            name = param.name;
            me = new ArrayList<String>();
            me.add(name);
            if (null != param.is_mutually_exclusive_with) {
                me.addAll(Arrays.asList(param.is_mutually_exclusive_with));
            }
            HashSet<String> new_set = new HashSet<String>();
            for (String s : me) {
                if (field_exclusivity_groups.containsKey(s)) {
                    new_set.addAll((Collection)field_exclusivity_groups.get(s));
                    continue;
                }
                new_set.add(s);
            }
            for (String s : me) {
                field_exclusivity_groups.put(s, new_set);
            }
        }
        for (i = 0; i < metadata.length; ++i) {
            param = metadata[i];
            name = param.name;
            me = (Set)field_exclusivity_groups.get(name);
            HashSet not_me = new HashSet(me);
            not_me.remove(name);
            param.is_mutually_exclusive_with = not_me.toArray(new String[not_me.size()]);
        }
    }

    public static final AutoBuffer writeParametersJSON(AutoBuffer ab, ModelParametersSchema parameters, ModelParametersSchema default_parameters) {
        String[] fields = parameters.fields();
        Freezable[] metadata = new ModelParameterSchemaV3[fields.length];
        String field_name = null;
        try {
            for (int i = 0; i < fields.length; ++i) {
                field_name = fields[i];
                Field f = parameters.getClass().getField(field_name);
                ModelParameterSchemaV3 schema = new ModelParameterSchemaV3(parameters, default_parameters, f);
                metadata[i] = schema;
            }
        }
        catch (NoSuchFieldException e) {
            throw H2O.fail("Caught exception accessing field: " + field_name + " for schema object: " + parameters + ": " + e.toString());
        }
        ModelParametersSchema.compute_transitive_closure_of_is_mutually_exclusive((ModelParameterSchemaV3[])metadata);
        ab.putJSONA("parameters", metadata);
        return ab;
    }
}

