/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import hex.ModelBuilder;
import water.AutoBuffer;
import water.Freezable;
import water.H2O;
import water.Key;
import water.Keyed;
import water.api.API;
import water.api.KeyV3;
import water.api.ModelOutputSchema;
import water.api.ModelParametersSchema;
import water.api.ModelSchemaBase;
import water.api.Schema;
import water.exceptions.H2OIllegalArgumentException;
import water.util.PojoUtils;

public class ModelSchema<M extends Model<M, P, O>, S extends ModelSchema<M, S, P, PS, O, OS>, P extends Model.Parameters, PS extends ModelParametersSchema<P, PS>, O extends Model.Output, OS extends ModelOutputSchema<O, OS>>
extends ModelSchemaBase<M, S> {
    @API(help="The build parameters for the model (e.g. K for KMeans).", direction=API.Direction.OUTPUT)
    public PS parameters;
    @API(help="The build output for the model (e.g. the cluster centers for KMeans).", direction=API.Direction.OUTPUT)
    public OS output;
    @API(help="Compatible frames, if requested", direction=API.Direction.OUTPUT)
    String[] compatible_frames;
    @API(help="Checksum for all the things that go into building the Model.", direction=API.Direction.OUTPUT)
    protected long checksum;

    public ModelSchema() {
    }

    public ModelSchema(M m) {
        this();
        PojoUtils.copyProperties(this.parameters, ((Model)m)._parms, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES);
        PojoUtils.copyProperties(this.output, ((Model)m)._output, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES);
    }

    public PS createParametersSchema() {
        throw H2O.fail("createParametersSchema() must be implemented in class: " + this.getClass());
    }

    public OS createOutputSchema() {
        throw H2O.fail("createOutputSchema() must be implemented in class: " + this.getClass());
    }

    @Override
    public S fillFromImpl(M m) {
        this.algo = ModelBuilder.getAlgo(m);
        this.algo_full_name = ModelBuilder.getAlgoFullName(this.algo);
        this.model_id = new KeyV3.ModelKeyV3((Key<? extends Model>)((Model)m)._key);
        this.checksum = ((Keyed)m).checksum();
        this.parameters = this.createParametersSchema();
        ((ModelParametersSchema)this.parameters).fillFromImpl(((Model)m)._parms);
        this.output = this.createOutputSchema();
        ((ModelOutputSchema)this.output).fillFromImpl(((Model)m)._output);
        return (S)this;
    }

    @Override
    public AutoBuffer writeJSON_impl(AutoBuffer ab) {
        ab.put1(44);
        ab.putJSONStr("algo", this.algo);
        ab.put1(44);
        ab.putJSONStr("algo_full_name", this.algo_full_name);
        ab.put1(44);
        ab.putJSON("model_id", this.model_id);
        ab.put1(44);
        try {
            Object defaults = ((ModelParametersSchema)this.createParametersSchema()).fillFromImpl((Model.Parameters)((Model.Parameters)((Schema)this.parameters).getImplClass().newInstance()));
            ModelParametersSchema.writeParametersJSON(ab, this.parameters, defaults);
            ab.put1(44);
        }
        catch (Exception e) {
            String msg = "Error creating an instance of ModelParameters for algo: " + this.algo;
            String dev_msg = "Error creating an instance of ModelParameters for algo: " + this.algo + ": " + this.getImplClass();
            throw new H2OIllegalArgumentException(msg, dev_msg);
        }
        if (null == this.output) {
            this.output = this.createOutputSchema();
        }
        ab.putJSON("output", (Freezable)this.output);
        ab.put1(44);
        ab.putJSONAStr("compatible_frames", this.compatible_frames);
        return ab;
    }
}

