/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import water.DKV;
import water.Futures;
import water.Iced;
import water.Key;
import water.KeySnapshot;
import water.Value;
import water.api.FrameV3;
import water.api.FramesHandler;
import water.api.Handler;
import water.api.ModelExportV3;
import water.api.ModelImportV3;
import water.api.ModelSchema;
import water.api.ModelsBase;
import water.api.ModelsV3;
import water.api.Schema;
import water.api.StreamingSchema;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2OKeyWrongTypeArgumentException;
import water.exceptions.H2OKeysNotFoundArgumentException;
import water.fvec.Frame;
import water.serial.ObjectTreeBinarySerializer;
import water.util.FileUtils;
import water.util.JCodeGen;

class ModelsHandler<I extends Models, S extends ModelsBase<I, S>>
extends Handler {
    ModelsHandler() {
    }

    public ModelsV3 list(int version, ModelsV3 s) {
        Models m = (Models)s.createAndFillImpl();
        m.models = Models.fetchAll();
        return (ModelsV3)s.fillFromImplWithSynopsis(m);
    }

    public static Model getFromDKV(String param_name, String key_str) {
        return ModelsHandler.getFromDKV(param_name, Key.make(key_str));
    }

    public static Model getFromDKV(String param_name, Key key) {
        if (null == key) {
            throw new H2OIllegalArgumentException(param_name, "Models.getFromDKV()", key);
        }
        Value v = DKV.get(key);
        if (null == v) {
            throw new H2OKeyNotFoundArgumentException(param_name, key.toString());
        }
        Object ice = v.get();
        if (!(ice instanceof Model)) {
            throw new H2OKeyWrongTypeArgumentException(param_name, key.toString(), Model.class, ice.getClass());
        }
        return (Model)ice;
    }

    public StreamingSchema fetchPreview(int version, ModelsV3 s) {
        s.preview = true;
        return this.fetchJavaCode(version, s);
    }

    public ModelsV3 fetch(int version, ModelsV3 s) {
        Model model = ModelsHandler.getFromDKV("key", s.model_id.key());
        s.models = new ModelSchema[1];
        s.models[0] = (ModelSchema)Schema.schema(version, model).fillFromImpl(model);
        if (s.find_compatible_frames) {
            Models m = new Models();
            m.models = new Model[1];
            m.models[0] = model;
            m.find_compatible_frames = true;
            Frame[] compatible = Models.findCompatibleFrames(model, FramesHandler.Frames.fetchAll(), m.fetchFrameCols());
            s.compatible_frames = new FrameV3[compatible.length];
            ((ModelSchema)s.models[0]).compatible_frames = new String[compatible.length];
            int i = 0;
            for (Frame f : compatible) {
                s.compatible_frames[i] = new FrameV3(f).fillFromImpl(f);
                ((ModelSchema)s.models[0]).compatible_frames[i] = f._key.toString();
                ++i;
            }
        }
        return s;
    }

    public StreamingSchema fetchJavaCode(int version, ModelsV3 s) {
        Model model = ModelsHandler.getFromDKV("key", s.model_id.key());
        String filename = JCodeGen.toJavaId(s.model_id.key().toString()) + ".java";
        Model model2 = model;
        model2.getClass();
        return new StreamingSchema(model2.new Model.JavaModelStreamWriter(s.preview), filename);
    }

    public ModelsV3 delete(int version, ModelsV3 s) {
        Model model = ModelsHandler.getFromDKV("key", s.model_id.key());
        model.delete();
        return s;
    }

    public ModelsV3 deleteAll(int version, ModelsV3 models) {
        Key[] keys = KeySnapshot.globalKeysOfClass(Model.class);
        ArrayList<String> missing = new ArrayList<String>();
        Futures fs = new Futures();
        for (int i = 0; i < keys.length; ++i) {
            try {
                ModelsHandler.getFromDKV("(none)", keys[i]).delete(null, fs);
                continue;
            }
            catch (IllegalArgumentException iae) {
                missing.add(keys[i].toString());
            }
        }
        fs.blockForPending();
        if (missing.size() != 0) {
            throw new H2OKeysNotFoundArgumentException("(none)", missing.toArray(new String[missing.size()]));
        }
        return models;
    }

    public ModelsV3 importModel(int version, ModelImportV3 mimport) {
        ModelsV3 s = Schema.newInstance(ModelsV3.class);
        try {
            List<Key> importedKeys = new ObjectTreeBinarySerializer().load(FileUtils.getURI(mimport.dir));
            Model model = (Model)importedKeys.get(0).get();
            s.models = new ModelSchema[1];
            s.models[0] = (ModelSchema)Schema.schema(version, model).fillFromImpl(model);
        }
        catch (IOException e) {
            throw new H2OIllegalArgumentException("dir", "importModel", e);
        }
        return s;
    }

    public ModelExportV3 exportModel(int version, ModelExportV3 mexport) {
        Model model = ModelsHandler.getFromDKV("model_id", mexport.model_id.key());
        LinkedList<Key> keysToExport = new LinkedList<Key>();
        keysToExport.add(model._key);
        keysToExport.addAll(model.getPublishedKeys());
        try {
            URI targetUri = FileUtils.getURI(mexport.dir);
            new ObjectTreeBinarySerializer(mexport.force).save((List<Key>)keysToExport, targetUri);
            mexport.dir = "file".equals(targetUri.getScheme()) ? new File(targetUri).getCanonicalPath() : targetUri.toString();
        }
        catch (IOException e) {
            throw new H2OIllegalArgumentException("dir", "exportModel", e);
        }
        return mexport;
    }

    protected static final class Models
    extends Iced {
        public Key model_id;
        public Model[] models;
        public boolean find_compatible_frames = false;

        protected Models() {
        }

        public static Model[] fetchAll() {
            Key[] modelKeys = KeySnapshot.globalSnapshot().filter(new KeySnapshot.KVFilter(){

                @Override
                public boolean filter(KeySnapshot.KeyInfo k) {
                    return Value.isSubclassOf(k._type, Model.class);
                }
            }).keys();
            Model[] models = new Model[modelKeys.length];
            for (int i = 0; i < modelKeys.length; ++i) {
                Model model;
                models[i] = model = ModelsHandler.getFromDKV("(none)", modelKeys[i]);
            }
            return models;
        }

        protected Map<Frame, Set<String>> fetchFrameCols() {
            Frame[] all_frames = null;
            HashMap<Frame, HashSet<String>> all_frames_cols = null;
            if (this.find_compatible_frames) {
                all_frames = FramesHandler.Frames.fetchAll();
                all_frames_cols = new HashMap<Frame, HashSet<String>>();
                for (Frame f : all_frames) {
                    all_frames_cols.put(f, new HashSet<String>(Arrays.asList(f._names)));
                }
            }
            return all_frames_cols;
        }

        private static Frame[] findCompatibleFrames(Model model, Frame[] all_frames, Map<Frame, Set<String>> all_frames_cols) {
            ArrayList<Frame> compatible_frames = new ArrayList<Frame>();
            HashSet<String> model_column_names = new HashSet<String>(Arrays.asList(((Model.Output)model._output)._names));
            for (Map.Entry<Frame, Set<String>> entry : all_frames_cols.entrySet()) {
                Frame frame = entry.getKey();
                Set<String> frame_cols = entry.getValue();
                if (!frame_cols.containsAll(model_column_names)) continue;
                try {
                    if (model.adaptTestForTrain(new Frame(frame), false, false).length != 0) continue;
                    compatible_frames.add(frame);
                }
                catch (IllegalArgumentException e) {}
            }
            return compatible_frames.toArray(new Frame[0]);
        }
    }
}

