/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import water.H2O;
import water.api.Handler;
import water.api.InitIDHandler;
import water.api.RapidsFrameV3;
import water.api.RapidsFunctionV3;
import water.api.RapidsNumberV3;
import water.api.RapidsNumbersV3;
import water.api.RapidsSchema;
import water.api.RapidsStringV3;
import water.api.RapidsStringsV3;
import water.rapids.Exec;
import water.rapids.Session;
import water.rapids.Val;
import water.util.Log;

class RapidsHandler
extends Handler {
    RapidsHandler() {
    }

    public RapidsSchema exec(int version, RapidsSchema rapids) {
        Val val;
        if (rapids == null) {
            return null;
        }
        if (rapids.ast == null || rapids.ast.equals("")) {
            return rapids;
        }
        Session ses = InitIDHandler.SESSION;
        if (ses == null) {
            InitIDHandler.SESSION = ses = new Session();
        }
        try {
            val = Exec.exec(rapids.ast, ses);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable e) {
            Log.err(e);
            throw e;
        }
        switch (val.type()) {
            case 1: {
                return new RapidsNumberV3(val.getNum());
            }
            case 2: {
                return new RapidsNumbersV3(val.getNums());
            }
            case 3: {
                return new RapidsStringV3(val.getStr());
            }
            case 4: {
                return new RapidsStringsV3(val.getStrs());
            }
            case 5: {
                return new RapidsFrameV3(val.getFrame());
            }
            case 7: {
                return new RapidsFunctionV3(val.getFun().toString());
            }
        }
        throw H2O.fail();
    }
}

