/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import water.H2O;
import water.Job;
import water.Key;
import water.Value;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.C1NChunk;
import water.fvec.Vec;

public class ByteVec
extends Vec {
    static final byte CHAR_CR = 13;
    static final byte CHAR_LF = 10;

    public ByteVec(Key key, int rowLayout) {
        super(key, rowLayout);
    }

    @Override
    public C1NChunk chunkForChunkIdx(int cidx) {
        return (C1NChunk)super.chunkForChunkIdx(cidx);
    }

    @Override
    public long naCnt() {
        return 0L;
    }

    @Override
    public boolean isInt() {
        return true;
    }

    public byte[] getFirstBytes() {
        return this.chunkForChunkIdx((int)0)._mem;
    }

    public byte[] getPreviewChunkBytes(int chkIdx) {
        int i;
        if (chkIdx >= this.nChunks()) {
            throw new H2OIllegalArgumentException("Asked for chunk index beyond the number of chunks.");
        }
        if (chkIdx == 0) {
            return this.chunkForChunkIdx((int)chkIdx)._mem;
        }
        byte[] mem = this.chunkForChunkIdx((int)chkIdx)._mem;
        int j = mem.length - 1;
        for (i = 0; i < mem.length && mem[i] != 13 && mem[i] != 10; ++i) {
        }
        while (j > i && mem[j] != 13 && mem[j] != 10) {
            --j;
        }
        if (j - i > 1) {
            return Arrays.copyOfRange(mem, i, j);
        }
        return null;
    }

    public InputStream openStream(final Key job_key) {
        return new InputStream(){
            final long[] sz = new long[1];
            private int _cidx;
            private int _pidx;
            private int _sz;
            private C1NChunk _c0;

            @Override
            public int available() {
                if (this._c0 == null || this._sz >= this._c0._len) {
                    this.sz[0] = this.sz[0] + (this._c0 != null ? (long)this._c0._len : 0L);
                    if (this._cidx >= ByteVec.this.nChunks()) {
                        return 0;
                    }
                    this._c0 = ByteVec.this.chunkForChunkIdx(this._cidx++);
                    this._sz = 0;
                    if (job_key != null) {
                        Job.update(this._c0._len, job_key);
                    }
                }
                return this._c0._len - this._sz;
            }

            @Override
            public void close() {
                this._cidx = ByteVec.this.nChunks();
                this._c0 = null;
                this._sz = 0;
            }

            @Override
            public int read() throws IOException {
                return this.available() == 0 ? -1 : 0xFF & this._c0._mem[this._sz++];
            }

            @Override
            public int read(byte[] b, int off, int len) {
                if (b == null) {
                    Value v;
                    if (this._cidx > this._pidx && (v = H2O.get(ByteVec.this.chunkKey(this._pidx++))) != null && v.isPersisted()) {
                        v.freePOJO();
                        v.freeMem();
                    }
                    return this._cidx;
                }
                int sz = this.available();
                if (sz == 0) {
                    return -1;
                }
                len = Math.min(len, sz);
                System.arraycopy(this._c0._mem, this._sz, b, off, len);
                this._sz += len;
                return len;
            }
        };
    }
}

