/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.AutoBuffer;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class C0DChunk
extends Chunk {
    private static final int _OFF = 12;
    private double _con;

    public C0DChunk(double con, int len) {
        this._start = -1L;
        this.set_len(len);
        this._mem = new byte[12];
        this._con = con;
        UnsafeUtils.set8d(this._mem, 0, con);
        UnsafeUtils.set4(this._mem, 8, len);
    }

    @Override
    public boolean hasFloat() {
        return true;
    }

    @Override
    protected final long at8_impl(int i) {
        if (Double.isNaN(this._con)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)this._con;
    }

    @Override
    protected final double atd_impl(int i) {
        return this._con;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return Double.isNaN(this._con);
    }

    @Override
    boolean set_impl(int idx, long l) {
        return (double)l == this._con;
    }

    @Override
    boolean set_impl(int i, double d) {
        return d == this._con;
    }

    @Override
    boolean set_impl(int i, float f) {
        return (double)f == this._con;
    }

    @Override
    boolean setNA_impl(int i) {
        return Double.isNaN(this._con);
    }

    @Override
    double min() {
        return this._con;
    }

    @Override
    double max() {
        return this._con;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.set_sparseLen(nc.set_len(0));
        if (this._con == 0.0) {
            nc.addZeros(this._len);
        } else {
            for (int i = 0; i < this._len; ++i) {
                nc.addNum(this._con);
            }
        }
        return nc;
    }

    @Override
    public final C0DChunk read_impl(AutoBuffer ab) {
        this._mem = ab.bufClose();
        this._start = -1L;
        this._cidx = -1;
        this._con = UnsafeUtils.get8d(this._mem, 0);
        this.set_len(UnsafeUtils.get4(this._mem, 8));
        return this;
    }

    @Override
    public int nextNZ(int rid) {
        return this._con == 0.0 ? this._len : rid + 1;
    }

    @Override
    public boolean isSparse() {
        return this._con == 0.0;
    }
}

