/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import water.AutoBuffer;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class C0LChunk
extends Chunk {
    protected static final int _OFF = 12;
    private long _con;

    public C0LChunk(long con, int len) {
        this._mem = new byte[12];
        this._start = -1L;
        this.set_len(len);
        this._con = con;
        UnsafeUtils.set8(this._mem, 0, con);
        UnsafeUtils.set4(this._mem, 8, len);
    }

    @Override
    public boolean hasFloat() {
        return false;
    }

    @Override
    public boolean hasNA() {
        return false;
    }

    @Override
    protected final long at8_impl(int i) {
        return this._con;
    }

    @Override
    protected final double atd_impl(int i) {
        return this._con;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return false;
    }

    @Override
    boolean set_impl(int idx, long l) {
        return l == this._con;
    }

    @Override
    boolean set_impl(int i, double d) {
        return d == (double)this._con;
    }

    @Override
    boolean set_impl(int i, float f) {
        return f == (float)this._con;
    }

    @Override
    boolean setNA_impl(int i) {
        return false;
    }

    @Override
    boolean set_impl(int idx, String str) {
        return false;
    }

    @Override
    double min() {
        return this._con;
    }

    @Override
    double max() {
        return this._con;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        if (this._con != 0L) {
            nc.alloc_mantissa(this._len);
            Arrays.fill(nc.mantissa(), this._con);
            nc.alloc_exponent(this._len);
            nc.set_len(nc.set_sparseLen(this._len));
        } else {
            nc.set_len(nc.set_sparseLen(0));
            nc.set_sparse(0);
            nc.addZeros(this._len);
            assert (nc.sparseLen() == 0);
        }
        return nc;
    }

    @Override
    public int sparseLen() {
        return this._con == 0L ? 0 : this._len;
    }

    @Override
    public C0LChunk read_impl(AutoBuffer bb) {
        this._mem = bb.bufClose();
        this._start = -1L;
        this._cidx = -1;
        this._con = UnsafeUtils.get8(this._mem, 0);
        this.set_len(UnsafeUtils.get4(this._mem, 8));
        return this;
    }

    @Override
    public int nextNZ(int rid) {
        return this._con == 0L ? this._len : rid + 1;
    }

    @Override
    public boolean isSparse() {
        return this._con == 0L;
    }
}

