/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.AutoBuffer;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.PrettyPrint;
import water.util.UnsafeUtils;

public class C1SChunk
extends Chunk {
    protected static final int _OFF = 16;
    private double _scale;
    private long _bias;

    public double scale() {
        return this._scale;
    }

    @Override
    public boolean hasFloat() {
        return this._scale != (double)((long)this._scale);
    }

    C1SChunk(byte[] bs, long bias, double scale) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length - 16);
        this._bias = bias;
        this._scale = scale;
        UnsafeUtils.set8d(this._mem, 0, scale);
        UnsafeUtils.set8(this._mem, 8, bias);
    }

    @Override
    protected final long at8_impl(int i) {
        long res = 0xFF & this._mem[i + 16];
        if (res == 255L) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)((double)(res + this._bias) * this._scale);
    }

    @Override
    protected final double atd_impl(int i) {
        long res = 0xFF & this._mem[i + 16];
        return res == 255L ? Double.NaN : (double)(res + this._bias) * this._scale;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return (long)(0xFF & this._mem[i + 16]) == 255L;
    }

    @Override
    boolean set_impl(int i, long l) {
        long res = (long)((double)l / this._scale) - this._bias;
        double d = (double)(res + this._bias) * this._scale;
        if ((long)d != l) {
            return false;
        }
        if (0L > res || res >= 255L) {
            return false;
        }
        this._mem[i + 16] = (byte)res;
        return true;
    }

    @Override
    boolean set_impl(int i, double d) {
        return false;
    }

    @Override
    boolean set_impl(int i, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        this._mem[idx + 16] = -1;
        return true;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        double dx = Math.log10(this._scale);
        assert (PrettyPrint.fitsIntoInt(dx));
        nc.set_sparseLen(0);
        nc.set_len(0);
        int len = this._len;
        for (int i = 0; i < len; ++i) {
            int res = 0xFF & this._mem[i + 16];
            if ((long)res == 255L) {
                nc.addNA();
                continue;
            }
            nc.addNum((long)res + this._bias, (int)dx);
        }
        return nc;
    }

    @Override
    public byte precision() {
        return (byte)Math.max(-Math.log10(this._scale), 0.0);
    }

    @Override
    public C1SChunk read_impl(AutoBuffer bb) {
        this._mem = bb.bufClose();
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length - 16);
        this._scale = UnsafeUtils.get8d(this._mem, 0);
        this._bias = UnsafeUtils.get8(this._mem, 8);
        return this;
    }
}

