/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.AutoBuffer;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class C4Chunk
extends Chunk {
    protected static final long _NA = Integer.MIN_VALUE;

    C4Chunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 2);
    }

    @Override
    protected final long at8_impl(int i) {
        long res = UnsafeUtils.get4(this._mem, i << 2);
        if (res == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return res;
    }

    @Override
    protected final double atd_impl(int i) {
        long res = UnsafeUtils.get4(this._mem, i << 2);
        return res == Integer.MIN_VALUE ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return (long)UnsafeUtils.get4(this._mem, i << 2) == Integer.MIN_VALUE;
    }

    @Override
    boolean set_impl(int idx, long l) {
        if (Integer.MIN_VALUE >= l || l > Integer.MAX_VALUE) {
            return false;
        }
        UnsafeUtils.set4(this._mem, idx << 2, (int)l);
        return true;
    }

    @Override
    boolean set_impl(int i, double d) {
        return false;
    }

    @Override
    boolean set_impl(int i, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set4(this._mem, idx << 2, Integer.MIN_VALUE);
        return true;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.set_sparseLen(0);
        nc.set_len(0);
        int len = this._len;
        for (int i = 0; i < len; ++i) {
            int res = UnsafeUtils.get4(this._mem, i << 2);
            if ((long)res == Integer.MIN_VALUE) {
                nc.addNA();
                continue;
            }
            nc.addNum(res, 0);
        }
        return nc;
    }

    @Override
    public C4Chunk read_impl(AutoBuffer bb) {
        this._mem = bb.bufClose();
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 2);
        assert (this._mem.length == this._len << 2);
        return this;
    }

    @Override
    public boolean hasFloat() {
        return false;
    }
}

