/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.MRTask;
import water.Value;
import water.fvec.AppendableVec;
import water.fvec.C16Chunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class Frame
extends Lockable<Frame> {
    public String[] _names;
    private boolean _lastNameBig;
    private Key<Vec>[] _keys;
    private transient Vec[] _vecs;
    private transient Vec _col0;
    static final int MAX_EQ2_COLS = 100000;

    public Frame(Vec ... vecs) {
        this((String[])null, vecs);
    }

    public Frame(String[] names, Vec[] vecs) {
        this(null, names, vecs);
    }

    public Frame(Key key) {
        this(key, null, new Vec[0]);
    }

    public Frame(Key key, Vec[] vecs, boolean noChecks) {
        super(key);
        assert (noChecks);
        this._vecs = vecs;
        this._names = new String[vecs.length];
        this._keys = new Key[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            this._names[i] = Frame.defaultColName(i);
            this._keys[i] = vecs[i]._key;
        }
    }

    public Frame(Key key, String[] names, Vec[] vecs) {
        super(key);
        for (Vec vec : vecs) {
            DKV.prefetch(vec._key);
        }
        for (Vec vec : vecs) {
            assert (DKV.get(vec._key) != null) : " null vec: " + vec._key;
        }
        if (names == null) {
            int i;
            this._names = new String[vecs.length];
            this._keys = new Key[vecs.length];
            this._vecs = vecs;
            for (i = 0; i < vecs.length; ++i) {
                this._names[i] = Frame.defaultColName(i);
            }
            for (i = 0; i < vecs.length; ++i) {
                this._keys[i] = vecs[i]._key;
            }
            for (i = 0; i < vecs.length; ++i) {
                this.checkCompatible(this._names[i], vecs[i]);
            }
            this._lastNameBig = true;
        } else {
            this._names = new String[0];
            this._keys = new Key[0];
            this._vecs = new Vec[0];
            this.add(names, vecs);
        }
        assert (this._names.length == vecs.length);
    }

    public Frame(Frame fr) {
        super(Key.make());
        this._names = (String[])fr._names.clone();
        this._keys = (Key[])fr._keys.clone();
        this._vecs = (Vec[])fr.vecs().clone();
        this._lastNameBig = fr._lastNameBig;
    }

    public static String defaultColName(int col) {
        return "C" + (1 + col);
    }

    private int pint(String name) {
        try {
            return Integer.valueOf(name.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String uniquify(String name) {
        int again;
        String last;
        String n = name;
        int lastName = 0;
        if (name.length() > 0 && name.charAt(0) == 'C') {
            lastName = this.pint(name);
        }
        if (this._lastNameBig && this._names.length > 0 && !(last = this._names[this._names.length - 1]).equals("") && last.charAt(0) == 'C' && lastName == this.pint(last) + 1) {
            return name;
        }
        int cnt = 0;
        int max = 0;
        do {
            again = cnt;
            for (String s : this._names) {
                if (lastName > 0 && s.charAt(0) == 'C') {
                    max = Math.max(max, this.pint(s));
                }
                if (!n.equals(s)) continue;
                n = name + cnt++;
            }
        } while (again != cnt);
        if (lastName == max + 1) {
            this._lastNameBig = true;
        }
        return n;
    }

    private void checkCompatible(String name, Vec vec) {
        if (vec instanceof AppendableVec) {
            return;
        }
        Vec v0 = this.anyVec();
        if (v0 == null) {
            return;
        }
        if (!v0.checkCompatible(vec)) {
            if (!Vec.VectorGroup.sameGroup(v0, vec)) {
                Log.err("Unexpected incompatible vector group, " + v0.group() + " != " + vec.group());
            }
            if (!Arrays.equals(v0.espc(), vec.espc())) {
                Log.err("Unexpected incompatible espc, " + Arrays.toString(v0.espc()) + " != " + Arrays.toString(vec.espc()));
            }
            throw new IllegalArgumentException("Vec " + name + " is not compatible with the rest of the frame");
        }
    }

    public boolean isCompatible(Frame fr) {
        if (this.numCols() != fr.numCols()) {
            return false;
        }
        if (this.numRows() != fr.numRows()) {
            return false;
        }
        for (int i = 0; i < this.vecs().length; ++i) {
            if (this.vecs()[i].checkCompatible(fr.vecs()[i])) continue;
            return false;
        }
        return true;
    }

    public int numCols() {
        return this._keys.length;
    }

    public int numColsExp() {
        return this.numColsExp(true, false);
    }

    public int numColsExp(boolean useAllFactorLevels, boolean missingBucket) {
        if (this._vecs == null) {
            return 0;
        }
        int cols = 0;
        for (int i = 0; i < this._vecs.length; ++i) {
            if (this._vecs[i].isCategorical() && this._vecs[i].domain() != null) {
                cols += this._vecs[i].domain().length - (useAllFactorLevels ? 0 : 1) + (missingBucket ? 1 : 0);
                continue;
            }
            ++cols;
        }
        return cols;
    }

    public long numRows() {
        Vec v = this.anyVec();
        return v == null ? 0L : v.length();
    }

    public long degreesOfFreedom() {
        long dofs = 0L;
        String[][] dom = this.domains();
        for (int i = 0; i < this.numCols(); ++i) {
            if (dom[i] == null) {
                ++dofs;
                continue;
            }
            dofs += (long)dom[i].length;
        }
        return dofs;
    }

    public final Vec anyVec() {
        Vec c0 = this._col0;
        if (c0 != null) {
            return c0;
        }
        for (Vec v : this.vecs()) {
            if (!v.readable()) continue;
            this._col0 = v;
            return this._col0;
        }
        return null;
    }

    public String[] names() {
        return this._names;
    }

    public String name(int i) {
        return this._names[i];
    }

    public Key[] keys() {
        return this._keys;
    }

    public final Vec[] vecs() {
        Vec[] vecArray;
        Vec[] tvecs = this._vecs;
        if (tvecs == null) {
            this._vecs = this.vecs_impl();
            vecArray = this._vecs;
        } else {
            vecArray = tvecs;
        }
        return vecArray;
    }

    public final Vec[] vecs(int[] idxs) {
        Vec[] all = this.vecs();
        Vec[] res = new Vec[idxs.length];
        for (int i = 0; i < idxs.length; ++i) {
            res[i] = all[idxs[i]];
        }
        return res;
    }

    public Vec[] vecs(String[] names) {
        Vec[] res = new Vec[names.length];
        for (int i = 0; i < names.length; ++i) {
            res[i] = this.vec(names[i]);
        }
        return res;
    }

    private Vec[] vecs_impl() {
        for (Key<Vec> key : this._keys) {
            DKV.prefetch(key);
        }
        Vec[] vecs = new Vec[this._keys.length];
        for (int i = 0; i < this._keys.length; ++i) {
            vecs[i] = this._keys[i].get();
        }
        return vecs;
    }

    public Vec lastVec() {
        this.vecs();
        return this._vecs[this._vecs.length - 1];
    }

    public String lastVecName() {
        return this._names[this._names.length - 1];
    }

    public final Vec[] reloadVecs() {
        this._vecs = null;
        return this.vecs();
    }

    public final Vec vec(int idx) {
        return this.vecs()[idx];
    }

    public Vec vec(String name) {
        int idx = this.find(name);
        return idx == -1 ? null : this.vecs()[idx];
    }

    public int find(String name) {
        if (name == null) {
            return -1;
        }
        assert (this._names != null);
        for (int i = 0; i < this._names.length; ++i) {
            if (!name.equals(this._names[i])) continue;
            return i;
        }
        return -1;
    }

    public int find(Vec vec) {
        Vec[] vecs = this.vecs();
        if (vec == null) {
            return -1;
        }
        for (int i = 0; i < vecs.length; ++i) {
            if (!vec.equals(vecs[i])) continue;
            return i;
        }
        return -1;
    }

    public int find(Key key) {
        for (int i = 0; i < this._keys.length; ++i) {
            if (!key.equals(this._keys[i])) continue;
            return i;
        }
        return -1;
    }

    public int[] find(String[] names) {
        if (names == null) {
            return null;
        }
        int[] res = new int[names.length];
        for (int i = 0; i < names.length; ++i) {
            res[i] = this.find(names[i]);
        }
        return res;
    }

    public void insertVec(int i, String name, Vec vec) {
        String[] names = new String[this._names.length + 1];
        Vec[] vecs = new Vec[this._vecs.length + 1];
        Key[] keys = new Key[this._keys.length + 1];
        System.arraycopy(this._names, 0, names, 0, i);
        System.arraycopy(this._vecs, 0, vecs, 0, i);
        System.arraycopy(this._keys, 0, keys, 0, i);
        names[i] = name;
        vecs[i] = vec;
        keys[i] = vec._key;
        System.arraycopy(this._names, i, names, i + 1, this._names.length - i);
        System.arraycopy(this._vecs, i, vecs, i + 1, this._vecs.length - i);
        System.arraycopy(this._keys, i, keys, i + 1, this._keys.length - i);
        this._names = names;
        this._vecs = vecs;
        this._keys = keys;
    }

    public byte[] types() {
        Vec[] vecs = this.vecs();
        byte[] bs = new byte[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            bs[i] = vecs[i]._type;
        }
        return bs;
    }

    public String[] typesStr() {
        Vec[] vecs = this.vecs();
        String[] s = new String[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            s[i] = vecs[i].get_type_str();
        }
        return s;
    }

    public String[][] domains() {
        Vec[] vecs = this.vecs();
        String[][] ds = new String[vecs.length][];
        for (int i = 0; i < vecs.length; ++i) {
            ds[i] = vecs[i].domain();
        }
        return ds;
    }

    public int[] cardinality() {
        Vec[] vecs = this.vecs();
        int[] card = new int[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            card[i] = vecs[i].cardinality();
        }
        return card;
    }

    private Vec[] bulkRollups() {
        Vec[] vecs;
        Futures fs = new Futures();
        for (Vec v : vecs = this.vecs()) {
            v.startRollupStats(fs);
        }
        fs.blockForPending();
        return vecs;
    }

    public int[] modes() {
        Vec[] vecs = this.bulkRollups();
        int[] modes = new int[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            modes[i] = vecs[i].isCategorical() ? vecs[i].mode() : -1;
        }
        return modes;
    }

    public double[] means() {
        Vec[] vecs = this.bulkRollups();
        double[] means = new double[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            means[i] = vecs[i].mean();
        }
        return means;
    }

    public double[] mults() {
        Vec[] vecs = this.bulkRollups();
        double[] mults = new double[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            double sigma = vecs[i].sigma();
            mults[i] = Frame.standardize(sigma) ? 1.0 / sigma : 1.0;
        }
        return mults;
    }

    private static boolean standardize(double sigma) {
        return sigma > 1.0E-6;
    }

    public long byteSize() {
        Vec[] vecs = this.bulkRollups();
        long sum = 0L;
        for (Vec vec : vecs) {
            sum += vec.byteSize();
        }
        return sum;
    }

    @Override
    protected long checksum_impl() {
        Vec[] vecs = this.vecs();
        long _checksum = 0L;
        for (int i = 0; i < this._names.length; ++i) {
            long vec_checksum = vecs[i].checksum();
            _checksum ^= vec_checksum;
            long tmp = Integer.MAX_VALUE * (long)i;
            _checksum ^= tmp;
        }
        return _checksum *= (long)(47806 + Arrays.hashCode(this._names));
    }

    public void add(String[] names, Vec[] vecs) {
        this.bulkAdd(names, vecs);
    }

    public void add(String[] names, Vec[] vecs, int cols) {
        if (null == vecs || null == names) {
            return;
        }
        if (cols == names.length && cols == vecs.length) {
            this.bulkAdd(names, vecs);
        } else {
            for (int i = 0; i < cols; ++i) {
                this.add(names[i], vecs[i]);
            }
        }
    }

    private void bulkAdd(String[] names, Vec[] vecs) {
        String[] tmpnames = (String[])names.clone();
        int N = names.length;
        assert (names.length == vecs.length) : "names = " + Arrays.toString(names) + ", vecs len = " + vecs.length;
        for (int i = 0; i < N; ++i) {
            vecs[i] = vecs[i] != null ? this.makeCompatible(new Frame(vecs[i])).anyVec() : null;
            tmpnames[i] = this.uniquify(tmpnames[i]);
            this.checkCompatible(tmpnames[i], vecs[i]);
        }
        int ncols = this._keys.length;
        this._names = Arrays.copyOf(this._names, ncols + N);
        this._keys = Arrays.copyOf(this._keys, ncols + N);
        this._vecs = Arrays.copyOf(this._vecs, ncols + N);
        for (int i = 0; i < N; ++i) {
            this._names[ncols + i] = tmpnames[i];
            this._keys[ncols + i] = vecs[i]._key;
            this._vecs[ncols + i] = vecs[i];
        }
    }

    public Vec add(String name, Vec vec) {
        vec = this.makeCompatible(new Frame(vec)).anyVec();
        name = this.uniquify(name);
        this.checkCompatible(name, vec);
        int ncols = this._keys.length;
        this._names = Arrays.copyOf(this._names, ncols + 1);
        this._names[ncols] = name;
        this._keys = Arrays.copyOf(this._keys, ncols + 1);
        this._keys[ncols] = vec._key;
        this._vecs = Arrays.copyOf(this._vecs, ncols + 1);
        this._vecs[ncols] = vec;
        return vec;
    }

    public Frame add(Frame fr) {
        this.add(fr._names, fr.vecs(), fr.numCols());
        return this;
    }

    public Frame prepend(String name, Vec vec) {
        if (this.find(name) != -1) {
            throw new IllegalArgumentException("Duplicate name '" + name + "' in Frame");
        }
        if (this._vecs.length != 0) {
            if (!this.anyVec().group().equals(vec.group()) && !Arrays.equals(this.anyVec().espc(), vec.espc())) {
                throw new IllegalArgumentException("Vector groups differs - adding vec '" + name + "' into the frame " + Arrays.toString(this._names));
            }
            if (this.numRows() != vec.length()) {
                throw new IllegalArgumentException("Vector lengths differ - adding vec '" + name + "' into the frame " + Arrays.toString(this._names));
            }
        }
        int len = this._names != null ? this._names.length : 0;
        String[] _names2 = new String[len + 1];
        Vec[] _vecs2 = new Vec[len + 1];
        Key[] _keys2 = new Key[len + 1];
        _names2[0] = name;
        _vecs2[0] = vec;
        _keys2[0] = vec._key;
        System.arraycopy(this._names, 0, _names2, 1, len);
        System.arraycopy(this._vecs, 0, _vecs2, 1, len);
        System.arraycopy(this._keys, 0, _keys2, 1, len);
        this._names = _names2;
        this._vecs = _vecs2;
        this._keys = _keys2;
        return this;
    }

    public void swap(int lo, int hi) {
        assert (0 <= lo && lo < this._keys.length);
        assert (0 <= hi && hi < this._keys.length);
        if (lo == hi) {
            return;
        }
        Vec[] vecs = this.vecs();
        Vec v = vecs[lo];
        vecs[lo] = vecs[hi];
        vecs[hi] = v;
        Key<Vec> k = this._keys[lo];
        this._keys[lo] = this._keys[hi];
        this._keys[hi] = k;
        String n = this._names[lo];
        this._names[lo] = this._names[hi];
        this._names[hi] = n;
    }

    public Frame subframe(String[] names) {
        return this.subframe(names, false, 0.0)[0];
    }

    public Frame[] subframe(String[] names, double c) {
        return this.subframe(names, true, c);
    }

    private Frame[] subframe(String[] names, boolean replaceBy, double c) {
        int i;
        Vec[] vecs = new Vec[names.length];
        Vec[] cvecs = replaceBy ? new Vec[names.length] : null;
        String[] cnames = replaceBy ? new String[names.length] : null;
        int ccv = 0;
        this.vecs();
        HashMap<String, Integer> map = new HashMap<String, Integer>((int)((float)names.length / 0.75f + 1.0f));
        for (i = 0; i < this._names.length; ++i) {
            map.put(this._names[i], i);
        }
        for (i = 0; i < names.length; ++i) {
            if (map.containsKey(names[i])) {
                vecs[i] = this._vecs[(Integer)map.get(names[i])];
                continue;
            }
            if (!replaceBy) continue;
            Log.warn("Column " + names[i] + " is missing, filling it in with " + c);
            assert (cnames != null);
            cnames[ccv] = names[i];
            int n = ccv++;
            Vec vec = this.anyVec().makeCon(c);
            cvecs[n] = vec;
            vecs[i] = vec;
        }
        return new Frame[]{new Frame(Key.make("subframe" + Key.make().toString()), names, vecs), ccv > 0 ? new Frame(Key.make("subframe" + Key.make().toString()), Arrays.copyOf(cnames, ccv), Arrays.copyOf(cvecs, ccv)) : null};
    }

    public Futures postWrite(Futures fs) {
        for (Vec v : this.vecs()) {
            v.postWrite(fs);
        }
        return fs;
    }

    @Override
    public Futures remove_impl(Futures fs) {
        final Key[] keys = this._keys;
        if (keys.length == 0) {
            return fs;
        }
        final int ncs = this.anyVec().nChunks();
        this._names = new String[0];
        this._vecs = new Vec[0];
        this._keys = new Key[0];
        new MRTask(){

            @Override
            public void setupLocal() {
                for (Key k : keys) {
                    if (k == null) continue;
                    Vec.bulk_remove(k, ncs);
                }
            }
        }.doAllNodes();
        return fs;
    }

    public Vec replace(int col, Vec nv) {
        Vec rv = this.vecs()[col];
        nv = new Frame(rv).makeCompatible(new Frame(nv)).anyVec();
        DKV.put(nv);
        assert (DKV.get(nv._key) != null);
        assert (rv.group().equals(nv.group()));
        this._vecs[col] = nv;
        this._keys[col] = nv._key;
        return rv;
    }

    public Frame subframe(int startIdx, int endIdx) {
        return new Frame(Arrays.copyOfRange(this._names, startIdx, endIdx), Arrays.copyOfRange(this.vecs(), startIdx, endIdx));
    }

    public Frame extractFrame(int startIdx, int endIdx) {
        Frame f = this.subframe(startIdx, endIdx);
        this.remove(startIdx, endIdx);
        return f;
    }

    public Vec remove(String name) {
        return this.remove(this.find(name));
    }

    public Frame remove(String[] names) {
        for (String name : names) {
            this.remove(this.find(name));
        }
        return this;
    }

    public Vec[] remove(int[] idxs) {
        for (int i : idxs) {
            if (i >= 0 && i < this.vecs().length) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sort(idxs);
        Vec[] res = new Vec[idxs.length];
        Vec[] rem = new Vec[this._vecs.length - idxs.length];
        String[] names = new String[rem.length];
        Key[] keys = new Key[rem.length];
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i = 0; i < this._vecs.length; ++i) {
            if (j < idxs.length && i == idxs[j]) {
                ++j;
                res[k++] = this._vecs[i];
                continue;
            }
            rem[l] = this._vecs[i];
            names[l] = this._names[i];
            keys[l] = this._keys[i];
            ++l;
        }
        this._vecs = rem;
        this._names = names;
        this._keys = keys;
        assert (l == rem.length && k == idxs.length);
        return res;
    }

    public final Vec remove(int idx) {
        int len = this._names.length;
        if (idx < 0 || idx >= len) {
            return null;
        }
        Vec v = this.vecs()[idx];
        System.arraycopy(this._names, idx + 1, this._names, idx, len - idx - 1);
        System.arraycopy(this._vecs, idx + 1, this._vecs, idx, len - idx - 1);
        System.arraycopy(this._keys, idx + 1, this._keys, idx, len - idx - 1);
        this._names = Arrays.copyOf(this._names, len - 1);
        this._vecs = Arrays.copyOf(this._vecs, len - 1);
        this._keys = Arrays.copyOf(this._keys, len - 1);
        if (v == this._col0) {
            this._col0 = null;
        }
        return v;
    }

    Vec[] remove(int startIdx, int endIdx) {
        int len = this._names.length;
        int nlen = len - (endIdx - startIdx);
        String[] names = new String[nlen];
        Key[] keys = new Key[nlen];
        Vec[] vecs = new Vec[nlen];
        this.vecs();
        if (startIdx > 0) {
            System.arraycopy(this._names, 0, names, 0, startIdx);
            System.arraycopy(this._vecs, 0, vecs, 0, startIdx);
            System.arraycopy(this._keys, 0, keys, 0, startIdx);
        }
        nlen -= startIdx;
        if (endIdx < this._names.length + 1) {
            System.arraycopy(this._names, endIdx, names, startIdx, nlen);
            System.arraycopy(this._vecs, endIdx, vecs, startIdx, nlen);
            System.arraycopy(this._keys, endIdx, keys, startIdx, nlen);
        }
        Vec[] vecX = Arrays.copyOfRange(this._vecs, startIdx, endIdx);
        this._names = names;
        this._vecs = vecs;
        this._keys = keys;
        this._col0 = null;
        return vecX;
    }

    public void restructure(String[] names, Vec[] vecs) {
        this.restructure(names, vecs, vecs.length);
    }

    public void restructure(String[] names, Vec[] vecs, int cols) {
        this._names = new String[0];
        this._keys = new Key[0];
        this._vecs = new Vec[0];
        this.add(names, vecs, cols);
    }

    void preparePartialFrame(String[] names) {
        if (this._keys != null) {
            this.delete_and_lock(null);
        } else {
            this.write_lock(null);
        }
        this._names = names;
        this._keys = new Vec.VectorGroup().addVecs(names.length);
    }

    static NewChunk[] createNewChunks(String name, byte[] type, int cidx) {
        Frame fr = (Frame)Key.make(name).get();
        NewChunk[] nchks = new NewChunk[fr.numCols()];
        for (int i = 0; i < nchks.length; ++i) {
            nchks[i] = new NewChunk(new AppendableVec(fr._keys[i], type[i]), cidx);
        }
        return nchks;
    }

    static void closeNewChunks(NewChunk[] nchks) {
        Futures fs = new Futures();
        for (NewChunk nchk : nchks) {
            nchk.close(fs);
        }
        fs.blockForPending();
    }

    void finalizePartialFrame(long[] espc, String[][] domains, byte[] types) {
        int nchunk = espc.length;
        long[] espc2 = new long[nchunk + 1];
        long x = 0L;
        for (int i = 0; i < nchunk; ++i) {
            espc2[i] = x;
            x += espc[i];
        }
        espc2[nchunk] = x;
        Futures fs = new Futures();
        this._vecs = new Vec[this._keys.length];
        for (int i = 0; i < this._keys.length; ++i) {
            Vec vec = this._vecs[i] = new Vec(this._keys[i], Vec.ESPC.rowLayout(this._keys[i], espc2), domains != null ? domains[i] : null, types[i]);
            DKV.put(this._keys[i], vec, fs);
        }
        fs.blockForPending();
        this.unlock(null);
    }

    public Frame deepSlice(Object orows, Object ocols) {
        int[] c2;
        long[] cols;
        if (ocols == null) {
            cols = null;
        } else if (ocols instanceof long[]) {
            cols = (long[])ocols;
        } else if (ocols instanceof Frame) {
            Frame fr = (Frame)ocols;
            if (fr.numCols() != 1) {
                throw new IllegalArgumentException("Columns Frame must have only one column (actually has " + fr.numCols() + " columns)");
            }
            long n = fr.anyVec().length();
            if (n > 100000L) {
                throw new IllegalArgumentException("Too many requested columns (requested " + n + ", max " + 100000 + ")");
            }
            cols = new long[(int)n];
            Vec.Reader v = new Vec.Reader(fr.anyVec());
            for (long i = 0L; i < v.length(); ++i) {
                cols[(int)i] = v.at8(i);
            }
        } else {
            throw new IllegalArgumentException("Columns is specified by an unsupported data type (" + ocols.getClass().getName() + ")");
        }
        if (cols == null) {
            c2 = new int[this.numCols()];
            for (int i = 0; i < c2.length; ++i) {
                c2[i] = i;
            }
        } else if (cols.length == 0) {
            c2 = new int[]{};
        } else if (cols[0] >= 0L) {
            c2 = new int[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                c2[i] = (int)cols[i];
            }
        } else {
            c2 = new int[this.numCols() - cols.length];
            int j = 0;
            for (int i = 0; i < this.numCols(); ++i) {
                if (j >= cols.length || (long)i < -(1L + cols[j])) {
                    c2[i - j] = i;
                    continue;
                }
                ++j;
            }
        }
        for (int aC2 : c2) {
            if (aC2 < this.numCols()) continue;
            throw new IllegalArgumentException("Trying to select column " + (aC2 + 1) + " but only " + this.numCols() + " present.");
        }
        if (c2.length == 0) {
            throw new IllegalArgumentException("No columns selected (did you try to select column 0 instead of column 1?)");
        }
        if (this.numRows() == 0L) {
            return ((MRTask)new MRTask(){

                @Override
                public void map(Chunk[] chks, NewChunk[] nchks) {
                    for (NewChunk nc : nchks) {
                        nc.addNA();
                    }
                }
            }.doAll(this.types(c2), this)).outputFrame(this.names(c2), this.domains(c2));
        }
        if (orows == null) {
            return ((DeepSlice)new DeepSlice(null, c2, this.vecs()).doAll(this.types(c2), this)).outputFrame(this.names(c2), this.domains(c2));
        }
        if (orows instanceof long[]) {
            long CHK_ROWS = 1000000L;
            final long[] rows = (long[])orows;
            if (this.numRows() == 0L) {
                return this;
            }
            if (rows.length == 0 || rows[0] < 0L) {
                if (rows.length != 0 && rows[0] < 0L) {
                    Vec v0 = this.anyVec().makeZero();
                    Vec v = ((MRTask)((MRTask)new MRTask(){

                        @Override
                        public void map(Chunk cs) {
                            for (long er : rows) {
                                if (er >= 0L || (er = Math.abs(er)) < cs._start || er > (long)cs._len + cs._start - 1L) continue;
                                cs.set((int)(er - cs._start), 1L);
                            }
                        }
                    }.doAll((Vec[])new Vec[]{v0})).getResult())._fr.anyVec();
                    Keyed.remove(v0._key);
                    Frame slicedFrame = ((DeepSlice)new DeepSlice(rows, c2, this.vecs()).doAll(this.types(c2), this.add("select_vec", v))).outputFrame(this.names(c2), this.domains(c2));
                    Keyed.remove(v._key);
                    Keyed.remove(this.remove((int)(this.numCols() - 1))._key);
                    return slicedFrame;
                }
                return ((DeepSlice)new DeepSlice(rows.length == 0 ? null : rows, c2, this.vecs()).doAll(this.types(c2), this)).outputFrame(this.names(c2), this.domains(c2));
            }
            Futures fs = new Futures();
            AppendableVec av = new AppendableVec(Vec.newKey(), 3);
            int r = 0;
            int c = 0;
            while (r < rows.length) {
                NewChunk nc = new NewChunk(av, c);
                long end = Math.min((long)r + 1000000L, (long)rows.length);
                while ((long)r < end) {
                    nc.addNum(rows[r]);
                    ++r;
                }
                nc.close(c++, fs);
            }
            Vec c0 = av.layout_and_close(fs);
            fs.blockForPending();
            Frame ff = new Frame(new String[]{"rownames"}, new Vec[]{c0});
            Frame fr2 = ((Slice)new Slice(c2, this).doAll(this.types(c2), ff)).outputFrame(this.names(c2), this.domains(c2));
            Keyed.remove(c0._key);
            Keyed.remove(av._key);
            ff.delete();
            return fr2;
        }
        Frame frows = (Frame)orows;
        Vec[] vecs = new Vec[c2.length + 1];
        String[] names = new String[c2.length + 1];
        for (int i = 0; i < c2.length; ++i) {
            vecs[i] = this._vecs[c2[i]];
            names[i] = this._names[c2[i]];
        }
        vecs[c2.length] = frows.anyVec();
        names[c2.length] = "predicate";
        Frame ff = new Frame(names, vecs);
        return ((DeepSelect)new DeepSelect().doAll(this.types(c2), ff)).outputFrame(this.names(c2), this.domains(c2));
    }

    public String toString() {
        return this.toString(0L, 20);
    }

    public String toString(long off, int len) {
        if (off > this.numRows()) {
            off = this.numRows();
        }
        if (off + (long)len > this.numRows()) {
            len = (int)(this.numRows() - off);
        }
        String[] rowHeaders = new String[len + 5];
        rowHeaders[0] = "min";
        rowHeaders[1] = "mean";
        rowHeaders[2] = "stddev";
        rowHeaders[3] = "max";
        rowHeaders[4] = "missing";
        for (int i = 0; i < len; ++i) {
            rowHeaders[i + 5] = "" + (off + (long)i);
        }
        int ncols = this.numCols();
        Vec[] vecs = this.vecs();
        String[] coltypes = new String[ncols];
        String[][] strCells = new String[len + 5][ncols];
        double[][] dblCells = new double[len + 5][ncols];
        block9: for (int i = 0; i < ncols; ++i) {
            Vec vec = vecs[i];
            dblCells[0][i] = vec.min();
            dblCells[1][i] = vec.mean();
            dblCells[2][i] = vec.sigma();
            dblCells[3][i] = vec.max();
            dblCells[4][i] = vec.naCnt();
            switch (vec.get_type()) {
                case 0: {
                    coltypes[i] = "string";
                    for (int j = 0; j < len; ++j) {
                        strCells[j + 5][i] = null;
                        dblCells[j + 5][i] = 9.9E-324;
                    }
                    continue block9;
                }
                case 2: {
                    coltypes[i] = "string";
                    BufferedString tmpStr = new BufferedString();
                    for (int j = 0; j < len; ++j) {
                        strCells[j + 5][i] = vec.isNA(off + (long)j) ? "" : vec.atStr(tmpStr, off + (long)j).toString();
                        dblCells[j + 5][i] = 9.9E-324;
                    }
                    continue block9;
                }
                case 4: {
                    coltypes[i] = "string";
                    for (int j = 0; j < len; ++j) {
                        strCells[j + 5][i] = vec.isNA(off + (long)j) ? "" : vec.factor(vec.at8(off + (long)j));
                        dblCells[j + 5][i] = 9.9E-324;
                    }
                    continue block9;
                }
                case 5: {
                    int j;
                    coltypes[i] = "string";
                    DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
                    for (j = 0; j < len; ++j) {
                        strCells[j + 5][i] = fmt.print(vec.at8(off + (long)j));
                        dblCells[j + 5][i] = 9.9E-324;
                    }
                    continue block9;
                }
                case 3: {
                    int j;
                    coltypes[i] = vec.isInt() ? "long" : "double";
                    for (j = 0; j < len; ++j) {
                        dblCells[j + 5][i] = vec.isNA(off + (long)j) ? 9.9E-324 : vec.at(off + (long)j);
                        strCells[j + 5][i] = null;
                    }
                    continue block9;
                }
                case 1: {
                    throw H2O.unimpl();
                }
                default: {
                    System.err.println("bad vector type during debug print: " + vec.get_type());
                    throw H2O.fail();
                }
            }
        }
        return new TwoDimTable("Frame " + this._key, this.numRows() + " rows and " + this.numCols() + " cols", rowHeaders, (String[])this._names.clone(), coltypes, null, "", strCells, dblCells).toString();
    }

    public Frame deepCopy(String keyName) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk[] ncs) {
                for (int col = 0; col < cs.length; ++col) {
                    for (int row = 0; row < cs[0]._len; ++row) {
                        if (cs[col].isNA(row)) {
                            ncs[col].addNA();
                            continue;
                        }
                        if (cs[col] instanceof CStrChunk) {
                            ncs[col].addStr(cs[col], row);
                            continue;
                        }
                        if (cs[col] instanceof C16Chunk) {
                            ncs[col].addUUID(cs[col], row);
                            continue;
                        }
                        if (!cs[col].hasFloat()) {
                            ncs[col].addNum(cs[col].at8(row), 0);
                            continue;
                        }
                        ncs[col].addNum(cs[col].atd(row));
                    }
                }
            }
        }.doAll(this.types(), this)).outputFrame(keyName == null ? null : Key.make(keyName), this.names(), this.domains());
    }

    private String[][] domains(int[] cols) {
        Vec[] vecs = this.vecs();
        String[][] res = new String[cols.length][];
        for (int i = 0; i < cols.length; ++i) {
            res[i] = vecs[cols[i]].domain();
        }
        return res;
    }

    private String[] names(int[] cols) {
        if (this._names == null) {
            return null;
        }
        String[] res = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            res[i] = this._names[cols[i]];
        }
        return res;
    }

    private byte[] types(int[] cols) {
        Vec[] vecs = this.vecs();
        byte[] res = new byte[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            res[i] = vecs[cols[i]]._type;
        }
        return res;
    }

    public Frame makeCompatible(Frame f) {
        if (this.anyVec() == null) {
            return f;
        }
        Vec v1 = this.anyVec();
        Vec v2 = f.anyVec();
        if (v1.length() != v2.length()) {
            throw new IllegalArgumentException("Can not make vectors of different length compatible!");
        }
        if (v2 == null || v1.checkCompatible(v2)) {
            return f;
        }
        Key k = Key.make();
        H2O.submitTask(new RebalanceDataSet(this, f, k)).join();
        Frame f2 = (Frame)k.get();
        DKV.remove(k);
        return f2;
    }

    private boolean isLastRowOfCurrentNonEmptyChunk(int chunkIdx, long row) {
        long[] espc = this.anyVec().espc();
        long lastRowOfCurrentChunk = espc[chunkIdx + 1] - 1L;
        assert (espc[chunkIdx + 1] > espc[chunkIdx]);
        assert (row <= lastRowOfCurrentChunk);
        return row >= lastRowOfCurrentChunk;
    }

    private void hintFlushRemoteChunk(Vec v, int cidx) {
        Key k = v.chunkKey(cidx);
        if (!k.home()) {
            H2O.raw_remove(k);
        }
    }

    public InputStream toCSV(boolean headers, boolean hex_string) {
        return new CSVStream(headers, hex_string);
    }

    public class CSVStream
    extends InputStream {
        private final boolean _hex_string;
        byte[] _line;
        int _position;
        public volatile int _curChkIdx = 0;
        long _row;

        CSVStream(boolean headers, boolean hex_string) {
            this._hex_string = hex_string;
            StringBuilder sb = new StringBuilder();
            Vec[] vs = Frame.this.vecs();
            if (headers) {
                sb.append('\"').append(Frame.this._names[0]).append('\"');
                for (int i = 1; i < vs.length; ++i) {
                    sb.append(',').append('\"').append(Frame.this._names[i]).append('\"');
                }
                sb.append('\n');
            }
            this._line = sb.toString().getBytes();
        }

        byte[] getBytesForRow() {
            StringBuilder sb = new StringBuilder();
            Vec[] vs = Frame.this.vecs();
            BufferedString tmpStr = new BufferedString();
            for (int i = 0; i < vs.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                if (vs[i].isNA(this._row)) continue;
                if (vs[i].isCategorical()) {
                    sb.append('\"').append(vs[i].factor(vs[i].at8(this._row))).append('\"');
                    continue;
                }
                if (vs[i].isUUID()) {
                    sb.append(PrettyPrint.UUID(vs[i].at16l(this._row), vs[i].at16h(this._row)));
                    continue;
                }
                if (vs[i].isInt()) {
                    sb.append(vs[i].at8(this._row));
                    continue;
                }
                if (vs[i].isString()) {
                    sb.append('\"').append(vs[i].atStr(tmpStr, this._row)).append('\"');
                    continue;
                }
                double d = vs[i].at(this._row);
                String s = this._hex_string ? Double.toHexString(d) : Double.toString(d);
                sb.append(s);
            }
            sb.append('\n');
            return sb.toString().getBytes();
        }

        @Override
        public int available() throws IOException {
            if (this._position != this._line.length) {
                return this._line.length - this._position;
            }
            if (this._row == Frame.this.numRows()) {
                return 0;
            }
            this._curChkIdx = Frame.this.anyVec().elem2ChunkIdx(this._row);
            this._line = this.getBytesForRow();
            this._position = 0;
            if (Frame.this.isLastRowOfCurrentNonEmptyChunk(this._curChkIdx, this._row)) {
                for (Vec v : Frame.this.vecs()) {
                    Frame.this.hintFlushRemoteChunk(v, this._curChkIdx);
                }
            }
            ++this._row;
            return this._line.length;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this._line = null;
        }

        @Override
        public int read() throws IOException {
            return this.available() == 0 ? -1 : this._line[this._position++];
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.available();
            if (n > 0) {
                n = Math.min(n, len);
                System.arraycopy(this._line, this._position, b, off, n);
                this._position += n;
            }
            return n;
        }
    }

    private static class DeepSelect
    extends MRTask<DeepSelect> {
        private DeepSelect() {
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] nchks) {
            Chunk pred = chks[chks.length - 1];
            BufferedString tmpStr = new BufferedString();
            for (int i = 0; i < pred._len; ++i) {
                if (pred.atd(i) == 0.0 || pred.isNA(i)) continue;
                for (int j = 0; j < chks.length - 1; ++j) {
                    Chunk chk = chks[j];
                    if (chk.isNA(i)) {
                        nchks[j].addNA();
                        continue;
                    }
                    if (chk instanceof C16Chunk) {
                        nchks[j].addUUID(chk, i);
                        continue;
                    }
                    if (chk instanceof CStrChunk) {
                        nchks[j].addStr(chk.atStr(tmpStr, i));
                        continue;
                    }
                    if (chk.hasFloat()) {
                        nchks[j].addNum(chk.atd(i));
                        continue;
                    }
                    nchks[j].addNum(chk.at8(i), 0);
                }
            }
        }
    }

    private class DoCopyFrame
    extends MRTask<DoCopyFrame> {
        final Vec[] _vecs;

        DoCopyFrame(Vec[] vecs) {
            this._vecs = new Vec[vecs.length];
            int rowLayout = this._vecs[0]._rowLayout;
            for (int i = 0; i < vecs.length; ++i) {
                this._vecs[i] = new Vec(vecs[i].group().addVec(), rowLayout, vecs[i].domain(), vecs[i]._type);
            }
        }

        @Override
        public void map(Chunk[] cs) {
            int i = 0;
            for (Chunk c : cs) {
                Chunk c2 = (Chunk)c.clone();
                c2._vec = null;
                c2._start = -1L;
                c2._cidx = -1;
                c2._mem = (byte[])c2._mem.clone();
                DKV.put(this._vecs[i++].chunkKey(c.cidx()), c2, this._fs, true);
            }
        }

        @Override
        public void postGlobal() {
            for (Vec _vec : this._vecs) {
                DKV.put(_vec);
            }
        }
    }

    private static class DeepSlice
    extends MRTask<DeepSlice> {
        final int[] _cols;
        final long[] _rows;
        final byte[] _isInt;

        DeepSlice(long[] rows, int[] cols, Vec[] vecs) {
            this._cols = cols;
            this._rows = rows;
            this._isInt = new byte[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                this._isInt[i] = (byte)(vecs[cols[i]].isInt() ? 1 : 0);
            }
        }

        @Override
        public boolean logVerbose() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void map(Chunk[] chks, NewChunk[] nchks) {
            long rstart = chks[0]._start;
            int rlen = chks[0]._len;
            int rx = 0;
            int rlo = 0;
            int rhi = rlen;
            while (true) {
                if (this._rows != null) {
                    long r;
                    if (rx >= this._rows.length) return;
                    if ((r = this._rows[rx++]) < rstart) continue;
                    rlo = (int)(r - rstart);
                    for (rhi = rlo + 1; rx < this._rows.length && this._rows[rx] - rstart == (long)rhi && rhi < rlen; ++rx, ++rhi) {
                    }
                }
                BufferedString tmpStr = new BufferedString();
                for (int i = 0; i < this._cols.length; ++i) {
                    int j;
                    Chunk oc = chks[this._cols[i]];
                    NewChunk nc = nchks[i];
                    if (this._isInt[i] == 1) {
                        for (j = rlo; j < rhi; ++j) {
                            if (oc._vec.isUUID()) {
                                nc.addUUID(oc, j);
                                continue;
                            }
                            if (oc.isNA(j)) {
                                nc.addNA();
                                continue;
                            }
                            nc.addNum(oc.at8(j), 0);
                        }
                        continue;
                    }
                    if (oc._vec.isString()) {
                        for (j = rlo; j < rhi; ++j) {
                            nc.addStr(oc.atStr(tmpStr, j));
                        }
                        continue;
                    }
                    for (j = rlo; j < rhi; ++j) {
                        nc.addNum(oc.atd(j));
                    }
                }
                rlo = rhi;
                if (this._rows == null) return;
            }
        }
    }

    private static class Slice
    extends MRTask<Slice> {
        final Frame _base;
        final int[] _cols;

        Slice(int[] cols, Frame base) {
            this._cols = cols;
            this._base = base;
        }

        @Override
        public void map(Chunk[] ix, NewChunk[] ncs) {
            Vec[] vecs = new Vec[this._cols.length];
            Vec anyv = this._base.anyVec();
            long nrow = anyv.length();
            long r = ix[0].at8(0);
            int last_ci = anyv.elem2ChunkIdx(r < nrow ? r : 0L);
            long last_c0 = anyv.espc()[last_ci];
            long last_c1 = anyv.espc()[last_ci + 1];
            Chunk[] last_cs = new Chunk[vecs.length];
            for (int c = 0; c < this._cols.length; ++c) {
                vecs[c] = this._base.vecs()[this._cols[c]];
                last_cs[c] = vecs[c].chunkForChunkIdx(last_ci);
            }
            for (int i = 0; i < ix[0]._len; ++i) {
                int c;
                r = ix[0].at8(i);
                if (r < 0L) continue;
                if (r >= nrow) {
                    for (c = 0; c < vecs.length; ++c) {
                        ncs[c].addNum(Double.NaN);
                    }
                    continue;
                }
                if (r < last_c0 || r >= last_c1) {
                    last_ci = anyv.elem2ChunkIdx(r);
                    last_c0 = anyv.espc()[last_ci];
                    last_c1 = anyv.espc()[last_ci + 1];
                    for (c = 0; c < vecs.length; ++c) {
                        last_cs[c] = vecs[c].chunkForChunkIdx(last_ci);
                    }
                }
                for (c = 0; c < vecs.length; ++c) {
                    if (vecs[c].isUUID()) {
                        ncs[c].addUUID(last_cs[c], r);
                        continue;
                    }
                    if (vecs[c].isString()) {
                        ncs[c].addStr(last_cs[c], r);
                        continue;
                    }
                    ncs[c].addNum(last_cs[c].at_abs(r));
                }
            }
        }
    }

    public static class VecSpecifier
    extends Iced {
        public Key<Frame> _frame;
        String _column_name;

        public Vec vec() {
            Value v = DKV.get(this._frame);
            if (null == v) {
                return null;
            }
            Frame f = (Frame)v.get();
            if (null == f) {
                return null;
            }
            return f.vec(this._column_name);
        }
    }
}

