/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import hex.CreateFrame;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import jsr166y.CountedCompleter;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.RandomUtils;

public class FrameCreator
extends H2O.H2OCountedCompleter {
    transient Vec _v;
    private final CreateFrame _createFrame;
    private int[] _cat_cols;
    private int[] _int_cols;
    private int[] _real_cols;
    private int[] _bin_cols;
    private String[][] _domain;
    private Frame _out;
    private final Key _job;

    public FrameCreator(CreateFrame createFrame, Key job) {
        super(null);
        this._job = job;
        this._createFrame = createFrame;
        int[] idx = this._createFrame.has_response ? ArrayUtils.seq(1, this._createFrame.cols + 1) : ArrayUtils.seq(0, this._createFrame.cols);
        int[] shuffled_idx = new int[idx.length];
        ArrayUtils.shuffleArray(idx, idx.length, shuffled_idx, this._createFrame.seed, 0);
        int catcols = (int)(this._createFrame.categorical_fraction * (double)this._createFrame.cols);
        int intcols = (int)(this._createFrame.integer_fraction * (double)this._createFrame.cols);
        int bincols = (int)(this._createFrame.binary_fraction * (double)this._createFrame.cols);
        int realcols = this._createFrame.cols - catcols - intcols - bincols;
        assert (catcols >= 0);
        assert (intcols >= 0);
        assert (bincols >= 0);
        assert (realcols >= 0);
        this._cat_cols = Arrays.copyOfRange(shuffled_idx, 0, catcols);
        this._int_cols = Arrays.copyOfRange(shuffled_idx, catcols, catcols + intcols);
        this._real_cols = Arrays.copyOfRange(shuffled_idx, catcols + intcols, catcols + intcols + realcols);
        this._bin_cols = Arrays.copyOfRange(shuffled_idx, catcols + intcols + realcols, catcols + intcols + realcols + bincols);
        this._domain = new String[this._createFrame.cols + (this._createFrame.has_response ? 1 : 0)][];
        if (createFrame.randomize) {
            if (this._createFrame.has_response) {
                assert (this._createFrame.response_factors >= 1);
                String[] stringArray = this._domain[0] = this._createFrame.response_factors == 1 ? null : new String[this._createFrame.response_factors];
                if (this._domain[0] != null) {
                    for (int i = 0; i < this._domain[0].length; ++i) {
                        this._domain[0][i] = new Integer(i).toString();
                    }
                }
            }
            for (int c : this._cat_cols) {
                this._domain[c] = new String[this._createFrame.factors];
                for (int i = 0; i < this._createFrame.factors; ++i) {
                    this._domain[c][i] = UUID.randomUUID().toString().subSequence(0, 5).toString();
                    while (this._domain[c][i].matches("^\\d+$") || this._domain[c][i].matches("^\\d+e\\d+$")) {
                        this._domain[c][i] = UUID.randomUUID().toString().subSequence(0, 5).toString();
                    }
                }
            }
        }
        int log_rows_per_chunk = Math.max(1, 22 - (int)Math.floor(Math.log(this._createFrame.cols) / Math.log(2.0)));
        this._v = Vec.makeCon((double)this._createFrame.value, this._createFrame.rows, log_rows_per_chunk, false);
    }

    public int nChunks() {
        return this._v.nChunks();
    }

    @Override
    public void compute2() {
        int i;
        int i2;
        int totcols = this._createFrame.cols + (this._createFrame.has_response ? 1 : 0);
        Vec[] vecs = new Vec[totcols];
        if (this._createFrame.randomize) {
            for (i2 = 0; i2 < vecs.length; ++i2) {
                vecs[i2] = this._v.makeZero(this._domain[i2]);
            }
        } else {
            for (i2 = 0; i2 < vecs.length; ++i2) {
                vecs[i2] = this._v.makeCon(this._createFrame.value);
            }
        }
        this._v.remove();
        this._v = null;
        String[] names = new String[vecs.length];
        if (this._createFrame.has_response) {
            names[0] = "response";
            for (i = 1; i < vecs.length; ++i) {
                names[i] = "C" + i;
            }
        } else {
            for (i = 0; i < vecs.length; ++i) {
                names[i] = "C" + (i + 1);
            }
        }
        this._out = new Frame(this._createFrame._dest, names, vecs);
        assert (this._out.numRows() == this._createFrame.rows);
        assert (this._out.numCols() == totcols);
        this._out.delete_and_lock(this._job);
        new FrameRandomizer(this._createFrame, this._cat_cols, this._int_cols, this._real_cols, this._bin_cols).doAll(this._out);
        FrameUtils.MissingInserter mi = new FrameUtils.MissingInserter(this._createFrame._dest, this._createFrame.seed, this._createFrame.missing_fraction);
        mi.execImpl();
        mi.get();
        mi.remove();
        this.tryComplete();
    }

    @Override
    public void onCompletion(CountedCompleter caller) {
        this._out.update(this._job);
        this._out.unlock(this._job);
        ((Job)DKV.getGet(this._job)).done();
    }

    private static class FrameRandomizer
    extends MRTask<FrameRandomizer> {
        private final CreateFrame _createFrame;
        private final int[] _cat_cols;
        private final int[] _int_cols;
        private final int[] _real_cols;
        private final int[] _bin_cols;

        public FrameRandomizer(CreateFrame createFrame, int[] cat_cols, int[] int_cols, int[] real_cols, int[] bin_cols) {
            this._createFrame = createFrame;
            this._cat_cols = cat_cols;
            this._int_cols = int_cols;
            this._real_cols = real_cols;
            this._bin_cols = bin_cols;
        }

        void setSeed(Random rng, int col, long row) {
            rng.setSeed(this._createFrame.seed + (long)this._createFrame.cols * row + (long)col);
            rng.setSeed(rng.nextLong());
        }

        @Override
        public void map(Chunk[] cs) {
            int r;
            if (this._createFrame.isCancelledOrCrashed()) {
                return;
            }
            if (!this._createFrame.randomize) {
                return;
            }
            Random rng = RandomUtils.getRNG(new Random().nextLong());
            if (this._createFrame.has_response) {
                for (int r2 = 0; r2 < cs[0]._len; ++r2) {
                    this.setSeed(rng, 0, cs[0]._start + (long)r2);
                    if (this._createFrame.response_factors > 1) {
                        cs[0].set(r2, (int)(rng.nextDouble() * (double)this._createFrame.response_factors));
                        continue;
                    }
                    if (this._createFrame.positive_response) {
                        cs[0].set(r2, (double)this._createFrame.real_range * rng.nextDouble());
                        continue;
                    }
                    cs[0].set(r2, (double)this._createFrame.real_range * (1.0 - 2.0 * rng.nextDouble()));
                }
            }
            this._createFrame.update(1L);
            for (int c : this._cat_cols) {
                for (r = 0; r < cs[c]._len; ++r) {
                    this.setSeed(rng, c, cs[c]._start + (long)r);
                    cs[c].set(r, (int)(rng.nextDouble() * (double)this._createFrame.factors));
                }
            }
            this._createFrame.update(1L);
            for (int c : this._int_cols) {
                for (r = 0; r < cs[c]._len; ++r) {
                    this.setSeed(rng, c, cs[c]._start + (long)r);
                    cs[c].set(r, -this._createFrame.integer_range + (long)(rng.nextDouble() * (double)(2L * this._createFrame.integer_range + 1L)));
                }
            }
            this._createFrame.update(1L);
            for (int c : this._real_cols) {
                for (r = 0; r < cs[c]._len; ++r) {
                    this.setSeed(rng, c, cs[c]._start + (long)r);
                    cs[c].set(r, (double)this._createFrame.real_range * (1.0 - 2.0 * rng.nextDouble()));
                }
            }
            this._createFrame.update(1L);
            for (int c : this._bin_cols) {
                for (r = 0; r < cs[c]._len; ++r) {
                    this.setSeed(rng, c, cs[c]._start + (long)r);
                    cs[c].set(r, (double)rng.nextFloat() > this._createFrame.binary_ones_fraction ? 0L : 1L);
                }
            }
            this._createFrame.update(1L);
        }
    }
}

