/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.AutoBuffer;
import water.H2O;
import water.H2ONode;
import water.JettyHTTPD;
import water.Paxos;
import water.init.AbstractEmbeddedH2OConfig;
import water.util.Log;

public class NetworkInit {
    int _o1;
    int _o2;
    int _o3;
    int _o4;
    int _bits;
    public static DatagramChannel _udpSocket;
    public static ServerSocketChannel _tcpSocketBig;
    public static ServerSocketChannel _tcpSocketSmall;
    public static ServerSocket _apiSocket;
    public static DatagramChannel CLOUD_DGRAM;

    NetworkInit(int o1, int o2, int o3, int o4, int bits) {
        this._o1 = o1;
        this._o2 = o2;
        this._o3 = o3;
        this._o4 = o4;
        this._bits = bits;
    }

    private boolean oValid(int o) {
        return 0 <= o && o <= 255;
    }

    private boolean valid() {
        if (!this.oValid(this._o1)) {
            return false;
        }
        if (!this.oValid(this._o2)) {
            return false;
        }
        if (!this.oValid(this._o3)) {
            return false;
        }
        if (!this.oValid(this._o4)) {
            return false;
        }
        return 0 <= this._bits && this._bits <= 32;
    }

    boolean inetAddressOnNetwork(InetAddress ia) {
        int i = this._o1 << 24 | this._o2 << 16 | this._o3 << 8 | this._o4 << 0;
        byte[] barr = ia.getAddress();
        if (barr.length != 4) {
            return false;
        }
        long mask1 = 1L << 32 - this._bits;
        long mask2 = mask1 - 1L;
        long mask3 = mask2 ^ 0xFFFFFFFFFFFFFFFFL;
        int mask4 = (int)(mask3 & 0xFFFFFFFFFFFFFFFFL);
        int j = (barr[0] & 0xFF) << 24 | (barr[1] & 0xFF) << 16 | (barr[2] & 0xFF) << 8 | (barr[3] & 0xFF) << 0;
        return (i & mask4) == (j & mask4);
    }

    public static InetAddress findInetAddressForSelf() throws Error {
        ArrayList<InetAddress> validIps;
        ArrayList<NetworkInit> networkList;
        if (H2O.SELF_ADDRESS != null) {
            return H2O.SELF_ADDRESS;
        }
        if (H2O.ARGS.ip != null && H2O.ARGS.network != null) {
            Log.err("ip and network options must not be used together");
            H2O.exit(-1);
        }
        if ((networkList = NetworkInit.calcArrayList(H2O.ARGS.network)) == null) {
            Log.err("Exiting.");
            H2O.exit(-1);
        }
        ArrayList<InetAddress> ips = NetworkInit.calcPrioritizedInetAddressList();
        InetAddress local = null;
        InetAddress arg = null;
        if (H2O.ARGS.ip != null) {
            try {
                arg = InetAddress.getByName(H2O.ARGS.ip);
            }
            catch (UnknownHostException e) {
                Log.err(e);
                H2O.exit(-1);
            }
            if (!(arg instanceof Inet4Address)) {
                Log.warn("Only IP4 addresses allowed.");
                H2O.exit(-1);
            }
            if (!ips.contains(arg)) {
                Log.warn("IP address not found on this machine");
                H2O.exit(-1);
            }
            local = arg;
        } else if (networkList.size() > 0) {
            Log.info("Network list was specified by the user.  Searching for a match...");
            validIps = new ArrayList();
            for (InetAddress ip : ips) {
                Log.info("    Considering " + ip.getHostAddress() + " ...");
                for (NetworkInit n : networkList) {
                    if (!n.inetAddressOnNetwork(ip)) continue;
                    Log.info("    Matched " + ip.getHostAddress());
                    H2O.SELF_ADDRESS = ip;
                    return H2O.SELF_ADDRESS;
                }
            }
            Log.err("No interface matches the network list from the -network option.  Exiting.");
            H2O.exit(-1);
        } else {
            validIps = new ArrayList<InetAddress>();
            for (InetAddress ip : ips) {
                if (!(ip instanceof Inet4Address) || ip.isLoopbackAddress() || ip.isLinkLocalAddress()) continue;
                validIps.add(ip);
            }
            local = validIps.size() == 1 ? validIps.get(0) : NetworkInit.guessInetAddress(validIps);
        }
        if (local == null) {
            try {
                Log.warn("Failed to determine IP, falling back to localhost.");
                local = InetAddress.getByName("127.0.0.1");
            }
            catch (UnknownHostException e) {
                Log.throwErr(e);
            }
        }
        H2O.SELF_ADDRESS = local;
        return H2O.SELF_ADDRESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static InetAddress guessInetAddress(List<InetAddress> ips) {
        InetAddress ip2222222222;
        String m = "Multiple local IPs detected:\n";
        for (InetAddress ip2222222222 : ips) {
            m = m + "  " + ip2222222222;
        }
        m = m + "\nAttempting to determine correct address...\n";
        Socket s = null;
        try {
            s = new Socket("8.8.8.8", 53);
            m = m + "Using " + s.getLocalAddress() + "\n";
            ip2222222222 = s.getLocalAddress();
        }
        catch (SocketException se) {
            InetAddress inetAddress = null;
            Log.warn(m);
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException ie) {
                    // empty catch block
                }
            }
            return inetAddress;
        }
        catch (Throwable t) {
            Log.err(t);
            InetAddress inetAddress = null;
            {
                catch (Throwable throwable) {
                    Log.warn(m);
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (IOException ie) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            Log.warn(m);
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException ie) {
                    // empty catch block
                }
            }
            return inetAddress;
        }
        Log.warn(m);
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException ie) {
                // empty catch block
            }
        }
        return ip2222222222;
    }

    private static ArrayList<NetworkInterface> calcPrioritizedInterfaceList() {
        ArrayList<NetworkInterface> networkInterfaceList = null;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            ArrayList<NetworkInterface> tmpList = Collections.list(nis);
            Comparator<NetworkInterface> c = new Comparator<NetworkInterface>(){

                @Override
                public int compare(NetworkInterface lhs, NetworkInterface rhs) {
                    if (lhs == null && rhs == null) {
                        return 0;
                    }
                    if (lhs == null) {
                        return 1;
                    }
                    if (rhs == null) {
                        return -1;
                    }
                    if (lhs.getName().equals(rhs.getName())) {
                        return 0;
                    }
                    if (lhs.getName().startsWith("bond") && rhs.getName().startsWith("bond")) {
                        Integer ri;
                        Integer li = lhs.getName().length();
                        if (li.compareTo(ri = Integer.valueOf(rhs.getName().length())) != 0) {
                            return li.compareTo(ri);
                        }
                        return lhs.getName().compareTo(rhs.getName());
                    }
                    if (lhs.getName().startsWith("bond")) {
                        return -1;
                    }
                    if (rhs.getName().startsWith("bond")) {
                        return 1;
                    }
                    return 0;
                }
            };
            Collections.sort(tmpList, c);
            networkInterfaceList = tmpList;
        }
        catch (SocketException e) {
            Log.err(e);
        }
        return networkInterfaceList;
    }

    static ArrayList<InetAddress> calcPrioritizedInetAddressList() {
        ArrayList<InetAddress> ips = new ArrayList<InetAddress>();
        ArrayList<NetworkInterface> networkInterfaceList = NetworkInit.calcPrioritizedInterfaceList();
        for (NetworkInterface ni : networkInterfaceList) {
            Enumeration<InetAddress> ias = ni.getInetAddresses();
            while (ias.hasMoreElements()) {
                InetAddress ia = ias.nextElement();
                ips.add(ia);
                Log.info("Possible IP Address: " + ni.getName() + " (" + ni.getDisplayName() + "), " + ia.getHostAddress());
            }
        }
        return ips;
    }

    static ArrayList<NetworkInit> calcArrayList(String networkOpt) {
        ArrayList<NetworkInit> networkList = new ArrayList<NetworkInit>();
        if (networkOpt == null) {
            return networkList;
        }
        String[] networks = networkOpt.contains(",") ? networkOpt.split(",") : new String[]{networkOpt};
        for (String n : networks) {
            int bits;
            int o4;
            int o3;
            int o2;
            Pattern p = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)/(\\d+)");
            Matcher m = p.matcher(n);
            boolean b = m.matches();
            if (!b) {
                Log.err("network invalid: " + n);
                return null;
            }
            assert (m.groupCount() == 5);
            int o1 = Integer.parseInt(m.group(1));
            NetworkInit usn = new NetworkInit(o1, o2 = Integer.parseInt(m.group(2)), o3 = Integer.parseInt(m.group(3)), o4 = Integer.parseInt(m.group(4)), bits = Integer.parseInt(m.group(5)));
            if (!usn.valid()) {
                Log.err("network invalid: " + n);
                return null;
            }
            networkList.add(usn);
        }
        return networkList;
    }

    public static void initializeNetworkSockets() {
        int n = H2O.API_PORT = H2O.ARGS.port == 0 ? H2O.ARGS.baseport : H2O.ARGS.port;
        if (H2O.getJetty() == null) {
            H2O.setJetty(new JettyHTTPD());
        }
        while (true) {
            H2O.H2O_PORT = H2O.API_PORT + 1;
            try {
                _apiSocket = H2O.ARGS.ip == null ? new ServerSocket(H2O.API_PORT) : new ServerSocket(H2O.API_PORT, -1, H2O.SELF_ADDRESS);
                _apiSocket.setReuseAddress(true);
                _udpSocket = DatagramChannel.open();
                _udpSocket.socket().setReuseAddress(true);
                InetSocketAddress isa = new InetSocketAddress(H2O.SELF_ADDRESS, H2O.H2O_PORT);
                _udpSocket.socket().bind(isa);
                _tcpSocketBig = ServerSocketChannel.open();
                _tcpSocketBig.socket().setReceiveBufferSize(AutoBuffer.TCP_BUF_SIZ);
                _tcpSocketBig.socket().bind(isa);
                if (!H2O.ARGS.useUDP) {
                    _tcpSocketSmall = ServerSocketChannel.open();
                    _tcpSocketBig.socket().setReceiveBufferSize(AutoBuffer.TCP_BUF_SIZ);
                    InetSocketAddress isa2 = new InetSocketAddress(H2O.SELF_ADDRESS, H2O.H2O_PORT + 1);
                    _tcpSocketSmall.socket().bind(isa2);
                }
                _apiSocket.close();
                if (H2O.ARGS.disable_web) break;
                H2O.getJetty().start(H2O.ARGS.ip, H2O.API_PORT);
            }
            catch (Exception e) {
                if (_apiSocket != null) {
                    try {
                        _apiSocket.close();
                    }
                    catch (IOException ohwell) {
                        Log.err(ohwell);
                    }
                }
                if (_udpSocket != null) {
                    try {
                        _udpSocket.close();
                    }
                    catch (IOException ie) {
                        // empty catch block
                    }
                }
                if (_tcpSocketBig != null) {
                    try {
                        _tcpSocketBig.close();
                    }
                    catch (IOException ie) {
                        // empty catch block
                    }
                }
                if (_tcpSocketSmall != null) {
                    try {
                        _tcpSocketSmall.close();
                    }
                    catch (IOException ie) {
                        // empty catch block
                    }
                }
                _apiSocket = null;
                _udpSocket = null;
                _tcpSocketBig = null;
                _tcpSocketSmall = null;
                if (H2O.ARGS.port != 0) {
                    H2O.die("On " + H2O.SELF_ADDRESS + " some of the required ports " + H2O.ARGS.port + ", " + (H2O.ARGS.port + 1) + " are not available, change -port PORT and try again.");
                }
                H2O.API_PORT += 2;
                continue;
            }
            break;
        }
        H2O.SELF = H2ONode.self(H2O.SELF_ADDRESS);
        Log.info("Internal communication uses port: ", H2O.H2O_PORT, "\nListening for HTTP and REST traffic on " + H2O.getJetty().getScheme() + "://", H2O.getIpPortString() + "/");
        try {
            Log.debug("Interface MTU: ", NetworkInterface.getByInetAddress(H2O.SELF_ADDRESS).getMTU());
        }
        catch (SocketException se) {
            Log.debug("No MTU due to SocketException. " + se.toString());
        }
        String embeddedConfigFlatfile = null;
        AbstractEmbeddedH2OConfig ec = H2O.getEmbeddedH2OConfig();
        if (ec != null) {
            ec.notifyAboutEmbeddedWebServerIpPort(H2O.SELF_ADDRESS, H2O.API_PORT);
            if (ec.providesFlatfile()) {
                try {
                    embeddedConfigFlatfile = ec.fetchFlatfile();
                }
                catch (Exception e) {
                    Log.err("Failed to get embedded config flatfile");
                    Log.err(e);
                    H2O.exit(1);
                }
            }
        }
        H2O.STATIC_H2OS = embeddedConfigFlatfile != null ? NetworkInit.parseFlatFileFromString(embeddedConfigFlatfile) : NetworkInit.parseFlatFile(H2O.ARGS.flatfile);
        int hash = H2O.ARGS.name.hashCode() & Integer.MAX_VALUE;
        int port = hash % 0xF000000 + -520093696;
        byte[] ip = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ip[i] = (byte)(port >>> (3 - i << 3));
        }
        try {
            H2O.CLOUD_MULTICAST_GROUP = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            Log.throwErr(e);
        }
        H2O.CLOUD_MULTICAST_PORT = port >>> 16;
    }

    public static void multicast(ByteBuffer bb, int priority) {
        try {
            NetworkInit.multicast2(bb, priority);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void multicast2(ByteBuffer bb, int priority) {
        if (H2O.STATIC_H2OS == null) {
            byte[] buf = new byte[bb.remaining()];
            bb.get(buf);
            Class<H2O> clazz = H2O.class;
            synchronized (H2O.class) {
                block17: {
                    assert (H2O.CLOUD_MULTICAST_IF != null);
                    try {
                        if (H2O.CLOUD_MULTICAST_SOCKET == null) {
                            H2O.CLOUD_MULTICAST_SOCKET = new MulticastSocket();
                            H2O.CLOUD_MULTICAST_SOCKET.setTimeToLive(2);
                            H2O.CLOUD_MULTICAST_SOCKET.setNetworkInterface(H2O.CLOUD_MULTICAST_IF);
                        }
                        H2O.CLOUD_MULTICAST_SOCKET.send(new DatagramPacket(buf, buf.length, H2O.CLOUD_MULTICAST_GROUP, H2O.CLOUD_MULTICAST_PORT));
                    }
                    catch (Exception e) {
                        if (H2O.CLOUD_MULTICAST_SOCKET == null) break block17;
                        try {
                            H2O.CLOUD_MULTICAST_SOCKET.close();
                        }
                        catch (Exception e2) {
                            Log.err("Got", e2);
                        }
                        finally {
                            H2O.CLOUD_MULTICAST_SOCKET = null;
                        }
                    }
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
            }
        }
        HashSet nodes = (HashSet)H2O.STATIC_H2OS.clone();
        nodes.addAll(Paxos.PROPOSED.values());
        bb.mark();
        H2ONode.H2OSmallMessage msg = H2O.ARGS.useUDP ? null : H2ONode.H2OSmallMessage.make(bb, priority);
        for (H2ONode h2o : nodes) {
            try {
                if (H2O.ARGS.useUDP) {
                    bb.reset();
                    CLOUD_DGRAM.send(bb, h2o._key);
                    continue;
                }
                h2o.sendMessage(msg);
            }
            catch (IOException e) {
                Log.warn("Multicast Error to " + h2o, e);
            }
        }
    }

    private static HashSet<H2ONode> parseFlatFile(String fname) {
        if (fname == null) {
            return null;
        }
        File f = new File(fname);
        if (!f.exists()) {
            Log.warn("-flatfile specified but not found: " + fname);
            return null;
        }
        HashSet<H2ONode> h2os = new HashSet<H2ONode>();
        List<FlatFileEntry> list = NetworkInit.parseFlatFile(f);
        for (FlatFileEntry entry : list) {
            h2os.add(H2ONode.intern(entry.inet, entry.port + 1));
        }
        return h2os;
    }

    static HashSet<H2ONode> parseFlatFileFromString(String s) {
        HashSet<H2ONode> h2os = new HashSet<H2ONode>();
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        List<FlatFileEntry> list = NetworkInit.parseFlatFile(is);
        for (FlatFileEntry entry : list) {
            h2os.add(H2ONode.intern(entry.inet, entry.port + 1));
        }
        return h2os;
    }

    static List<FlatFileEntry> parseFlatFile(File f) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
        }
        catch (Exception e) {
            H2O.die(e.toString());
        }
        return NetworkInit.parseFlatFile(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<FlatFileEntry> parseFlatFile(InputStream is) {
        ArrayList<FlatFileEntry> list = new ArrayList<FlatFileEntry>();
        BufferedReader br = null;
        int port = H2O.ARGS.port;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            String strLine = null;
            while ((strLine = br.readLine()) != null) {
                if ((strLine = strLine.trim()).startsWith("#") || strLine.isEmpty()) continue;
                String ip = null;
                String portStr = null;
                int slashIdx = strLine.indexOf(47);
                int colonIdx = strLine.indexOf(58);
                if (slashIdx == -1 && colonIdx == -1) {
                    ip = strLine;
                } else if (slashIdx == -1) {
                    ip = strLine.substring(0, colonIdx);
                    portStr = strLine.substring(colonIdx + 1);
                } else if (colonIdx == -1) {
                    ip = strLine.substring(slashIdx + 1);
                } else if (slashIdx > colonIdx) {
                    H2O.die("Invalid format, must be name/ip[:port], not '" + strLine + "'");
                } else {
                    ip = strLine.substring(slashIdx + 1, colonIdx);
                    portStr = strLine.substring(colonIdx + 1);
                }
                InetAddress inet = InetAddress.getByName(ip);
                if (!(inet instanceof Inet4Address)) {
                    H2O.die("Only IP4 addresses allowed: given " + ip);
                }
                if (portStr != null && !portStr.equals("")) {
                    try {
                        port = Integer.decode(portStr);
                    }
                    catch (NumberFormatException nfe) {
                        H2O.die("Invalid port #: " + portStr);
                    }
                }
                FlatFileEntry entry = new FlatFileEntry();
                entry.inet = inet;
                entry.port = port;
                list.add(entry);
            }
        }
        catch (Exception e) {
            H2O.die(e.toString());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ie) {}
            }
        }
        return list;
    }

    static class FlatFileEntry {
        InetAddress inet;
        int port;

        FlatFileEntry() {
        }
    }
}

