/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import water.Key;
import water.exceptions.H2OParseSetupException;
import water.parser.BufferedString;
import water.parser.ParseReader;
import water.parser.ParseSetup;
import water.parser.ParseWriter;
import water.parser.Parser;
import water.parser.ParserType;
import water.parser.PreviewParseWriter;
import water.util.PrettyPrint;

class SVMLightParser
extends Parser {
    private static final byte SKIP_TOKEN = 21;
    private static final byte INVALID_NUMBER = 22;
    private static final byte QID0 = 23;
    private static final byte QID1 = 24;
    private static final int TGT = 1;
    private static final int COL = 2;
    private static final int VAL = 3;

    SVMLightParser(ParseSetup ps, Key jobkey) {
        super(ps, jobkey);
    }

    public static ParseSetup guessSetup(byte[] bytes) {
        int i;
        for (i = bytes.length - 1; i > 0 && bytes[i] != 10; --i) {
        }
        assert (i >= 0);
        ByteArrayInputStream is = new ByteArrayInputStream(Arrays.copyOf(bytes, i));
        SVMLightParser p = new SVMLightParser(new ParseSetup(ParserType.SVMLight, -1, false, 0, -1, null, null, null, null, null), null);
        SVMLightInspectParseWriter dout = new SVMLightInspectParseWriter();
        try {
            p.streamParse(is, dout);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (dout._ncols > 0 && dout._nlines > 0 && dout._nlines > dout._invalidLines) {
            return new ParseSetup(ParserType.SVMLight, -1, false, -1, dout._ncols, null, dout.guessTypes(), null, null, dout._data);
        }
        throw new H2OParseSetupException("Could not parse file as an SVMLight file.");
    }

    final boolean isWhitespace(byte c) {
        return c == 32 || c == 9;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final ParseWriter parseChunk(int cidx, ParseReader din, ParseWriter dout) {
        _str = new BufferedString();
        bits = din.getChunkData(cidx);
        if (bits == null) {
            return dout;
        }
        bits0 = bits;
        firstChunk = true;
        bits1 = null;
        offset = 0;
        lstate = cidx > 0 ? 0 : 16;
        gstate = 1;
        number = 0L;
        zeros = 0;
        exp = 0;
        sgnExp = 1;
        decimal = false;
        fractionDigits = 0;
        colIdx = 0;
        c = bits[offset];
        if (cidx == 0) {
            while (c == 35) {
                while (offset < bits.length && bits[offset] != 13 && bits[offset] != 10) {
                    ++offset;
                }
                if (offset + 1 < bits.length && bits[offset] == 13 && bits[offset + 1] == 10) {
                    ++offset;
                }
                if (++offset >= bits.length) {
                    return dout;
                }
                c = bits[offset];
            }
        }
        block23: while (true) {
            block0 : switch (lstate) {
                case 0: {
                    if (!SVMLightParser.isEOL((byte)c)) break;
                }
                case 2: {
                    if (colIdx != 0) {
                        colIdx = 0;
                        if (lstate != 0) {
                            dout.newLine();
                        }
                    }
                    if (!firstChunk) break block23;
                    lstate = c == 13 ? 1 : 19;
                    gstate = 1;
                    break;
                }
                case 1: {
                    lstate = 19;
                    if (c != 10) continue block23;
                    break;
                }
                case 19: {
                    if (SVMLightParser.isEOL((byte)c)) {
                        if (c != 13) break;
                        lstate = 1;
                        break;
                    }
                    lstate = 16;
                }
                case 16: {
                    if (this.isWhitespace((byte)c)) break;
                    if (SVMLightParser.isEOL((byte)c)) {
                        lstate = 2;
                        continue block23;
                    }
                }
                case 3: {
                    if ((c < 48 || c > 57) && c != 45 && c != 46 && c != 43) ** GOTO lbl72
                    lstate = 5;
                    number = 0L;
                    fractionDigits = 0;
                    decimal = false;
                    if (c == 45) {
                        exp = -1;
                        break;
                    }
                    if (c == 43) {
                        exp = 1;
                        break;
                    }
                    exp = 1;
                    ** GOTO lbl78
lbl72:
                    // 1 sources

                    if (c == 113) {
                        lstate = 23;
                    } else {
                        dout.invalidLine("Unexpected character, expected number or qid, got '" + new String(Arrays.copyOfRange(bits, offset, Math.min(bits.length, offset + 5))) + "...'");
                        lstate = 0;
                        continue block23;
                    }
                }
lbl78:
                // 3 sources

                case 5: {
                    if (c >= 48 && c <= 57) {
                        if ((number = number * 10L + (long)(c - 48)) < 0xCCCCCCCCCCCCCCCL) break;
                        lstate = 22;
                        break;
                    }
                    if (c == 46) {
                        lstate = 8;
                        fractionDigits = offset;
                        decimal = true;
                        break;
                    }
                    if (c == 101 || c == 69) {
                        lstate = 11;
                        sgnExp = 1;
                        break;
                    }
                    if (exp == -1) {
                        number = -number;
                    }
                    exp = 0;
                }
                case 12: {
                    exp -= fractionDigits;
                    switch (gstate) {
                        case 2: {
                            if (c == 58) {
                                if (exp == 0 && number >= (long)colIdx && (long)((int)number) == number) {
                                    colIdx = (int)number;
                                    gstate = 3;
                                    lstate = 16;
                                    break block0;
                                }
                                err = number <= (long)colIdx ? "Columns come in non-increasing sequence. Got " + number + " after " + colIdx + "." : (exp != 0 ? "Got non-integer as column id: " + (double)number * PrettyPrint.pow10(exp) : "column index out of range, " + number + " does not fit into integer.");
                                dout.invalidLine("invalid column id:" + err);
                                lstate = 0;
                                break block0;
                            }
                            dout.invalidLine("Unexpected character after column id: " + c);
                            lstate = 0;
                            break block0;
                        }
                        case 1: 
                        case 3: {
                            dout.addNumCol(colIdx++, number, exp);
                            lstate = 16;
                            gstate = 2;
                            continue block23;
                        }
                    }
                }
                case 8: {
                    if (c == 48) {
                        ++zeros;
                        break;
                    }
                    if (c > 48 && c <= 57) {
                        if (number < 0xCCCCCCCCCCCCCCCL) {
                            number = number * PrettyPrint.pow10i(zeros + 1) + (long)(c - 48);
                        } else {
                            dout.invalidLine("number " + number + " is out of bounds.");
                            lstate = 0;
                        }
                        zeros = 0;
                        break;
                    }
                    if (c == 101 || c == 69) {
                        if (decimal) {
                            fractionDigits = offset - zeros - 1 - fractionDigits;
                        }
                        lstate = 11;
                        sgnExp = 1;
                        zeros = 0;
                        break;
                    }
                    lstate = 12;
                    if (decimal) {
                        fractionDigits = offset - zeros - fractionDigits - 1;
                    }
                    if (exp == -1) {
                        number = -number;
                    }
                    exp = 0;
                    zeros = 0;
                    continue block23;
                }
                case 11: {
                    if (exp == -1) {
                        number = -number;
                    }
                    exp = 0;
                    if (c == 45) {
                        sgnExp *= -1;
                        break;
                    }
                    if (c == 43) break;
                    if (c < 48 || c > 57) {
                        lstate = 22;
                        continue block23;
                    }
                    lstate = 9;
                }
                case 9: {
                    if (c >= 48 && c <= 57) {
                        exp = exp * 10 + (c - 48);
                        break;
                    }
                    exp *= sgnExp;
                    lstate = 12;
                    continue block23;
                }
                case 22: {
                    if (gstate == 1) {
                        lstate = 0;
                        dout.invalidLine("invalid number (expecting target)");
                        continue block23;
                    }
                    if (gstate == 3) {
                        dout.addInvalidCol(colIdx++);
                        gstate = 2;
                    }
                }
                case 23: {
                    if (c == 105) {
                        lstate = 24;
                        break;
                    }
                    lstate = 21;
                    break;
                }
                case 24: {
                    if (c == 100) {
                        lstate = 21;
                        break;
                    }
                    lstate = 21;
                    break;
                }
                case 21: {
                    if (SVMLightParser.isEOL((byte)c)) {
                        lstate = 2;
                        break;
                    }
                    if (!this.isWhitespace((byte)c)) break;
                    lstate = 16;
                    break;
                }
                default: {
                    if (!SVMLightParser.$assertionsDisabled) {
                        throw new AssertionError((Object)(" We have wrong state " + lstate));
                    }
                    break;
                }
            }
            if (++offset < 0) {
                if (!SVMLightParser.$assertionsDisabled && firstChunk) {
                    throw new AssertionError();
                }
                firstChunk = true;
                bits = bits0;
                _str.set(bits, offset += bits.length, 0);
            } else if (offset >= bits.length) {
                if (firstChunk && bits1 == null) {
                    bits1 = din.getChunkData(cidx + 1);
                }
                if (!firstChunk || bits1 == null) {
                    if (lstate == 1 || lstate == 19) break;
                    c = 10;
                    continue;
                }
                firstChunk = false;
                if (lstate == 8) {
                    fractionDigits -= bits.length;
                }
                offset -= bits.length;
                bits = bits1;
                if (bits[0] == 10 && lstate == 1) break;
            }
            c = bits[offset];
        }
        return dout;
    }

    private static class SVMLightInspectParseWriter
    extends PreviewParseWriter {
        public SVMLightInspectParseWriter() {
            for (int i = 0; i < 10; ++i) {
                this._data[i] = new String[100];
            }
            for (Object[] objectArray : this._data) {
                Arrays.fill(objectArray, "0");
            }
        }

        @Override
        public void addNumCol(int colIdx, long number, int exp) {
            this._ncols = Math.max(this._ncols, colIdx);
            if (colIdx < 100 && this._nlines < 10) {
                this._data[this._nlines][colIdx] = Double.toString((double)number * PrettyPrint.pow10(exp));
            }
        }

        @Override
        public void addNumCol(int colIdx, double d) {
            this._ncols = Math.max(this._ncols, colIdx);
            if (colIdx < 100 && this._nlines < 10) {
                this._data[this._nlines][colIdx] = Double.toString(d);
            }
        }

        @Override
        public byte[] guessTypes() {
            byte[] types = new byte[this._ncols];
            for (int i = 0; i < this._ncols; ++i) {
                types[i] = 3;
            }
            return types;
        }
    }
}

