/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import water.AutoBuffer;
import water.H2O;
import water.Key;
import water.Value;
import water.api.FSIOException;
import water.fvec.NFSFileVec;
import water.persist.Persist;
import water.util.Log;

final class PersistFS
extends Persist {
    final File _root;
    final File _dir;

    PersistFS(File root) {
        this._root = root;
        this._dir = new File(root, "ice" + H2O.API_PORT);
        root.mkdirs();
        if (!(root.isDirectory() && root.canRead() && root.canWrite())) {
            H2O.die("ice_root not a read/writable directory");
        }
    }

    @Override
    public void cleanUp() {
        PersistFS.deleteRecursive(this._dir);
    }

    private static void deleteRecursive(File path) {
        if (!path.exists()) {
            return;
        }
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                PersistFS.deleteRecursive(f);
            }
        }
        path.delete();
    }

    private File getFile(Value v) {
        return new File(this._dir, PersistFS.getIceName(v));
    }

    @Override
    public byte[] load(Value v) throws IOException {
        File f = this.getFile(v);
        if (f.length() < (long)v._max) {
            assert (!v.isPersisted()) : f.length() + " " + v._max + " " + v._key;
            return null;
        }
        FileInputStream s = new FileInputStream(f);
        Throwable throwable = null;
        try {
            AutoBuffer ab = new AutoBuffer(s.getChannel(), true, 1);
            byte[] b = ab.getA1(v._max);
            ab.close();
            byte[] byArray = b;
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (s != null) {
                if (throwable != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    s.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Value v) {
        assert (!v.isPersisted());
        new File(this._dir, PersistFS.getIceDirectory(v._key)).mkdirs();
        FileOutputStream s = null;
        try {
            s = new FileOutputStream(this.getFile(v));
        }
        catch (FileNotFoundException e) {
            throw Log.throwErr(e);
        }
        try {
            byte[] m = v.memOrLoad();
            if (m != null && m.length == v._max) {
                Log.warn("Value size mismatch? " + v._key + " byte[].len=" + m.length + " v._max=" + v._max);
                v._max = m.length;
            }
            new AutoBuffer(s.getChannel(), false, 1).putA1(m, m.length).close();
            v.setdsk();
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void delete(Value v) {
        assert (!v.isPersisted());
        File f = this.getFile(v);
        f.delete();
        if (v.isVec()) {
            f = new File(this._dir.toString(), PersistFS.getIceDirectory(v._key));
            f.delete();
        }
    }

    @Override
    public long getUsableSpace() {
        return this._root.getUsableSpace();
    }

    @Override
    public long getTotalSpace() {
        return this._root.getTotalSpace();
    }

    @Override
    public Key uriToKey(URI uri) {
        return NFSFileVec.make((File)new File((String)uri.toString()))._key;
    }

    @Override
    public ArrayList<String> calcTypeaheadMatches(String src, int limit) {
        assert (false);
        return new ArrayList<String>();
    }

    @Override
    public void importFiles(String path, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        assert (false);
    }

    @Override
    public OutputStream create(String path, boolean overwrite) {
        File f = new File(URI.create(path));
        if (f.exists() && !overwrite) {
            throw new FSIOException(path, "File already exists");
        }
        try {
            return new FileOutputStream(f, false);
        }
        catch (IOException e) {
            throw new FSIOException(path, e);
        }
    }

    @Override
    public Persist.PersistEntry[] list(String path) {
        File f = new File(URI.create(path));
        if (f.isFile()) {
            return new Persist.PersistEntry[]{this.getPersistEntry(f)};
        }
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            Persist.PersistEntry[] entries = new Persist.PersistEntry[files.length];
            for (int i = 0; i < files.length; ++i) {
                entries[i] = this.getPersistEntry(files[i]);
            }
            return entries;
        }
        throw H2O.unimpl();
    }

    @Override
    public InputStream open(String path) {
        try {
            File f = new File(URI.create(path));
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new FSIOException(path, "File not found");
        }
        catch (Exception e) {
            throw new FSIOException(path, e);
        }
    }

    @Override
    public boolean mkdirs(String path) {
        return new File(URI.create(path)).mkdirs();
    }

    @Override
    public boolean exists(String path) {
        return new File(URI.create(path)).exists();
    }

    private Persist.PersistEntry getPersistEntry(File f) {
        return new Persist.PersistEntry(f.getName(), f.length(), f.lastModified());
    }
}

