/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValNum;

class ASTAny
extends ASTPrim {
    ASTAny() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "any";
    }

    @Override
    ValNum apply(Env env, Env.StackHelp stk, AST[] asts) {
        Val val = stk.track(asts[1].exec(env));
        if (val.isNum()) {
            return new ValNum(val.getNum() == 0.0 ? 0.0 : 1.0);
        }
        for (Vec vec : val.getFrame().vecs()) {
            if (vec.nzCnt() + vec.naCnt() <= 0L) continue;
            return new ValNum(1.0);
        }
        return new ValNum(0.0);
    }
}

