/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTFrame;
import water.rapids.ASTFun;
import water.rapids.ASTPrim;
import water.rapids.ASTRow;
import water.rapids.Env;
import water.rapids.Session;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTApply
extends ASTPrim {
    ASTApply() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "margin", "fun"};
    }

    @Override
    int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "apply";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        double margin = stk.track(asts[2].exec(env)).getNum();
        AST fun = stk.track(asts[3].exec(env)).getFun();
        int nargs = fun.nargs();
        if (nargs != -1 && nargs != 2) {
            throw new IllegalArgumentException("Incorrect number of arguments; '" + fun + "' expects " + nargs + " but was passed " + 2);
        }
        switch ((int)margin) {
            case 1: {
                return this.rowwise(env, fr, fun);
            }
            case 2: {
                return this.colwise(env, stk, fr, fun);
            }
        }
        throw new IllegalArgumentException("Only row-wise (margin 1) or col-wise (margin 2) allowed");
    }

    private Val colwise(Env env, Env.StackHelp stk, Frame fr, AST fun) {
        Vec[] vecs = fr.vecs();
        Val[] vals = new Val[vecs.length];
        AST[] asts = new AST[]{fun, null};
        for (int i = 0; i < vecs.length; ++i) {
            asts[1] = new ASTFrame(new Frame(new String[]{fr._names[i]}, new Vec[]{vecs[i]}));
            Env.StackHelp stk_inner = env.stk();
            Throwable throwable = null;
            try {
                vals[i] = fun.apply(env, stk_inner, asts);
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stk_inner != null) {
                    if (throwable != null) {
                        try {
                            stk_inner.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        stk_inner.close();
                    }
                }
            }
        }
        Val v0 = vals[0];
        Vec[] ovecs = new Vec[vecs.length];
        switch (v0.type()) {
            case 1: {
                for (int i = 0; i < vecs.length; ++i) {
                    ovecs[i] = Vec.makeCon(vals[i].getNum(), 1L);
                }
                break;
            }
            case 5: {
                long nrows = v0.getFrame().numRows();
                for (int i = 0; i < vecs.length; ++i) {
                    Frame res = vals[i].getFrame();
                    if (res.numCols() != 1) {
                        throw new IllegalArgumentException("apply result Frames must have one column, found " + res.numCols() + " cols");
                    }
                    if (res.numRows() != nrows) {
                        throw new IllegalArgumentException("apply result Frames must have all the same rows, found " + nrows + " rows and " + res.numRows());
                    }
                    ovecs[i] = res.vec(0);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < vecs.length; ++i) {
                    ovecs[i] = Vec.makeCon(vals[i].getNums()[0], 1L);
                }
                break;
            }
            case 4: {
                throw H2O.unimpl();
            }
            case 7: {
                throw H2O.unimpl();
            }
            case 3: {
                throw H2O.unimpl();
            }
            default: {
                throw H2O.unimpl();
            }
        }
        return new ValFrame(new Frame(fr._names, ovecs));
    }

    private Val rowwise(Env env, Frame fr, final AST fun) {
        final String[] names = fr._names;
        final ASTFun scope = env._scope;
        double[] ds = new double[fr.numCols()];
        for (int col = 0; col < fr.numCols(); ++col) {
            ds[col] = fr.vec(col).at(0L);
        }
        int noutputs = fun.apply(env, env.stk(), new AST[]{fun, new ASTRow(ds, fr.names())}).getRow().length;
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] nc) {
                double[] ds = new double[chks.length];
                AST[] asts = new AST[]{fun, new ASTRow(ds, names)};
                Session ses = new Session();
                Env env = new Env(ses);
                env._scope = scope;
                for (int row = 0; row < chks[0]._len; ++row) {
                    for (int col = 0; col < chks.length; ++col) {
                        ds[col] = chks[col].atd(row);
                    }
                    Env.StackHelp stk_inner = env.stk();
                    Throwable throwable = null;
                    try {
                        double[] valRow = fun.apply(env, stk_inner, asts).getRow();
                        for (int newCol = 0; newCol < nc.length; ++newCol) {
                            nc[newCol].addNum(valRow[newCol]);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stk_inner != null) {
                            if (throwable != null) {
                                try {
                                    stk_inner.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                stk_inner.close();
                            }
                        }
                    }
                }
                ses.end(null);
            }
        }.doAll(noutputs, (byte)3, fr)).outputFrame();
        return new ValFrame(res);
    }
}

