/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.fvec.Frame;
import water.rapids.AST;
import water.rapids.ASTNum;
import water.rapids.ASTNumList;
import water.rapids.ASTPrim;
import water.rapids.ASTStrList;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTColNames
extends ASTPrim {
    ASTColNames() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "cols", "names"};
    }

    @Override
    int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "colnames=";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (asts[2] instanceof ASTNumList) {
            if (!(asts[3] instanceof ASTStrList)) {
                throw new IllegalArgumentException("Column naming requires a string-list, but found a " + asts[3].getClass());
            }
            ASTNumList cols = (ASTNumList)asts[2];
            ASTStrList nams = (ASTStrList)asts[3];
            int[] d = cols.expand4();
            if (d.length != nams._strs.length) {
                throw new IllegalArgumentException("Must have the same number of column choices as names");
            }
            for (int i = 0; i < d.length; ++i) {
                fr._names[d[i]] = nams._strs[i];
            }
        } else if (asts[2] instanceof ASTNum) {
            String name;
            int col = (int)asts[2].exec(env).getNum();
            fr._names[col] = name = asts[3].exec(env).getStr();
        } else {
            throw new IllegalArgumentException("Column naming requires a number-list, but found a " + asts[2].getClass());
        }
        if (fr._key != null) {
            DKV.put(fr);
        }
        return new ValFrame(fr);
    }
}

