/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTNum;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValRow;

class ASTColPySlice
extends ASTPrim {
    ASTColPySlice() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "cols"};
    }

    @Override
    int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "cols_py";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Val v = stk.track(asts[1].exec(env));
        if (v instanceof ValRow) {
            ValRow vv = (ValRow)v;
            return vv.slice(asts[2].columns(vv._names));
        }
        Frame fr = v.getFrame();
        int[] cols = asts[2].columns(fr.names());
        Frame fr2 = new Frame(new Vec[0]);
        if (cols.length == 0) {
            return new ValFrame(fr2);
        }
        if (cols[0] < 0) {
            int i = 0;
            while (i < cols.length) {
                int n = i++;
                cols[n] = cols[n] + fr.numCols();
            }
        }
        if (asts[2] instanceof ASTNum && (cols[0] < 0 || cols[0] >= fr.numCols())) {
            throw new IllegalArgumentException("Column must be an integer from 0 to " + (fr.numCols() - 1));
        }
        for (int col : cols) {
            if (col < 0 || col >= fr.numCols()) continue;
            fr2.add(fr.names()[col], fr.vecs()[col]);
        }
        return new ValFrame(fr2);
    }
}

