/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValRow;

class ASTColSlice
extends ASTPrim {
    ASTColSlice() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "cols"};
    }

    @Override
    int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "cols";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Val v = stk.track(asts[1].exec(env));
        if (v instanceof ValRow) {
            ValRow vv = (ValRow)v;
            return vv.slice(asts[2].columns(vv._names));
        }
        Frame src = v.getFrame();
        int[] cols = ASTColSlice.col_select(src.names(), asts[2]);
        Frame dst = new Frame(new Vec[0]);
        Vec[] vecs = src.vecs();
        for (int col : cols) {
            dst.add(src._names[col], vecs[col]);
        }
        return new ValFrame(dst);
    }

    static int[] col_select(String[] names, AST col_selector) {
        int[] cols = col_selector.columns(names);
        if (cols.length == 0) {
            return cols;
        }
        if (cols[0] >= 0) {
            if (cols[cols.length - 1] >= names.length) {
                throw new IllegalArgumentException("Column must be an integer from 0 to " + (names.length - 1));
            }
            return cols;
        }
        int[] pos = new int[names.length];
        for (int col : cols) {
            if (0 > -col - 1 || -col - 1 >= names.length) continue;
            pos[-col - 1] = -1;
        }
        int j = 0;
        for (int i = 0; i < names.length; ++i) {
            if (pos[i] != 0) continue;
            pos[j++] = i;
        }
        return Arrays.copyOfRange(pos, 0, j);
    }
}

