/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.ValFrame;
import water.util.ArrayUtils;

abstract class ASTCumu
extends ASTPrim {
    ASTCumu() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public String str() {
        throw H2O.unimpl();
    }

    abstract double op(double var1, double var3);

    abstract double init();

    @Override
    ValFrame apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame f = stk.track(asts[1].exec(env)).getFrame();
        if (f.numCols() != 1) {
            throw new IllegalArgumentException("Must give a single numeric column.");
        }
        if (!f.anyVec().isNumeric()) {
            throw new IllegalArgumentException("Column must be numeric.");
        }
        CumuTask t = new CumuTask(f.anyVec().nChunks(), this.init());
        t.doAll(new byte[]{3}, f.anyVec());
        final double[] chkCumu = t._chkCumu;
        Vec cumuVec = t.outputFrame().anyVec();
        new MRTask(){

            @Override
            public void map(Chunk c) {
                if (c.cidx() != 0) {
                    double d = chkCumu[c.cidx() - 1];
                    for (int i = 0; i < c._len; ++i) {
                        c.set(i, ASTCumu.this.op(c.atd(i), d));
                    }
                }
            }
        }.doAll(cumuVec);
        return new ValFrame(new Frame(cumuVec));
    }

    protected class CumuTask
    extends MRTask<CumuTask> {
        final int _nchks;
        final double _init;
        double[] _chkCumu;

        CumuTask(int nchks, double init) {
            this._nchks = nchks;
            this._init = init;
        }

        @Override
        public void setupLocal() {
            this._chkCumu = new double[this._nchks];
        }

        @Override
        public void map(Chunk c, NewChunk nc) {
            double acc = this._init;
            for (int i = 0; i < c._len; ++i) {
                acc = ASTCumu.this.op(acc, c.atd(i));
                nc.addNum(acc);
            }
            this._chkCumu[c.cidx()] = acc;
        }

        @Override
        public void reduce(CumuTask t) {
            if (this._chkCumu != t._chkCumu) {
                ArrayUtils.add(this._chkCumu, t._chkCumu);
            }
        }

        @Override
        public void postGlobal() {
            for (int i = 1; i < this._chkCumu.length; ++i) {
                this._chkCumu[i] = ASTCumu.this.op(this._chkCumu[i], this._chkCumu[i - 1]);
            }
        }
    }
}

