/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.ValFrame;

class ASTFilterNACols
extends ASTPrim {
    ASTFilterNACols() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "fraction"};
    }

    @Override
    int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "filterNACols";
    }

    @Override
    ValFrame apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        double frac = asts[2].exec(env).getNum();
        double nrow = (double)fr.numRows() * frac;
        Vec[] vecs = fr.vecs();
        long[] idxs = new long[fr.numCols()];
        int j = 0;
        for (int i = 0; i < idxs.length; ++i) {
            if (!((double)vecs[i].naCnt() < nrow)) continue;
            idxs[j++] = i;
        }
        Vec vec = Vec.makeVec(Arrays.copyOf(idxs, j), null, Vec.VectorGroup.VG_LEN1.addVec());
        return new ValFrame(new Frame(vec));
    }
}

