/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValNum;
import water.rapids.ValStr;

class ASTFlatten
extends ASTPrim {
    ASTFlatten() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "flatten";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() != 1 || fr.numRows() != 1L) {
            return new ValFrame(fr);
        }
        Vec vec = fr.anyVec();
        if (vec.isNumeric() || vec.isBad()) {
            return new ValNum(vec.at(0L));
        }
        return new ValStr(vec.isString() ? vec.atStr(new BufferedString(), 0L).toString() : vec.factor(vec.at8(0L)));
    }
}

