/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import water.rapids.AST;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.Val;
import water.rapids.ValFun;
import water.util.SB;

class ASTFun
extends AST {
    final String[] _ids;
    final AST _body;
    final Val[] _args;
    final ASTFun _parent;

    protected ASTFun(Exec e) {
        e.xpeek('{');
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("");
        while (e.skipWS() != '.') {
            String id = e.token();
            if (!Character.isJavaIdentifierStart(id.charAt(0))) {
                throw new Exec.IllegalASTException("variable must be a valid Java identifier: " + id);
            }
            for (char c : id.toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                throw new Exec.IllegalASTException("variable must be a valid Java identifier: " + id);
            }
            ids.add(id);
        }
        e.xpeek('.');
        this._ids = ids.toArray(new String[ids.size()]);
        this._body = e.parse();
        this._args = null;
        this._parent = null;
        e.skipWS();
        e.xpeek('}');
    }

    @Override
    public String str() {
        SB sb = new SB().p('{');
        this.penv(sb);
        for (String id : this._ids) {
            sb.p(id).p(' ');
        }
        sb.p(". ").p(this._body.toString()).p('}');
        return sb.toString();
    }

    private void penv(SB sb) {
        if (this._parent != null) {
            this._parent.penv(sb);
        }
        if (this._args != null) {
            for (int i = 1; i < this._ids.length; ++i) {
                sb.p(this._ids[i]).p('=').p(this._args[i].toString()).p(' ');
            }
        }
    }

    @Override
    public Val exec(Env env) {
        return new ValFun(new ASTFun(this, null, env._scope));
    }

    @Override
    int nargs() {
        return this._ids.length;
    }

    ASTFun(ASTFun fun, Val[] args, ASTFun parent) {
        this._ids = fun._ids;
        this._body = fun._body;
        this._parent = parent;
        this._args = args;
    }

    Val lookup(String id) {
        for (int i = 1; i < this._ids.length; ++i) {
            if (!id.equals(this._ids[i])) continue;
            return this._args[i];
        }
        return this._parent == null ? null : this._parent.lookup(id);
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Val[] args = new Val[asts.length];
        for (int i = 1; i < asts.length; ++i) {
            args[i] = stk.track(asts[i].exec(env));
        }
        ASTFun old = env._scope;
        env._scope = new ASTFun(this, args, this._parent);
        Val res = stk.untrack(this._body.exec(env));
        env._scope = old;
        return res;
    }
}

