/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValNum;
import water.rapids.ValRow;
import water.util.ArrayUtils;
import water.util.VecUtils;

class ASTIfElse
extends ASTPrim {
    ASTIfElse() {
    }

    @Override
    public String[] args() {
        return new String[]{"test", "true", "false"};
    }

    @Override
    int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "ifelse";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Object[] dom;
        Val val = stk.track(asts[1].exec(env));
        if (val.isNum()) {
            double d = val.getNum();
            if (Double.isNaN(d)) {
                return new ValNum(Double.NaN);
            }
            Val res = stk.track(asts[d == 0.0 ? 3 : 2].exec(env));
            return res.isFrame() ? new ValNum(res.getFrame().vec(0).at(0L)) : res;
        }
        if (val.type() == 6) {
            return this.row_ifelse((ValRow)val, asts[2].exec(env), asts[3].exec(env));
        }
        Frame tst = val.getFrame();
        Frame fr = new Frame(tst);
        Val tval = null;
        for (Vec vec : tst.vecs()) {
            if (vec.min() == 0.0 && vec.max() == 0.0) continue;
            tval = this.exec_check(env, stk, tst, asts[2], fr);
            break;
        }
        final boolean has_tfr = tval != null && tval.isFrame();
        final String ts = tval != null && tval.isStr() ? tval.getStr() : null;
        final double td = tval != null && tval.isNum() ? tval.getNum() : Double.NaN;
        final int[] tsIntMap = new int[tst.numCols()];
        Val fval = null;
        for (Vec vec : tst.vecs()) {
            if (vec.nzCnt() + vec.naCnt() >= vec.length()) continue;
            fval = this.exec_check(env, stk, tst, asts[3], fr);
            break;
        }
        final boolean has_ffr = fval != null && fval.isFrame();
        final String fs = fval != null && fval.isStr() ? fval.getStr() : null;
        final double fd = fval != null && fval.isNum() ? fval.getNum() : Double.NaN;
        final int[] fsIntMap = new int[tst.numCols()];
        String[][] domains = null;
        final int[][] maps = new int[tst.numCols()][];
        if (fs != null || ts != null) {
            Vec v;
            int i;
            domains = new String[tst.numCols()][];
            if (fs != null && ts != null) {
                for (i = 0; i < tst.numCols(); ++i) {
                    domains[i] = new String[]{fs, ts};
                    fsIntMap[i] = 0;
                    tsIntMap[i] = 1;
                }
            } else if (ts != null) {
                for (i = 0; i < tst.numCols(); ++i) {
                    if (has_ffr) {
                        v = fr.vec(i + tst.numCols() + (has_tfr ? tst.numCols() : 0));
                        if (!v.isCategorical()) {
                            throw H2O.unimpl("Column is not categorical.");
                        }
                    } else {
                        throw H2O.unimpl();
                    }
                    dom = Arrays.copyOf(v.domain(), v.domain().length + 1);
                    dom[dom.length - 1] = ts;
                    Arrays.sort(dom);
                    maps[i] = ASTIfElse.computeMap(v.domain(), (String[])dom);
                    tsIntMap[i] = ArrayUtils.find(dom, ts);
                    domains[i] = dom;
                }
            } else {
                for (i = 0; i < tst.numCols(); ++i) {
                    if (has_tfr) {
                        v = fr.vec(i + tst.numCols() + (has_ffr ? tst.numCols() : 0));
                        if (!v.isCategorical()) {
                            throw H2O.unimpl("Column is not categorical.");
                        }
                    } else {
                        throw H2O.unimpl();
                    }
                    dom = Arrays.copyOf(v.domain(), v.domain().length + 1);
                    dom[dom.length - 1] = fs;
                    Arrays.sort(dom);
                    maps[i] = ASTIfElse.computeMap(v.domain(), (String[])dom);
                    fsIntMap[i] = ArrayUtils.find(dom, fs);
                    domains[i] = dom;
                }
            }
        }
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] nchks) {
                assert (nchks.length + (has_tfr ? nchks.length : 0) + (has_ffr ? nchks.length : 0) == chks.length);
                for (int i = 0; i < nchks.length; ++i) {
                    Chunk ctst = chks[i];
                    NewChunk res = nchks[i];
                    for (int row = 0; row < ctst._len; ++row) {
                        double d = ctst.isNA(row) ? Double.NaN : (ctst.atd(row) == 0.0 ? (has_ffr ? ASTIfElse.domainMap(chks[i + nchks.length + (has_tfr ? nchks.length : 0)].atd(row), maps[i]) : (fs != null ? (double)fsIntMap[i] : fd)) : (has_tfr ? ASTIfElse.domainMap(chks[i + nchks.length].atd(row), maps[i]) : (ts != null ? (double)tsIntMap[i] : td)));
                        res.addNum(d);
                    }
                }
            }
        }.doAll(tst.numCols(), (byte)3, fr)).outputFrame(null, domains);
        if (domains != null) {
            for (int i = 0; i < res.numCols(); ++i) {
                if (res.vec(i).domain() == null) continue;
                dom = ((VecUtils.CollectDomainFast)new VecUtils.CollectDomainFast((int)res.vec(i).max()).doAll(res.vec(i))).domain();
                String[] newDomain = new String[dom.length];
                for (int l = 0; l < dom.length; ++l) {
                    newDomain[l] = res.vec(i).domain()[(int)dom[l]];
                }
                new MRTask((long[])dom){
                    final /* synthetic */ long[] val$dom;
                    {
                        this.val$dom = lArray;
                    }

                    @Override
                    public void map(Chunk c) {
                        for (int i = 0; i < c._len; ++i) {
                            c.set(i, ArrayUtils.find(this.val$dom, c.at8(i)));
                        }
                    }
                }.doAll(res.vec(i));
                res.vec(i).setDomain(newDomain);
            }
        }
        return new ValFrame(res);
    }

    private static double domainMap(double d, int[] maps) {
        if (maps != null && d == (double)((int)d) && 0.0 <= d && d < (double)maps.length) {
            return maps[(int)d];
        }
        return d;
    }

    private static int[] computeMap(String[] from, String[] to) {
        int[] map = new int[from.length];
        for (int i = 0; i < from.length; ++i) {
            map[i] = ArrayUtils.find(to, from[i]);
        }
        return map;
    }

    Val exec_check(Env env, Env.StackHelp stk, Frame tst, AST ast, Frame xfr) {
        Val val = ast.exec(env);
        if (val.isFrame()) {
            Frame fr = stk.track(val).getFrame();
            if (tst.numCols() != fr.numCols() || tst.numRows() != fr.numRows()) {
                throw new IllegalArgumentException("ifelse test frame and other frames must match dimensions, found " + tst + " and " + fr);
            }
            xfr.add(fr);
        }
        return val;
    }

    ValRow row_ifelse(ValRow tst, Val yes, Val no) {
        double[] False;
        double[] True;
        double[] test = tst.getRow();
        if (!yes.isRow() && !no.isRow()) {
            throw H2O.unimpl();
        }
        switch (yes.type()) {
            case 1: {
                True = new double[]{yes.getNum()};
                break;
            }
            case 6: {
                True = yes.getRow();
                break;
            }
            default: {
                throw H2O.unimpl("row ifelse unimpl: " + yes.getClass());
            }
        }
        switch (no.type()) {
            case 1: {
                False = new double[]{no.getNum()};
                break;
            }
            case 6: {
                False = no.getRow();
                break;
            }
            default: {
                throw H2O.unimpl("row ifelse unimplL " + no.getClass());
            }
        }
        double[] ds = new double[test.length];
        String[] ns = new String[test.length];
        for (int i = 0; i < test.length; ++i) {
            ns[i] = "C" + (i + 1);
            ds[i] = Double.isNaN(test[i]) ? Double.NaN : (test[i] == 0.0 ? False[i] : True[i]);
        }
        return new ValRow(ds, ns);
    }
}

