/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import hex.quantile.QuantileModel;
import java.util.Arrays;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTFrame;
import water.rapids.ASTGroup;
import water.rapids.ASTMean;
import water.rapids.ASTMedian;
import water.rapids.ASTMode;
import water.rapids.ASTNum;
import water.rapids.ASTNumList;
import water.rapids.ASTPrim;
import water.rapids.ASTStr;
import water.rapids.ASTStrList;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.util.ArrayUtils;
import water.util.IcedDouble;
import water.util.IcedHashMap;

public class ASTImpute
extends ASTPrim {
    @Override
    public String[] args() {
        return new String[]{"ary", "col", "method", "combineMethod", "groupByCols"};
    }

    @Override
    public String str() {
        return "h2o.impute";
    }

    @Override
    int nargs() {
        return 6;
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        IcedHashMap group_impute_map;
        ASTNumList by2;
        ASTPrim method;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        final int col = (int)asts[2].exec(env).getNum();
        if (col < 0 || col >= fr.numCols()) {
            throw new IllegalArgumentException("Column not in range 0 to " + fr.numCols());
        }
        Vec vec = fr.vec(col);
        String string = asts[3].exec(env).getStr().toUpperCase();
        int n = -1;
        switch (string.hashCode()) {
            case 2362309: {
                if (!string.equals("MEAN")) break;
                n = 0;
                break;
            }
            case -2024701686: {
                if (!string.equals("MEDIAN")) break;
                n = 1;
                break;
            }
            case 2372003: {
                if (!string.equals("MODE")) break;
                n = 2;
            }
        }
        switch (n) {
            case 0: {
                method = new ASTMean();
                break;
            }
            case 1: {
                method = new ASTMedian();
                break;
            }
            case 2: {
                method = new ASTMode();
                break;
            }
            default: {
                throw new IllegalArgumentException("Method must be one of mean, median or mode");
            }
        }
        QuantileModel.CombineMethod combine = QuantileModel.CombineMethod.valueOf(asts[4].exec(env).getStr().toUpperCase());
        AST ast = asts[5];
        if (ast instanceof ASTNumList) {
            by2 = (ASTNumList)ast;
        } else if (ast instanceof ASTNum) {
            by2 = new ASTNumList(((ASTNum)ast)._v.getNum());
        } else if (ast instanceof ASTStrList) {
            String[] names = ((ASTStrList)ast)._strs;
            double[] list = new double[names.length];
            int i = 0;
            for (String name : ((ASTStrList)ast)._strs) {
                list[i++] = fr.find(name);
            }
            Arrays.sort(list);
            by2 = new ASTNumList(list);
        } else {
            throw new IllegalArgumentException("Requires a number-list, but found a " + ast.getClass());
        }
        ASTNumList by = by2;
        if (by.isEmpty()) {
            double res = Double.NaN;
            if (method instanceof ASTMean) {
                res = vec.mean();
            }
            if (method instanceof ASTMedian) {
                res = ASTMedian.median(new Frame(vec), combine);
            }
            if (method instanceof ASTMode) {
                res = ASTMode.mode(vec);
            }
            group_impute_map = new IcedHashMap();
            group_impute_map.put(new ASTGroup.G(0, null).fill(0, null, new int[0]), new IcedDouble(res));
        } else {
            ASTGroup ast_grp = new ASTGroup();
            Frame imputes = ((AST)ast_grp).apply(env, stk, new AST[]{ast_grp, new ASTFrame(fr), by, method, new ASTNumList(col, col + 1), new ASTStr("rm")}).getFrame();
            int[] bycols = ArrayUtils.seq(0, imputes.numCols() - 1);
            group_impute_map = ((Gather)new Gather(bycols).doAll(imputes))._group_impute_map;
            imputes.delete();
        }
        env._ses.copyOnWrite(fr, new int[]{col});
        final IcedHashMap final_group_impute_map = group_impute_map;
        final int[] bycols = by.expand4();
        new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                Chunk x = cs[col];
                ASTGroup.G g = new ASTGroup.G(bycols.length, null);
                for (int row = 0; row < x._len; ++row) {
                    if (!x.isNA(row)) continue;
                    x.set(row, ((IcedDouble)final_group_impute_map.get((Object)g.fill((int)row, (Chunk[])cs, (int[])bycols)))._val);
                }
            }
        }.doAll(fr);
        return new ValFrame(fr);
    }

    private static class Gather
    extends MRTask<Gather> {
        private final int[] _bycols;
        private IcedHashMap<ASTGroup.G, IcedDouble> _group_impute_map;

        Gather(int[] bycols) {
            this._bycols = bycols;
        }

        @Override
        public void map(Chunk[] cs) {
            this._group_impute_map = new IcedHashMap();
            Chunk means = cs[cs.length - 1];
            for (int i = 0; i < cs[0]._len; ++i) {
                this._group_impute_map.put(new ASTGroup.G(cs.length - 1, null).fill(i, cs, this._bycols), new IcedDouble(means.atd(i)));
            }
        }

        @Override
        public void reduce(Gather mrt) {
            this._group_impute_map.putAll(mrt._group_impute_map);
        }
    }
}

