/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import hex.quantile.QuantileModel;
import water.DKV;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTMedian;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.ValNum;

class ASTMad
extends ASTPrim {
    ASTMad() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "combineMethod", "const"};
    }

    @Override
    int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "h2o.mad";
    }

    @Override
    ValNum apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        Vec[] vecs = fr.vecs();
        if (vecs.length == 0 || vecs[0].naCnt() > 0L) {
            return new ValNum(Double.NaN);
        }
        if (vecs.length > 1) {
            throw new IllegalArgumentException("MAD expects a single numeric column");
        }
        QuantileModel.CombineMethod cm = QuantileModel.CombineMethod.valueOf(asts[2].exec(env).getStr().toUpperCase());
        double constant = asts[3].exec(env).getNum();
        return new ValNum(ASTMad.mad(fr, cm, constant));
    }

    static double mad(Frame f, QuantileModel.CombineMethod cm, double constant) {
        Key tk = null;
        if (f._key == null) {
            tk = Key.make();
            f = new Frame(tk, f.names(), f.vecs());
            DKV.put(tk, f);
        }
        final double median = ASTMedian.median(f, cm);
        Frame abs_dev = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk nc) {
                for (int i = 0; i < c._len; ++i) {
                    nc.addNum(Math.abs((double)c.at8(i) - median));
                }
            }
        }.doAll(1, (byte)3, f)).outputFrame();
        if (abs_dev._key == null) {
            tk = Key.make();
            abs_dev = new Frame(tk, abs_dev.names(), abs_dev.vecs());
            DKV.put(tk, abs_dev);
        }
        double mad = ASTMedian.median(abs_dev, cm);
        DKV.remove(f._key);
        DKV.remove(abs_dev._key);
        return constant * mad;
    }
}

