/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.AST;
import water.rapids.ASTNum;
import water.rapids.ASTNumList;
import water.rapids.ASTPrim;
import water.rapids.ASTStr;
import water.rapids.ASTStrList;
import water.rapids.Env;
import water.rapids.ValFrame;
import water.util.MathUtils;

class ASTMatch
extends ASTPrim {
    ASTMatch() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "table", "nomatch", "incomparables"};
    }

    @Override
    int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "match";
    }

    @Override
    ValFrame apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() != 1 && !fr.anyVec().isCategorical()) {
            throw new IllegalArgumentException("can only match on a single categorical column.");
        }
        String[] _strsTable = null;
        double[] _dblsTable = null;
        if (asts[2] instanceof ASTNumList) {
            _dblsTable = ((ASTNumList)asts[2]).expand();
        } else if (asts[2] instanceof ASTNum) {
            _dblsTable = new double[]{asts[2].exec(env).getNum()};
        } else if (asts[2] instanceof ASTStrList) {
            _strsTable = ((ASTStrList)asts[2])._strs;
        } else if (asts[2] instanceof ASTStr) {
            _strsTable = new String[]{asts[2].exec(env).getStr()};
        } else {
            throw new IllegalArgumentException("Expected numbers/strings. Got: " + asts[2].getClass());
        }
        final String[] strsTable = _strsTable;
        final double[] dblsTable = _dblsTable;
        Frame rez = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk n) {
                int rows = c._len;
                if (strsTable == null) {
                    for (int r = 0; r < rows; ++r) {
                        n.addNum(c.isNA(r) ? 0L : (long)ASTMatch.in(dblsTable, c.atd(r)), 0);
                    }
                } else {
                    for (int r = 0; r < rows; ++r) {
                        n.addNum(c.isNA(r) ? 0L : (long)ASTMatch.in(strsTable, c.vec().domain()[(int)c.at8(r)]), 0);
                    }
                }
            }
        }.doAll(new byte[]{3}, fr.anyVec())).outputFrame();
        return new ValFrame(rez);
    }

    private static int in(String[] matches, String s) {
        return Arrays.binarySearch(matches, s) >= 0 ? 1 : 0;
    }

    private static int in(double[] matches, double d) {
        return ASTMatch.binarySearchDoublesUlp(matches, 0, matches.length, d) >= 0 ? 1 : 0;
    }

    private static int binarySearchDoublesUlp(double[] a, int from, int to, double key) {
        int lo = from;
        int hi = to - 1;
        while (lo <= hi) {
            long keyBits;
            int mid = lo + hi >>> 1;
            double midVal = a[mid];
            if (MathUtils.equalsWithinOneSmallUlp(midVal, key)) {
                return mid;
            }
            if (midVal < key) {
                lo = mid + 1;
                continue;
            }
            if (midVal > key) {
                hi = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        return -(lo + 1);
    }
}

