/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.H2O;
import water.Iced;
import water.Key;
import water.MRTask;
import water.fvec.C16Chunk;
import water.fvec.CStrChunk;
import water.fvec.CategoricalWrappedVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.util.IcedHashMap;

public class ASTMerge
extends ASTPrim {
    static final int MAX_HASH_SIZE = 120000000;

    @Override
    public String[] args() {
        return new String[]{"left", "rite", "all_left", "all_rite"};
    }

    @Override
    public String str() {
        return "merge";
    }

    @Override
    int nargs() {
        return 5;
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame hashed;
        boolean walkLeft;
        Frame l = stk.track(asts[1].exec(env)).getFrame();
        Frame r = stk.track(asts[2].exec(env)).getFrame();
        boolean allLeft = asts[3].exec(env).getNum() == 1.0;
        boolean allRite = asts[4].exec(env).getNum() == 1.0;
        int ncols = 0;
        for (int i = 0; i < l._names.length; ++i) {
            int idx = r.find(l._names[i]);
            if (idx == -1) continue;
            l.swap(i, ncols);
            r.swap(idx, ncols);
            Vec lv = l.vecs()[ncols];
            Vec rv = r.vecs()[ncols];
            if (lv.get_type() != rv.get_type()) {
                throw new IllegalArgumentException("Merging columns must be the same type, column " + l._names[ncols] + " found types " + lv.get_type_str() + " and " + rv.get_type_str());
            }
            if (lv.isString()) {
                throw new IllegalArgumentException("Cannot merge Strings; flip toCategoricalVec first");
            }
            if (lv.isNumeric() && !lv.isInt()) {
                throw new IllegalArgumentException("Equality tests on doubles rarely work, please round to integers only before merging");
            }
            ++ncols;
        }
        if (ncols == 0) {
            throw new IllegalArgumentException("Frames must have at least one column in common to merge them");
        }
        if (allLeft == allRite) {
            int i;
            long lsize = 0L;
            long rsize = 0L;
            for (i = ncols; i < l.numCols(); ++i) {
                lsize += l.vecs()[i].byteSize();
            }
            for (i = ncols; i < r.numCols(); ++i) {
                rsize += r.vecs()[i].byteSize();
            }
            walkLeft = lsize > rsize;
        } else {
            walkLeft = allLeft;
        }
        Frame walked = walkLeft ? l : r;
        Frame frame = hashed = walkLeft ? r : l;
        if (!walkLeft) {
            boolean tmp = allLeft;
            allLeft = allRite;
            allRite = tmp;
        }
        int[][] id_maps = new int[ncols][];
        for (int i = 0; i < ncols; ++i) {
            Vec lv = walked.vecs()[i];
            if (!lv.isCategorical()) continue;
            id_maps[i] = CategoricalWrappedVec.computeMap(hashed.vecs()[i].domain(), lv.domain());
        }
        MergeSet ms = (MergeSet)new MergeSet(ncols, id_maps, allRite).doAll(hashed);
        final Key uniq = ms._uniq;
        IcedHashMap<Row, String> rows = ((MergeSet)MergeSet.MERGE_SETS.get((Object)uniq))._rows;
        new MRTask(){

            @Override
            public void setupLocal() {
                MergeSet.MERGE_SETS.remove(uniq);
            }
        }.doAllNodes();
        if (rows == null) {
            return this.sortingMerge(walked, hashed, allLeft, allRite, ncols, id_maps);
        }
        if (!(!allLeft || allRite && ms._dup)) {
            walked = walked.deepCopy(null);
            String[] names = Arrays.copyOfRange(hashed._names, ncols, hashed._names.length);
            String[][] domains = (String[][])Arrays.copyOfRange(hashed.domains(), ncols, hashed.domains().length);
            byte[] types = Arrays.copyOfRange(hashed.types(), ncols, hashed.numCols());
            Frame res = ((JoinTask)new AllLeftNoDupe(ncols, rows, hashed, allRite).doAll(types, walked)).outputFrame(names, domains);
            return new ValFrame(walked.add(res));
        }
        if (!allRite) {
            String[] names = Arrays.copyOf(walked.names(), walked.numCols() + hashed.numCols() - ncols);
            System.arraycopy(hashed.names(), ncols, names, walked.numCols(), hashed.numCols() - ncols);
            String[][] domains = (String[][])Arrays.copyOf(walked.domains(), walked.numCols() + hashed.numCols() - ncols);
            System.arraycopy(hashed.domains(), ncols, domains, walked.numCols(), hashed.numCols() - ncols);
            byte[] types = walked.types();
            types = Arrays.copyOf(types, types.length + hashed.numCols() - ncols);
            System.arraycopy(hashed.types(), ncols, types, walked.numCols(), hashed.numCols() - ncols);
            return new ValFrame(((JoinTask)new AllRiteWithDupJoin(ncols, rows, hashed, allLeft).doAll(types, walked)).outputFrame(names, domains));
        }
        throw H2O.unimpl();
    }

    private ValFrame sortingMerge(Frame walked, Frame hashed, boolean allLeft, boolean allRite, int ncols, int[][] id_maps) {
        throw H2O.unimpl();
    }

    private static class AllRiteWithDupJoin
    extends JoinTask {
        AllRiteWithDupJoin(int ncols, IcedHashMap<Row, String> rows, Frame hashed, boolean allLeft) {
            super(ncols, rows, hashed, allLeft, true);
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] nchks) {
            IcedHashMap rows = this._rows;
            Vec[] vecs = this._hashed.vecs();
            assert (vecs.length == this._ncols + nchks.length);
            Row row = new Row(this._ncols);
            BufferedString bStr = new BufferedString();
            int len = chks[0]._len;
            for (int i = 0; i < len; ++i) {
                Row hashed = rows.getk(row.fill(chks, null, i));
                if (hashed == null) {
                    int c;
                    if (!this._allLeft) continue;
                    for (c = 0; c < chks.length; ++c) {
                        AllRiteWithDupJoin.addElem(nchks[c], chks[c], i);
                    }
                    while (c < nchks.length) {
                        nchks[c].addNA();
                        ++c;
                    }
                    continue;
                }
                if (hashed._dups != null) {
                    for (long absrow : hashed._dups) {
                        this.addRow(nchks, chks, vecs, i, absrow, bStr);
                    }
                    continue;
                }
                this.addRow(nchks, chks, vecs, i, hashed._row, bStr);
            }
        }

        void addRow(NewChunk[] nchks, Chunk[] chks, Vec[] vecs, int relRow, long absRow, BufferedString bStr) {
            int c;
            for (c = 0; c < chks.length; ++c) {
                AllRiteWithDupJoin.addElem(nchks[c], chks[c], relRow);
            }
            while (c < nchks.length) {
                AllRiteWithDupJoin.addElem(nchks[c], vecs[c - (chks.length + this._ncols)], absRow, bStr);
                ++c;
            }
        }
    }

    private static class AllLeftNoDupe
    extends JoinTask {
        AllLeftNoDupe(int ncols, IcedHashMap<Row, String> rows, Frame hashed, boolean allRite) {
            super(ncols, rows, hashed, true, allRite);
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] nchks) {
            IcedHashMap rows = this._rows;
            Vec[] vecs = this._hashed.vecs();
            assert (vecs.length == this._ncols + nchks.length);
            Row row = new Row(this._ncols);
            BufferedString bStr = new BufferedString();
            int len = chks[0]._len;
            for (int i = 0; i < len; ++i) {
                Row hashed = rows.getk(row.fill(chks, null, i));
                if (hashed == null) {
                    for (NewChunk nc : nchks) {
                        nc.addNA();
                    }
                    continue;
                }
                long absrow = hashed._row;
                for (int c = 0; c < nchks.length; ++c) {
                    AllLeftNoDupe.addElem(nchks[c], vecs[this._ncols + c], absrow, bStr);
                }
            }
        }
    }

    private static abstract class JoinTask
    extends MRTask<JoinTask> {
        protected final IcedHashMap<Row, String> _rows;
        protected final int _ncols;
        protected final Frame _hashed;
        protected final boolean _allLeft;
        protected final boolean _allRite;

        JoinTask(int ncols, IcedHashMap<Row, String> rows, Frame hashed, boolean allLeft, boolean allRite) {
            this._rows = rows;
            this._ncols = ncols;
            this._hashed = hashed;
            this._allLeft = allLeft;
            this._allRite = allRite;
        }

        protected static void addElem(NewChunk nc, Chunk c, int row) {
            if (c.isNA(row)) {
                nc.addNA();
            } else if (c instanceof CStrChunk) {
                nc.addStr(c, row);
            } else if (c instanceof C16Chunk) {
                nc.addUUID(c, row);
            } else if (c.hasFloat()) {
                nc.addNum(c.atd(row));
            } else {
                nc.addNum(c.at8(row), 0);
            }
        }

        protected static void addElem(NewChunk nc, Vec v, long absRow, BufferedString bStr) {
            switch (v.get_type()) {
                case 3: {
                    nc.addNum(v.at(absRow));
                    break;
                }
                case 4: 
                case 5: {
                    if (v.isNA(absRow)) {
                        nc.addNA();
                        break;
                    }
                    nc.addNum(v.at8(absRow));
                    break;
                }
                case 2: {
                    nc.addStr(v.atStr(bStr, absRow));
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
        }
    }

    private static class MergeSet
    extends MRTask<MergeSet> {
        static IcedHashMap<Key, MergeSet> MERGE_SETS = new IcedHashMap();
        final Key _uniq = Key.make();
        final int _ncols;
        final int[][] _id_maps;
        final boolean _allRite;
        boolean _dup;
        IcedHashMap<Row, String> _rows;

        MergeSet(int ncols, int[][] id_maps, boolean allRite) {
            this._ncols = ncols;
            this._id_maps = id_maps;
            this._allRite = allRite;
        }

        @Override
        public void setupLocal() {
            this._rows = new IcedHashMap();
            MERGE_SETS.put(this._uniq, this);
        }

        @Override
        public void map(Chunk[] chks) {
            IcedHashMap<Row, String> rows = ((MergeSet)MergeSet.MERGE_SETS.get((Object)this._uniq))._rows;
            if (rows == null) {
                return;
            }
            int len = chks[0]._len;
            Row row = new Row(this._ncols);
            for (int i = 0; i < len; ++i) {
                if (!this.add(rows, row.fill(chks, this._id_maps, i))) continue;
                if (rows.size() > 120000000) {
                    this.abort();
                    return;
                }
                row = new Row(this._ncols);
            }
        }

        private boolean add(IcedHashMap<Row, String> rows, Row row) {
            if (rows.putIfAbsent(row, "") == null) {
                return true;
            }
            if (this._allRite) {
                this._dup = true;
                rows.getk(row).atomicAddDup(row._row);
            }
            return false;
        }

        private void abort() {
            this._rows = null;
            ((MergeSet)MergeSet.MERGE_SETS.get((Object)this._uniq))._rows = null;
        }

        @Override
        public void reduce(MergeSet ms) {
            IcedHashMap<Row, String> rows = this._rows;
            if (rows == ms._rows) {
                return;
            }
            if (rows == null || ms._rows == null) {
                this.abort();
                return;
            }
            for (Row row : ms._rows.keySet()) {
                this.add(rows, row);
            }
        }
    }

    private static class Row
    extends Iced {
        final long[] _keys;
        int _hash;
        long _row;
        long[] _dups;
        int _dupIdx;

        Row(int ncols) {
            this._keys = new long[ncols];
        }

        Row fill(Chunk[] chks, int[][] cat_maps, int row) {
            long hash = 0L;
            for (int i = 0; i < this._keys.length; ++i) {
                long l;
                if (chks[i].isNA(row)) {
                    l = 0L;
                } else {
                    l = chks[i].at8(row);
                    l = cat_maps == null || cat_maps[i] == null ? l : (long)cat_maps[i][(int)l];
                    hash += l;
                }
                this._keys[i] = l;
            }
            this._hash = (int)(hash ^ hash >> 32);
            this._row = chks[0].start() + (long)row;
            return this;
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Row)) {
                return false;
            }
            Row r = (Row)o;
            return this._hash == r._hash && Arrays.equals(this._keys, r._keys);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void atomicAddDup(long row) {
            Row row2 = this;
            synchronized (row2) {
                if (this._dups == null) {
                    this._dups = new long[]{this._row, row};
                    this._dupIdx = 2;
                } else if (this._dupIdx == this._dups.length) {
                    this._dups = Arrays.copyOf(this._dups, this._dupIdx >> 1);
                }
                this._dups[this._dupIdx++] = row;
            }
        }
    }
}

