/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import org.joda.time.MutableDateTime;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTExec;
import water.rapids.ASTId;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValNum;

class ASTMktime
extends ASTPrim {
    ASTMktime() {
    }

    @Override
    public String[] args() {
        return new String[]{"yr", "mo", "dy", "hr", "mi", "se", "ms"};
    }

    @Override
    int nargs() {
        return 8;
    }

    @Override
    public String str() {
        return "mktime";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame[] fs = new Frame[this.nargs() - 1];
        int[] is = new int[this.nargs() - 1];
        Frame x = null;
        for (int i = 1; i < this.nargs(); ++i) {
            if (asts[i] instanceof ASTId || asts[i] instanceof ASTExec) {
                fs[i - 1] = x = stk.track(asts[i].exec(env)).getFrame();
                continue;
            }
            is[i - 1] = (int)asts[i].exec(env).getNum();
        }
        if (x == null) {
            long msec = new MutableDateTime(is[0], is[1] + 1, is[2] + 1, is[3], is[4], is[5], is[6]).getMillis();
            return new ValNum(msec);
        }
        Vec[] vecs = new Vec[7];
        for (int i = 0; i < 7; ++i) {
            if (fs[i] == null) {
                vecs[i] = x.anyVec().makeCon(is[i]);
                continue;
            }
            if (fs[i].numCols() != 1) {
                throw new IllegalArgumentException("Expect single column");
            }
            vecs[i] = fs[i].anyVec();
        }
        Frame fr2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] nchks) {
                MutableDateTime dt = new MutableDateTime(0L);
                NewChunk n = nchks[0];
                int rlen = chks[0]._len;
                for (int r = 0; r < rlen; ++r) {
                    dt.setDateTime((int)chks[0].at8(r), (int)chks[1].at8(r) + 1, (int)chks[2].at8(r) + 1, (int)chks[3].at8(r), (int)chks[4].at8(r), (int)chks[5].at8(r), (int)chks[6].at8(r));
                    n.addNum(dt.getMillis());
                }
            }
        }.doAll(new byte[]{3}, vecs)).outputFrame(new String[]{"msec"}, null);
        for (int i = 0; i < this.nargs() - 1; ++i) {
            if (fs[i] != null) continue;
            vecs[i].remove();
        }
        return new ValFrame(fr2);
    }
}

